/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.accessories.components.AccessoryIncompatibility;
import com.majruszsaccessories.accessories.components.HarvestingDoubleCrops;
import com.majruszsaccessories.common.AccessoryHandler;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.common.components.TradeOffer;
import com.majruszsaccessories.events.OnAccessoryDropChanceGet;
import com.majruszsaccessories.items.AccessoryItem;
import net.minecraft.class_2246;

@AutoInstance
public class TamedPotatoBeetle
extends AccessoryHandler {
    public TamedPotatoBeetle() {
        super(MajruszsAccessories.TAMED_POTATO_BEETLE, TamedPotatoBeetle.class);
        this.add(HarvestingDoubleCrops.create(0.25f)).add(HarvestingDropChance.create()).add(TradeOffer.create()).add(AccessoryIncompatibility.create(MajruszsAccessories.NATURE_RUNE)).add(AccessoryIncompatibility.create(MajruszsAccessories.SOUL_OF_MINECRAFT));
    }

    static class HarvestingDropChance
    extends BonusComponent<AccessoryItem> {
        float chance = 0.0025f;
        float potatoMultiplier = 2.0f;

        public static BonusComponent.ISupplier<AccessoryItem> create() {
            return HarvestingDropChance::new;
        }

        protected HarvestingDropChance(BonusHandler<AccessoryItem> handler) {
            super(handler);
            HarvestingDoubleCrops.OnCropHarvested.listen(x$0 -> this.addToGeneratedLoot((OnLootGenerated)x$0)).addCondition(data -> {
                float chance = this.chance;
                if (data.blockState != null && data.blockState.method_26204().equals(class_2246.field_10247)) {
                    chance *= this.potatoMultiplier;
                }
                return ((OnAccessoryDropChanceGet)Events.dispatch((Object)new OnAccessoryDropChanceGet(chance, data.entity))).check();
            });
            handler.getConfig().define("harvesting_drop", subconfig -> {
                subconfig.define("harvesting_chance", Reader.number(), s -> Float.valueOf(this.chance), (s, v) -> {
                    this.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
                });
                subconfig.define("potato_multiplier", Reader.number(), s -> Float.valueOf(this.potatoMultiplier), (s, v) -> {
                    this.potatoMultiplier = ((Float)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
                });
            });
        }
    }
}

