/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.events.OnEntitySwimSpeedMultiplierGet;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;

public class SwimmingSpeedBonus
extends BonusComponent<AccessoryItem> {
    RangedFloat multiplier = new RangedFloat().id("multiplier").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float bonus) {
        return handler -> new SwimmingSpeedBonus(handler, bonus);
    }

    protected SwimmingSpeedBonus(BonusHandler<AccessoryItem> handler, float bonus) {
        super(handler);
        this.multiplier.set(bonus, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)));
        OnEntitySwimSpeedMultiplierGet.listen(this::increaseSwimSpeed);
        this.addTooltip("majruszsaccessories.bonuses.swim_bonus", TooltipHelper.asPercent(this.multiplier));
        handler.getConfig().define("swim_speed", this.multiplier::define);
    }

    private void increaseSwimSpeed(OnEntitySwimSpeedMultiplierGet data) {
        AccessoryHolder holder = AccessoryHolders.get(data.entity).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        data.multiplier *= 1.0f + holder.apply(this.multiplier);
        if (data.entity.method_5799() && data.getLevel() instanceof class_3218 && TimeHelper.haveTicksPassed((int)5)) {
            this.spawnEffects(data, holder);
        }
    }

    private void spawnEffects(OnEntitySwimSpeedMultiplierGet data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(1).sizeBased((class_1297)data.entity).emit((class_1937)data.getServerLevel());
    }
}

