/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.boosters.components;

import com.majruszlibrary.data.SerializableObject;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.events.OnAccessoryDropChanceGet;
import com.majruszsaccessories.items.BoosterItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.class_1309;

public class AccessoryDropChance
extends BonusComponent<BoosterItem> {
    RangedFloat multiplier = new RangedFloat().id("accessory_drop_chance_multiplier");

    public static BonusComponent.ISupplier<BoosterItem> create(float multiplier) {
        return handler -> new AccessoryDropChance(handler, multiplier);
    }

    protected AccessoryDropChance(BonusHandler<BoosterItem> handler, float multiplier) {
        super(handler);
        this.multiplier.set(multiplier, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)));
        OnAccessoryDropChanceGet.listen(this::increaseChance);
        this.addTooltip("majruszsaccessories.boosters.drop_chance", TooltipHelper.asBooster(() -> (BoosterItem)((Object)((Object)this.getItem()))), TooltipHelper.asFixedPercent(this.multiplier));
        this.multiplier.define((SerializableObject<?>)handler.getConfig());
    }

    private void increaseChance(OnAccessoryDropChanceGet data) {
        data.chance += data.original * this.multiplier.get() * (float)AccessoryHolders.get((class_1309)data.player).getBoostersCount(() -> (BoosterItem)((Object)((Object)this.getItem())));
    }
}

