/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.common;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.registry.Registries;
import com.majruszsaccessories.config.Config;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.config.RangedInteger;
import com.majruszsaccessories.events.OnAccessoryExtraBonusGet;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.items.BoosterItem;
import com.majruszsaccessories.mixininterfaces.IMixinItemStack;
import com.majruszsaccessories.particles.BonusParticleType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2394;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class AccessoryHolder {
    public static final AccessoryHolder EMPTY = new AccessoryHolder(class_1799.field_8037);
    final class_1799 itemStack;
    final AccessoryItem item;
    final Data data;
    boolean isBonusDisabled = false;

    public static AccessoryHolder create(class_1792 item) {
        return new AccessoryHolder(new class_1799((class_1935)item));
    }

    public static AccessoryHolder create(class_1799 itemStack) {
        return new AccessoryHolder(itemStack);
    }

    public static AccessoryHolder getOrCreate(class_1799 itemStack) {
        return ((IMixinItemStack)itemStack).majruszsaccessories$getOrCreateAccessoryHolder();
    }

    public static int apply(float bonus, RangedInteger value, int multiplier) {
        return (Integer)value.getRange().clamp((Number)Math.round((1.0f + (float)multiplier * bonus) * (float)value.get()));
    }

    public static float apply(float bonus, RangedFloat value, float multiplier) {
        return ((Float)value.getRange().clamp((Number)Float.valueOf((1.0f + multiplier * bonus) * value.get()))).floatValue();
    }

    public static class_124 getBonusFormatting(float bonus) {
        if (bonus > ((Float)Config.Efficiency.RANGE.to).floatValue()) {
            return class_124.field_1062;
        }
        if (bonus == ((Float)Config.Efficiency.RANGE.to).floatValue()) {
            return class_124.field_1065;
        }
        if (bonus > 0.0f) {
            return class_124.field_1060;
        }
        if (bonus == 0.0f) {
            return class_124.field_1080;
        }
        return class_124.field_1061;
    }

    public static class_1814 getRarity(float bonus) {
        if (bonus >= ((Float)Config.Efficiency.RANGE.to).floatValue()) {
            return class_1814.field_8904;
        }
        if (bonus >= 0.0f) {
            return class_1814.field_8903;
        }
        return class_1814.field_8907;
    }

    public static ParticleEmitter getParticleEmitter(float bonus) {
        return ParticleEmitter.of((class_2394)new BonusParticleType.Options(AccessoryHolder.getRarity((float)bonus).field_8908.method_532()));
    }

    private AccessoryHolder(class_1799 itemStack, Data data) {
        AccessoryItem item;
        this.itemStack = itemStack;
        class_1792 class_17922 = itemStack.method_7909();
        this.item = class_17922 instanceof AccessoryItem ? (item = (AccessoryItem)class_17922) : null;
        this.data = data;
        this.data.extraBonus = Float.valueOf(AccessoryHolder.round(((OnAccessoryExtraBonusGet)Events.dispatch((Object)new OnAccessoryExtraBonusGet((AccessoryHolder)this))).bonus));
        ((IMixinItemStack)itemStack).majruszsaccessories$setAccessoryHolder(this);
    }

    private AccessoryHolder(class_1799 itemStack) {
        this(itemStack, itemStack.method_7969() != null ? (Data)Serializables.read((Object)new Data(), (class_2520)itemStack.method_7969()) : new Data());
    }

    public AccessoryHolder copy() {
        return new AccessoryHolder(new class_1799((class_1935)this.item), new Data(this.data));
    }

    public int apply(RangedInteger value, int multiplier) {
        return AccessoryHolder.apply(this.getBonus(), value, multiplier);
    }

    public int apply(RangedInteger value) {
        return this.apply(value, 1);
    }

    public float apply(RangedFloat value, float multiplier) {
        return AccessoryHolder.apply(this.getBonus(), value, multiplier);
    }

    public float apply(RangedFloat value) {
        return this.apply(value, 1.0f);
    }

    public AccessoryHolder setRandomBonus() {
        if (this.hasBonusRangeDefined()) {
            float bonus = Optional.ofNullable(this.data.randomType).orElse(RandomType.RANDOM).get(this.data.range);
            return this.setBonus(((Float)Config.Efficiency.RANGE.clamp((Number)Float.valueOf(bonus))).floatValue());
        }
        return this.setBonus(Config.Efficiency.getRandom());
    }

    public AccessoryHolder setBonus(float bonus) {
        return this.save(() -> {
            this.data.baseBonus = Float.valueOf(AccessoryHolder.round(bonus));
            this.data.extraBonus = Float.valueOf(AccessoryHolder.round(((OnAccessoryExtraBonusGet)Events.dispatch((Object)new OnAccessoryExtraBonusGet((AccessoryHolder)this))).bonus));
        });
    }

    public AccessoryHolder setBonus(Range<Float> bonus, RandomType randomType) {
        if (((Float)bonus.to).floatValue() - ((Float)bonus.from).floatValue() > 1.0E-5f) {
            return this.save(() -> {
                this.data.baseBonus = null;
                this.data.extraBonus = null;
                this.data.randomType = randomType;
                this.data.range = Range.of((Number)Float.valueOf(AccessoryHolder.round(((Float)bonus.from).floatValue())), (Number)Float.valueOf(AccessoryHolder.round(((Float)bonus.to).floatValue())));
            });
        }
        return this.setBonus(((Float)bonus.from).floatValue());
    }

    public AccessoryHolder setBonus(Range<Float> bonus) {
        return this.setBonus(bonus, null);
    }

    public AccessoryHolder addBooster(BoosterItem item) {
        return this.save(() -> this.data.boosters.add(new BoosterDef(item)));
    }

    public AccessoryHolder removeBonus() {
        return this.save(() -> {
            this.data.baseBonus = null;
            this.data.extraBonus = null;
        });
    }

    public AccessoryHolder removeBoosters() {
        return this.save(() -> this.data.boosters.clear());
    }

    public AccessoryHolder disableBonus() {
        this.isBonusDisabled = true;
        return this;
    }

    public float getBonus() {
        return AccessoryHolder.round(this.getBaseBonus() + this.getExtraBonus());
    }

    public float getBaseBonus() {
        return this.data.baseBonus != null ? this.data.baseBonus.floatValue() : 0.0f;
    }

    public float getExtraBonus() {
        return this.data.extraBonus != null ? this.data.extraBonus.floatValue() : 0.0f;
    }

    public Range<Float> getBonusRange() {
        return this.data.range;
    }

    public Range<Float> getClampedBonusRange() {
        return Config.Efficiency.RANGE.clamp(this.data.range);
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public AccessoryItem getItem() {
        return this.item;
    }

    public List<BoosterItem> getBoosters() {
        return this.data.boosters.stream().map(booster -> booster.item).toList();
    }

    public int getBoosterSlotsLeft() {
        return Math.max(this.item.getBoosterSlotsCount() - this.data.boosters.size(), 0);
    }

    public int getTier() {
        return this.item.getTier();
    }

    public class_124 getBonusFormatting() {
        return AccessoryHolder.getBonusFormatting(this.getBonus());
    }

    public class_1814 getRarity() {
        return AccessoryHolder.getRarity(this.getBonus());
    }

    public ParticleEmitter getParticleEmitter() {
        return AccessoryHolder.getParticleEmitter(this.getBonus());
    }

    public boolean is(AccessoryItem item) {
        return this.item == item;
    }

    public boolean isValid() {
        return this.item != null;
    }

    public boolean isBonusDisabled() {
        return this.isBonusDisabled;
    }

    public boolean hasBonusDefined() {
        return this.data.baseBonus != null;
    }

    public boolean hasBonusRangeDefined() {
        return this.data.range != null;
    }

    public boolean hasMaxBonus() {
        return this.getBaseBonus() == ((Float)Config.Efficiency.RANGE.to).floatValue();
    }

    public boolean has(BoosterItem item) {
        return this.data.boosters.stream().anyMatch(booster -> booster.item == item);
    }

    public boolean hasAnyBooster() {
        return !this.data.boosters.isEmpty();
    }

    private AccessoryHolder save(Runnable runnable) {
        runnable.run();
        Serializables.write((Object)this.data, (class_2520)this.itemStack.method_7948());
        return this;
    }

    private static float round(float value) {
        return (float)Math.round(100.0f * value) / 100.0f;
    }

    private static class Data {
        Float baseBonus = null;
        Float extraBonus = Float.valueOf(0.0f);
        Range<Float> range = null;
        RandomType randomType = null;
        List<BoosterDef> boosters = List.of();

        public Data(Data data) {
            this.baseBonus = data.baseBonus;
            this.range = data.range != null ? Range.of((Number)((Float)data.range.from), (Number)((Float)data.range.to)) : null;
            this.randomType = data.randomType;
            this.boosters = new ArrayList<BoosterDef>(data.boosters);
        }

        public Data() {
        }

        static {
            Serializables.get(Data.class).define("Bonus", subconfig -> {
                subconfig.define("Value", Reader.optional((IReader)Reader.number()), s -> s.baseBonus, (s, v) -> {
                    s.baseBonus = v;
                });
                subconfig.define("ValueRange", Reader.optional((IReader)Reader.range((IReader)Reader.number())), s -> s.range, (s, v) -> {
                    s.range = v;
                });
                subconfig.define("ValueRandomType", Reader.optional((IReader)Reader.enumeration(RandomType::values)), s -> s.randomType, (s, v) -> {
                    s.randomType = v;
                });
                subconfig.define("Boosters", Reader.list((IReader)Reader.custom(BoosterDef::new)), s -> s.boosters, (s, v) -> {
                    s.boosters = v;
                });
            });
        }
    }

    public static enum RandomType {
        RANDOM(() -> Float.valueOf(Random.nextFloat((float)0.0f, (float)1.0f))),
        NORMAL_DISTRIBUTION(() -> Float.valueOf(Config.Efficiency.getGaussianRatio()));

        private final Supplier<Float> ratio;

        private RandomType(Supplier<Float> ratio) {
            this.ratio = ratio;
        }

        float get(Range<Float> range) {
            return range.lerp(this.ratio.get().floatValue());
        }
    }

    private static class BoosterDef {
        BoosterItem item = null;
        class_2960 id = null;

        public BoosterDef(BoosterItem item) {
            this.item = item;
            this.id = Registries.ITEMS.getId((Object)item);
        }

        public BoosterDef() {
        }

        static {
            Serializables.get(BoosterDef.class).define("Id", Reader.location(), s -> s.id, (s, v) -> {
                BoosterItem booster;
                Object patt9680$temp = Registries.ITEMS.get(v);
                s.item = patt9680$temp instanceof BoosterItem ? (booster = (BoosterItem)((Object)((Object)patt9680$temp))) : null;
                s.id = v;
            });
        }
    }
}

