/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.majruszlibrary.MajruszLibrary;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.ISerializable;
import com.majruszlibrary.data.ReaderKey;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class SerializableObject<Type>
implements ISerializable<Type> {
    protected final List<ISerializable<Type>> serializables = new ArrayList<ISerializable<Type>>();
    protected final Class<Type> clazz;

    @Override
    public <JsonType extends JsonElement> JsonType writeJson(Type value, JsonType json) {
        this.serializables.forEach(serializable -> serializable.writeJson(value, json));
        return json;
    }

    @Override
    public class_2540 writeBuffer(Type value, class_2540 buffer) {
        this.serializables.forEach(serializable -> serializable.writeBuffer(value, buffer));
        return buffer;
    }

    @Override
    public <TagType extends class_2520> TagType writeTag(Type value, TagType tag) {
        this.serializables.forEach(serializable -> serializable.writeTag(value, tag));
        return tag;
    }

    @Override
    public Type readJson(Type value, JsonElement json) {
        this.serializables.forEach(serializable -> {
            try {
                serializable.readJson(value, json);
            }
            catch (Exception exception) {
                MajruszLibrary.HELPER.logDebug("Failed to serialize %s: %s\n%s", exception, this.clazz.getName());
            }
        });
        return value;
    }

    @Override
    public Type readBuffer(Type value, class_2540 buffer) {
        this.serializables.forEach(serializable -> {
            try {
                serializable.readBuffer(value, buffer);
            }
            catch (Exception exception) {
                MajruszLibrary.HELPER.logDebug("Failed to serialize %s: %s\n%s", exception, this.clazz.getName());
            }
        });
        return value;
    }

    @Override
    public Type readTag(Type value, class_2520 tag) {
        this.serializables.forEach(serializable -> {
            try {
                serializable.readTag(value, tag);
            }
            catch (Exception exception) {
                MajruszLibrary.HELPER.logDebug("Failed to serialize %s: %s\n%s", exception, this.clazz.getName());
            }
        });
        return value;
    }

    public <ValueType> SerializableObject<Type> define(String id, IReader<ValueType> reader, Function<Type, ValueType> getter, BiConsumer<Type, ValueType> setter) {
        this.serializables.add(new ReaderKey<Type, ValueType>(id, reader, getter, setter));
        return this;
    }

    SerializableObject(Class<Type> clazz) {
        this.clazz = clazz;
    }

    public SerializableObject<Type> define(final String id, Consumer<SerializableObject<Type>> consumer) {
        final SerializableObject<Type> subobject = new SerializableObject<Type>(this.clazz);
        consumer.accept(subobject);
        this.serializables.add(new ISerializable<Type>(){

            @Override
            public <JsonType extends JsonElement> JsonType writeJson(Type value, JsonType json) {
                JsonObject jsonObject = json.getAsJsonObject();
                JsonObject subjson = subobject.writeJson(value, new JsonObject());
                if (subjson != null) {
                    jsonObject.add(id, (JsonElement)subjson);
                }
                return json;
            }

            @Override
            public class_2540 writeBuffer(Type value, class_2540 buffer) {
                subobject.writeBuffer(value, buffer);
                return buffer;
            }

            @Override
            public <TagType extends class_2520> TagType writeTag(Type value, TagType tag) {
                class_2487 compoundTag = (class_2487)tag;
                class_2487 subtag = subobject.writeTag(value, new class_2487());
                if (subtag != null) {
                    compoundTag.method_10566(id, (class_2520)subtag);
                }
                return tag;
            }

            @Override
            public Type readJson(Type value, JsonElement json) {
                JsonObject jsonObject = json.getAsJsonObject();
                if (jsonObject.has(id)) {
                    subobject.readJson(value, jsonObject.get(id));
                }
                return value;
            }

            @Override
            public Type readBuffer(Type value, class_2540 buffer) {
                subobject.readBuffer(value, buffer);
                return value;
            }

            @Override
            public Type readTag(Type value, class_2520 tag) {
                class_2487 compoundTag = (class_2487)tag;
                if (compoundTag.method_10545(id)) {
                    subobject.readTag(value, compoundTag.method_10580(id));
                }
                return value;
            }
        });
        return this;
    }
}

