/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.entity;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;

public class AttributeHandler {
    final UUID uuid;
    final String name;
    final Supplier<class_1320> attribute;
    final class_1322.class_1323 operation;
    double value = 0.0;

    public AttributeHandler(String uuid, String name, Supplier<class_1320> attribute, class_1322.class_1323 operation) {
        this.uuid = UUID.fromString(uuid);
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
    }

    public AttributeHandler(String name, Supplier<class_1320> attribute, class_1322.class_1323 operation) {
        this.uuid = UUID.nameUUIDFromBytes(name.getBytes());
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
    }

    public boolean hasAttribute(class_1309 entity) {
        return entity.method_6127().method_27306(this.attribute.get());
    }

    public boolean hasValueChanged(class_1324 attributeInstance) {
        class_1322 modifier = attributeInstance.method_6199(this.uuid);
        return modifier == null || modifier.method_6186() != this.value;
    }

    public double getValue() {
        return this.value;
    }

    public AttributeHandler setValue(double value) {
        this.value = value;
        return this;
    }

    public AttributeHandler apply(class_1309 entity) {
        class_1324 attributeInstance = entity.method_5996(this.attribute.get());
        if (attributeInstance != null && this.hasValueChanged(attributeInstance)) {
            attributeInstance.method_6200(this.uuid);
            attributeInstance.method_26835(this.createAttribute());
        }
        return this;
    }

    public AttributeHandler remove(class_1309 entity) {
        class_1324 attributeInstance = entity.method_5996(this.attribute.get());
        if (attributeInstance != null) {
            attributeInstance.method_6200(this.uuid);
        }
        return this;
    }

    public class_1322 createAttribute() {
        return new class_1322(this.uuid, this.name, this.value, this.operation);
    }

    public UUID getUUID() {
        return this.uuid;
    }
}

