/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.events.base;

import com.majruszlibrary.events.type.ILevelEvent;
import com.majruszlibrary.events.type.IPositionEvent;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.time.TimeHelper;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public class Condition<DataType> {
    final Predicate<DataType> predicate;
    boolean isNegated = false;

    public static <DataType> Condition<DataType> isLogicalServer() {
        return new Condition<Object>(data -> Side.isLogicalServer());
    }

    public static <DataType extends ILevelEvent> Condition<DataType> hasLevel() {
        return new Condition<ILevelEvent>(data -> data.getLevel() != null);
    }

    public static <DataType> Condition<DataType> predicate(Predicate<DataType> predicate) {
        return new Condition<DataType>(predicate);
    }

    public static <DataType> Condition<DataType> predicate(Supplier<Boolean> check) {
        return new Condition<Object>(data -> (Boolean)check.get());
    }

    public static <DataType> Condition<DataType> chance(Supplier<Float> chance) {
        return new Condition<Object>(data -> Random.check(((Float)chance.get()).floatValue()));
    }

    public static <DataType> Condition<DataType> chance(float chance) {
        return Condition.chance(() -> Float.valueOf(chance));
    }

    public static <DataType extends ILevelEvent & IPositionEvent> Condition<DataType> chanceCRD(Supplier<Float> chance, Supplier<Boolean> scaledByCRD) {
        return new Condition<ILevelEvent>(data -> {
            float totalChance = ((Float)chance.get()).floatValue();
            if (((Boolean)scaledByCRD.get()).booleanValue() && data.getLevel() != null) {
                totalChance = (float)((double)totalChance * LevelHelper.getClampedRegionalDifficultyAt(data.getLevel(), AnyPos.from(((IPositionEvent)((Object)data)).getPosition()).block()));
            }
            return Random.check(totalChance);
        });
    }

    public static <DataType extends ILevelEvent & IPositionEvent> Condition<DataType> chanceCRD(float chance, boolean scaledByCRD) {
        return Condition.chanceCRD(() -> Float.valueOf(chance), () -> scaledByCRD);
    }

    public static <DataType> Condition<DataType> cooldown(Supplier<Float> seconds) {
        return new Condition<Object>(data -> TimeHelper.haveSecondsPassed(((Float)seconds.get()).floatValue()));
    }

    public static <DataType> Condition<DataType> cooldown(float seconds) {
        return Condition.cooldown(() -> Float.valueOf(seconds));
    }

    public static <DataType> Condition<DataType> isShiftKeyDown(Function<DataType, class_1657> player) {
        return new Condition<Object>(data -> player.apply(data) != null && ((class_1657)player.apply(data)).method_5715());
    }

    public static <DataType> Condition<DataType> isOnGround(Function<DataType, class_1297> entity) {
        return new Condition<Object>(data -> entity.apply(data) != null && ((class_1297)entity.apply(data)).method_24828());
    }

    public static <DataType> Condition<DataType> isCooldownOver(Function<DataType, class_1657> player, Supplier<? extends class_1792> item) {
        return new Condition<Object>(data -> player.apply(data) != null && !((class_1657)player.apply(data)).method_7357().method_7904((class_1792)item.get()));
    }

    public static <DataType extends ILevelEvent> Condition<DataType> isLevel(List<class_2960> levels) {
        return new Condition<ILevelEvent>(data -> levels.contains(data.getLevel().method_27983().method_29177()));
    }

    public Condition<DataType> negate() {
        this.isNegated = !this.isNegated;
        return this;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public boolean check(DataType data) {
        return this.isNegated ^ this.predicate.test(data);
    }

    private Condition(Predicate<DataType> predicate) {
        this.predicate = predicate;
    }
}

