/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.modhelper;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.majruszlibrary.animations.AnimationsDef;
import com.majruszlibrary.animations.ModelDef;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnPlayerLoggedIn;
import com.majruszlibrary.events.OnResourcesReloaded;
import com.majruszlibrary.modhelper.IResourcePlatform;
import com.majruszlibrary.modhelper.ModHelper;
import com.majruszlibrary.modhelper.Resource;
import com.majruszlibrary.network.NetworkObject;
import com.majruszlibrary.platform.Services;
import com.majruszlibrary.platform.Side;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5270;

class ResourceLoader {
    static final Map<String, ResourceLoader> LOADERS = Collections.synchronizedMap(new HashMap());
    static final IResourcePlatform PLATFORM = Services.load(IResourcePlatform.class);
    final ModHelper helper;
    final Gson gson;
    final NetworkObject<Message> network;
    final String name = "custom";
    Server server;
    @Environment(value=EnvType.CLIENT)
    Client client;

    public ResourceLoader(ModHelper helper) {
        this.helper = helper;
        this.gson = class_5270.method_27861().registerTypeAdapter(AnimationsDef.class, (Object)new AnimationAdapter()).registerTypeAdapter(ModelDef.class, (Object)new ModelAdapter()).create();
        this.network = this.helper.create("custom_data", Message.class);
        this.server = new Server(this);
        PLATFORM.register(this.helper.getLocation(this.name), this.server);
        OnResourcesReloaded.listen(data -> {
            if (Side.isDedicatedServer() && this.network != null) {
                this.network.sendToClients(this.getMessage());
            }
        });
        OnPlayerLoggedIn.listen(data -> {
            if (Side.isDedicatedServer() && this.network != null) {
                this.network.sendToClient(data.player, this.getMessage());
            }
        });
        Side.runOnClient(() -> () -> {
            this.client = new Client(this);
            this.network.addClientCallback(ResourceLoader::onClient);
        });
        LOADERS.put(this.helper.getModId(), this);
    }

    public <Type> Resource<Type> load(class_2960 id, Class<Type> clazz) {
        Resource<Type> resource = new Resource<Type>(clazz);
        this.server.resources.put(id.toString(), resource);
        return resource;
    }

    @Environment(value=EnvType.CLIENT)
    public <Type> Resource<Type> loadClient(class_2960 id, Class<Type> clazz) {
        Resource.Lazy<Type> resource = new Resource.Lazy<Type>(clazz, () -> this.client.loadResources(Side.getMinecraft().method_1478()));
        this.client.resources.put(id.toString(), resource);
        return resource;
    }

    private Message getMessage() {
        Message message = new Message();
        message.modId = this.helper.getModId();
        for (String id : this.server.resources.keySet()) {
            Resource<?> resource = this.server.resources.get(id);
            Object Type2 = resource.value;
            if (!(Type2 instanceof AnimationsDef)) continue;
            AnimationsDef animationsDef = (AnimationsDef)Type2;
            message.animations.put(id, animationsDef);
        }
        return message;
    }

    @Environment(value=EnvType.CLIENT)
    private static void onClient(Message message) {
        Server server = ResourceLoader.LOADERS.get((Object)message.modId).server;
        for (Map.Entry<String, AnimationsDef> entry : message.animations.entrySet()) {
            server.resources.get((Object)entry.getKey()).value = entry.getValue();
        }
    }

    static {
        Serializables.get(Message.class).define("mod_id", Reader.string(), s -> s.modId, (s, v) -> {
            s.modId = v;
        }).define("animations", Reader.map(Reader.custom(AnimationsDef::new)), s -> s.animations, (s, v) -> {
            s.animations = v;
        });
    }

    private static class AnimationAdapter
    implements JsonDeserializer<AnimationsDef> {
        private AnimationAdapter() {
        }

        public AnimationsDef deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return Serializables.read(new AnimationsDef(), json);
        }
    }

    private static class ModelAdapter
    implements JsonDeserializer<ModelDef> {
        private ModelAdapter() {
        }

        public ModelDef deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return Serializables.read(new ModelDef(), json);
        }
    }

    static class Message {
        String modId;
        Map<String, AnimationsDef> animations = new HashMap<String, AnimationsDef>();
    }

    static class Server
    extends class_4309 {
        final ResourceLoader loader;
        final Map<String, Resource<?>> resources = new HashMap();

        public Server(ResourceLoader loader) {
            super(loader.gson, loader.name);
            this.loader = loader;
        }

        protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profilerFiller) {
            for (String id : this.resources.keySet()) {
                this.resources.get(id).load(this.loader.gson, jsons.get(new class_2960(id)));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class Client {
        final ResourceLoader loader;
        final Map<String, Resource<?>> resources = new HashMap();

        public Client(ResourceLoader loader) {
            this.loader = loader;
        }

        public void loadResources(class_3300 resourceManager) {
            Map resources = resourceManager.method_14488(this.loader.name, file -> file.toString().endsWith(".json"));
            for (class_2960 id : resources.keySet()) {
                try {
                    this.resources.get(id.toString()).load(this.loader.gson, ((class_3298)resources.get(id)).method_43039());
                }
                catch (Exception exception) {
                    this.loader.helper.logError(exception.toString(), new Object[0]);
                }
            }
        }
    }
}

