/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.blocks.block_entity.pipe_nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.lunade.copper.blocks.block_entity.AbstractSimpleCopperBlockEntity;
import net.lunade.copper.blocks.block_entity.CopperPipeEntity;
import net.lunade.copper.registry.RegisterPipeNbtMethods;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MoveablePipeDataHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public ArrayList<SaveableMovablePipeNbt> savedList = new ArrayList();
    public ArrayList<class_2960> savedIds = new ArrayList();

    public void readNbt(@NotNull class_2487 nbtCompound) {
        if (nbtCompound.method_10573("saveableMoveableNbtList", 9)) {
            this.clear();
            DataResult var10000 = SaveableMovablePipeNbt.CODEC.listOf().parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbtCompound.method_10554("saveableMoveableNbtList", 10)));
            Logger var10001 = LOGGER;
            Objects.requireNonNull(var10001);
            Optional list = var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0));
            if (list.isPresent()) {
                for (SaveableMovablePipeNbt saveableMovablePipeNbt : (List)list.get()) {
                    if (!saveableMovablePipeNbt.shouldSave) continue;
                    this.addSaveableMoveablePipeNbt(saveableMovablePipeNbt);
                }
            }
        }
    }

    public void writeNbt(class_2487 nbtCompound) {
        DataResult var10000 = SaveableMovablePipeNbt.CODEC.listOf().encodeStart((DynamicOps)class_2509.field_11560, this.savedList);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(nbtElement -> nbtCompound.method_10566("saveableMoveableNbtList", nbtElement));
    }

    public void addSaveableMoveablePipeNbt(@NotNull SaveableMovablePipeNbt nbt) {
        if (!this.savedIds.contains(nbt.getNbtID())) {
            this.savedList.add(nbt);
            this.savedIds.add(nbt.getNbtID());
        }
    }

    @Nullable
    public SaveableMovablePipeNbt getMoveablePipeNbt(class_2960 id) {
        if (this.savedIds.contains(id) && !this.savedList.isEmpty()) {
            return this.savedList.get(this.savedIds.indexOf(id));
        }
        return null;
    }

    public void removeMoveablePipeNbt(class_2960 id) {
        if (this.savedIds.contains(id)) {
            this.savedList.remove(this.savedIds.indexOf(id));
            this.savedIds.remove(id);
        }
    }

    public void setMoveablePipeNbt(class_2960 id, SaveableMovablePipeNbt nbt) {
        if (this.savedIds.contains(id)) {
            this.savedList.set(this.savedIds.indexOf(id), nbt);
        } else {
            this.savedIds.add(id);
            this.savedList.add(nbt);
        }
    }

    public void clear() {
        this.savedList.clear();
        this.savedIds.clear();
    }

    public void clearAllButNonMoveable() {
        ArrayList<SaveableMovablePipeNbt> nbtToRemove = new ArrayList<SaveableMovablePipeNbt>();
        this.savedList.clear();
        this.savedIds.clear();
        for (SaveableMovablePipeNbt nbt : this.savedList) {
            if (!nbt.getShouldMove()) continue;
            nbtToRemove.add(nbt);
        }
        for (SaveableMovablePipeNbt nbt : nbtToRemove) {
            if (!this.savedList.contains(nbt)) continue;
            int index = this.savedList.indexOf(nbt);
            this.savedList.remove(index);
            this.savedIds.remove(index);
        }
    }

    public void clearAllButMoveable() {
        ArrayList<SaveableMovablePipeNbt> nbtToRemove = new ArrayList<SaveableMovablePipeNbt>();
        this.savedList.clear();
        this.savedIds.clear();
        for (SaveableMovablePipeNbt nbt : this.savedList) {
            if (nbt.getShouldMove()) continue;
            nbtToRemove.add(nbt);
        }
        for (SaveableMovablePipeNbt nbt : nbtToRemove) {
            if (!this.savedList.contains(nbt)) continue;
            int index = this.savedList.indexOf(nbt);
            this.savedList.remove(index);
            this.savedIds.remove(index);
        }
    }

    public ArrayList<SaveableMovablePipeNbt> getSavedNbtList() {
        return this.savedList;
    }

    public static class SaveableMovablePipeNbt {
        public static final Codec<SaveableMovablePipeNbt> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("savedID").forGetter(SaveableMovablePipeNbt::getSavedID), (App)class_243.field_38277.fieldOf("vec3d").forGetter(SaveableMovablePipeNbt::getVec3d), (App)class_243.field_38277.fieldOf("vec3d2").forGetter(SaveableMovablePipeNbt::getVec3d2), (App)Codec.STRING.fieldOf("string").forGetter(SaveableMovablePipeNbt::getString), (App)Codec.INT.fieldOf("useCount").forGetter(SaveableMovablePipeNbt::getUseCount), (App)class_2338.field_25064.fieldOf("blockPos").forGetter(SaveableMovablePipeNbt::getBlockPos), (App)Codec.BOOL.fieldOf("shouldSave").forGetter(SaveableMovablePipeNbt::getShouldSave), (App)Codec.BOOL.fieldOf("shouldMove").forGetter(SaveableMovablePipeNbt::getShouldMove), (App)Codec.BOOL.fieldOf("canOnlyBeUsedOnce").forGetter(SaveableMovablePipeNbt::getCanOnlyBeUsedOnce), (App)Codec.BOOL.fieldOf("canOnlyGoThroughOnePipe").forGetter(SaveableMovablePipeNbt::getCanOnlyGoThroughOnePipe), (App)Codec.BOOL.fieldOf("shouldCopy").forGetter(SaveableMovablePipeNbt::getShouldCopy), (App)class_2960.field_25139.fieldOf("nbtId").forGetter(SaveableMovablePipeNbt::getNbtID)).apply((Applicative)instance, SaveableMovablePipeNbt::new));
        public class_2960 savedID;
        public class_243 vec3d;
        public class_243 vec3d2;
        public String string;
        public int useCount;
        public class_2338 blockPos;
        public boolean shouldSave;
        public boolean shouldMove;
        public class_1297 foundEntity;
        private boolean canOnlyBeUsedOnce;
        private boolean canOnlyGoThroughOnePipe;
        private boolean shouldCopy;
        private class_2960 nbtID;

        public SaveableMovablePipeNbt(class_2960 id, class_243 vec3d, class_243 vec3d2, String string, int useCount, class_2338 blockPos, boolean shouldSave, boolean shouldMove, boolean canOnlyBeUsedOnce, boolean canOnlyGoThroughOnePipe, boolean shouldCopy, class_2960 nbtId) {
            this.savedID = id;
            this.vec3d = vec3d;
            this.vec3d2 = vec3d2;
            this.string = string;
            this.useCount = useCount;
            this.blockPos = blockPos;
            this.shouldSave = shouldSave;
            this.shouldMove = shouldMove;
            this.canOnlyBeUsedOnce = canOnlyBeUsedOnce;
            this.canOnlyGoThroughOnePipe = canOnlyGoThroughOnePipe;
            this.shouldCopy = shouldCopy;
            this.nbtID = nbtId;
        }

        public SaveableMovablePipeNbt(class_5712 event, class_243 originPos, @Nullable class_5712.class_7397 emitter, class_2338 pipePos) {
            this.savedID = class_7923.field_41171.method_10221((Object)event);
            this.vec3d = originPos;
            this.vec3d2 = originPos;
            this.string = emitter != null && emitter.comp_713() != null ? emitter.comp_713().method_5667().toString() : "noEntity";
            this.blockPos = pipePos;
            this.nbtID = class_2960.method_43902((String)"lunade", (String)"default");
            this.useCount = 0;
            this.canOnlyGoThroughOnePipe = false;
            this.canOnlyBeUsedOnce = false;
            this.shouldSave = true;
            this.shouldMove = true;
            this.shouldCopy = false;
        }

        public SaveableMovablePipeNbt(class_5712 event, class_243 originPos, @Nullable class_1297 entity, class_2338 pipePos) {
            this.savedID = class_7923.field_41171.method_10221((Object)event);
            this.vec3d = originPos;
            this.vec3d2 = originPos;
            this.string = entity != null ? entity.method_5667().toString() : "noEntity";
            this.blockPos = pipePos;
            this.nbtID = class_2960.method_43902((String)"lunade", (String)"default");
            this.useCount = 0;
            this.canOnlyGoThroughOnePipe = false;
            this.canOnlyBeUsedOnce = false;
            this.shouldSave = true;
            this.shouldMove = true;
            this.shouldCopy = false;
        }

        public SaveableMovablePipeNbt() {
            this.savedID = class_2960.method_43902((String)"lunade", (String)"none");
            this.vec3d = new class_243(0.0, -64.0, 0.0);
            this.vec3d2 = new class_243(0.0, -64.0, 0.0);
            this.string = "none";
            this.blockPos = new class_2338(0, -64, 0);
            this.nbtID = class_2960.method_43902((String)"lunade", (String)"none");
            this.useCount = 0;
            this.canOnlyGoThroughOnePipe = false;
            this.canOnlyBeUsedOnce = false;
            this.shouldSave = true;
            this.shouldMove = true;
            this.shouldCopy = false;
        }

        public SaveableMovablePipeNbt withSavedId(class_2960 id) {
            this.setNbtID(id);
            return this;
        }

        public SaveableMovablePipeNbt withVec3d(class_243 pos) {
            this.vec3d = pos;
            return this;
        }

        public SaveableMovablePipeNbt withVec3d2(class_243 pos) {
            this.vec3d2 = pos;
            return this;
        }

        public SaveableMovablePipeNbt withString(String string) {
            this.string = string;
            return this;
        }

        public SaveableMovablePipeNbt withUseCount(int count) {
            this.useCount = count;
            return this;
        }

        public SaveableMovablePipeNbt withBlockPos(class_2338 pos) {
            this.blockPos = pos;
            return this;
        }

        public SaveableMovablePipeNbt withShouldSave(boolean bool) {
            this.shouldSave = bool;
            return this;
        }

        public SaveableMovablePipeNbt withShouldMove(boolean bool) {
            this.shouldMove = bool;
            return this;
        }

        public SaveableMovablePipeNbt withOnlyUseableOnce(boolean bool) {
            this.canOnlyBeUsedOnce = bool;
            return this;
        }

        public SaveableMovablePipeNbt withOnlyThroughOnePipe(boolean bool) {
            this.canOnlyGoThroughOnePipe = bool;
            return this;
        }

        public SaveableMovablePipeNbt withShouldCopy(boolean bool) {
            this.shouldCopy = bool;
            return this;
        }

        public SaveableMovablePipeNbt withNBTID(class_2960 id) {
            this.setNbtID(id);
            return this;
        }

        public void dispense(class_3218 world, class_2338 pos, class_2680 state, CopperPipeEntity pipeEntity) {
            RegisterPipeNbtMethods.DispenseMethod method = RegisterPipeNbtMethods.getDispense(this.getNbtID());
            if (method != null) {
                method.dispense(this, world, pos, state, pipeEntity);
            }
        }

        public void onMove(class_3218 world, class_2338 pos, class_2680 state, AbstractSimpleCopperBlockEntity blockEntity) {
            RegisterPipeNbtMethods.OnMoveMethod method = RegisterPipeNbtMethods.getMove(this.getNbtID());
            if (method != null) {
                method.onMove(this, world, pos, state, blockEntity);
            }
        }

        public void tick(class_3218 world, class_2338 pos, class_2680 state, AbstractSimpleCopperBlockEntity blockEntity) {
            RegisterPipeNbtMethods.TickMethod method = RegisterPipeNbtMethods.getTick(this.getNbtID());
            if (method != null) {
                method.tick(this, world, pos, state, blockEntity);
            }
        }

        public boolean canMove(class_3218 world, class_2338 pos, class_2680 state, AbstractSimpleCopperBlockEntity blockEntity) {
            RegisterPipeNbtMethods.CanMoveMethod method = RegisterPipeNbtMethods.getCanMove(this.getNbtID());
            if (method != null) {
                return method.canMove(this, world, pos, state, blockEntity);
            }
            return true;
        }

        @Nullable
        public class_1297 getEntity(class_1937 world) {
            if (!this.string.equals("noEntity")) {
                if (this.foundEntity != null) {
                    if (this.foundEntity.method_5667().toString().equals(this.string)) {
                        return this.foundEntity;
                    }
                    this.foundEntity = null;
                }
                class_238 box = new class_238(this.vec3d2.method_1031(-32.0, -32.0, -32.0), this.vec3d2.method_1031(32.0, 32.0, 32.0));
                List entities = world.method_18467(class_1297.class, box);
                for (class_1297 entity : entities) {
                    if (!entity.method_5667().toString().equals(this.string)) continue;
                    this.foundEntity = entity;
                    this.vec3d2 = entity.method_19538();
                    return entity;
                }
            }
            return null;
        }

        public class_2960 getSavedID() {
            return this.savedID;
        }

        public class_243 getVec3d() {
            return this.vec3d;
        }

        public class_243 getVec3d2() {
            return this.vec3d2;
        }

        public String getString() {
            return this.string;
        }

        public int getUseCount() {
            return this.useCount;
        }

        public class_2338 getBlockPos() {
            return this.blockPos;
        }

        public boolean getShouldSave() {
            return this.shouldSave;
        }

        public boolean getShouldMove() {
            return this.shouldMove;
        }

        public boolean getCanOnlyBeUsedOnce() {
            return this.canOnlyBeUsedOnce;
        }

        public boolean getCanOnlyGoThroughOnePipe() {
            return this.canOnlyGoThroughOnePipe;
        }

        public boolean getShouldCopy() {
            return this.shouldCopy;
        }

        public class_2960 getNbtID() {
            return this.nbtID;
        }

        public void setNbtID(class_2960 id) {
            this.nbtID = id;
        }

        public SaveableMovablePipeNbt copyOf() {
            return new SaveableMovablePipeNbt(this.savedID, this.vec3d, this.vec3d2, this.string, this.useCount, this.blockPos, this.shouldSave, this.shouldMove, this.canOnlyBeUsedOnce, this.canOnlyGoThroughOnePipe, this.shouldCopy, this.nbtID);
        }
    }
}

