/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2754;
import net.minecraft.class_2891;
import net.minecraft.class_3218;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public interface WalkwayBlock {
    public static final class_2754<WalkwayCaps> CAPS = class_2754.method_11850((String)"caps", WalkwayCaps.class);
    public static final class_2754<WalkwayCaps> CAPS_SHAFT = class_2754.method_11848((String)"caps", WalkwayCaps.class, e -> e != WalkwayCaps.NO_SHAFT);
    public static final class_2754<WalkwayCaps> CAPS_SIDED = class_2754.method_11849((String)"caps", WalkwayCaps.class, (Enum[])new WalkwayCaps[]{WalkwayCaps.NONE, WalkwayCaps.BOTH, WalkwayCaps.NO_SHAFT});
    public static final class_2754<WalkwaySlope> SLOPE = class_2754.method_11848((String)"slope", WalkwaySlope.class, s -> s != WalkwaySlope.TERMINAL);

    public class_2350 getFacing(class_2680 var1);

    public WalkwaySlope getWalkwaySlope(class_2680 var1);

    public boolean hasWalkwayShaft(class_2680 var1);

    public class_2680 transformFromMerge(class_1937 var1, class_2680 var2, class_2338 var3, boolean var4, boolean var5, boolean var6, boolean var7);

    public boolean connectedToWalkwayOnSide(class_1937 var1, class_2680 var2, class_2338 var3, class_2350 var4);

    public WalkwaySet getWalkwaySet();

    public boolean isEscalator(class_1937 var1, class_2680 var2, class_2338 var3);

    default public boolean movesEntities(class_2680 state) {
        return true;
    }

    public static void initWalkway(class_1937 level, class_2338 pos) {
        int minSize;
        class_3218 slevel;
        if (level.field_9236 || level instanceof class_3218 && (slevel = (class_3218)level).method_14178().method_12129() instanceof class_2891) {
            return;
        }
        class_2680 state = level.method_8320(pos);
        if (!(state.method_26204() instanceof WalkwayBlock)) {
            return;
        }
        int limit = 1100;
        boolean escalator = false;
        class_2338 currentPos = pos;
        boolean terminal = false;
        while (limit-- > 0) {
            class_2680 currentState = level.method_8320(currentPos);
            class_2248 class_22482 = currentState.method_26204();
            if (!(class_22482 instanceof WalkwayBlock)) {
                level.method_22352(pos, true);
                return;
            }
            WalkwayBlock walkwayBlock = (WalkwayBlock)class_22482;
            WalkwaySlope slope = walkwayBlock.getWalkwaySlope(currentState);
            escalator |= slope == WalkwaySlope.TOP || slope == WalkwaySlope.MIDDLE || slope == WalkwaySlope.BOTTOM;
            class_2338 nextSegmentPosition = WalkwayBlock.nextSegmentPosition(currentState, currentPos, true, terminal);
            terminal = true;
            if (nextSegmentPosition == null) break;
            if (!level.method_8477(nextSegmentPosition)) {
                return;
            }
            currentPos = nextSegmentPosition;
        }
        List<class_2338> walkwayChain = WalkwayBlock.getWalkwayChain(level, currentPos);
        int n = minSize = escalator ? 5 : 3;
        if (walkwayChain.size() < minSize) {
            level.method_22352(currentPos, true);
            return;
        }
        for (class_2338 beltPos : walkwayChain) {
            class_2680 currentState = level.method_8320(beltPos);
            class_2586 class_25862 = level.method_8321(beltPos);
            if (class_25862 instanceof WalkwayBlockEntity) {
                WalkwayBlockEntity walkway = (WalkwayBlockEntity)class_25862;
                if (currentState.method_26204() instanceof WalkwayBlock) {
                    walkway.setController(currentPos);
                    walkway.walkwayLength = walkwayChain.size();
                    walkway.attachKinetics();
                    walkway.notifyUpdate();
                    continue;
                }
            }
            level.method_22352(currentPos, true);
            return;
        }
    }

    public static List<class_2338> getWalkwayChain(class_1937 level, class_2338 controllerPos) {
        class_2680 state;
        LinkedList<class_2338> positions = new LinkedList<class_2338>();
        class_2680 blockState = level.method_8320(controllerPos);
        if (!(blockState.method_26204() instanceof WalkwayBlock)) {
            return positions;
        }
        int limit = 1000;
        class_2338 current = controllerPos;
        boolean terminal = false;
        while (limit-- > 0 && current != null && (state = level.method_8320(current)).method_26204() instanceof WalkwayBlock) {
            positions.add(current);
            current = WalkwayBlock.nextSegmentPosition(state, current, !terminal, terminal);
            terminal = true;
        }
        return positions;
    }

    public static class_2338 nextSegmentPosition(class_2680 state, class_2338 pos, boolean forward, boolean terminal) {
        int offset;
        WalkwayBlock walkway = (WalkwayBlock)state.method_26204();
        class_2350 direction = walkway.getFacing(state);
        WalkwaySlope slope = walkway.getWalkwaySlope(state);
        int n = offset = forward ? 1 : -1;
        if (slope == WalkwaySlope.TERMINAL && terminal) {
            return null;
        }
        pos = pos.method_10079(direction, offset);
        if (slope == WalkwaySlope.MIDDLE) {
            return pos.method_10086(offset);
        }
        if (slope == WalkwaySlope.TOP && !forward) {
            return pos.method_10074();
        }
        if (slope == WalkwaySlope.BOTTOM && forward) {
            return pos.method_10084();
        }
        return pos;
    }
}

