/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues;

import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandPose;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandStyleOption;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.BuildCreativeModeTabContentsContext;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.network.client.C2SStrawStatueModelPartMessage;
import fuzs.strawstatues.network.client.C2SStrawStatueOwnerMessage;
import fuzs.strawstatues.network.client.C2SStrawStatueScaleMessage;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2487;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7706;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrawStatues
implements ModConstructor {
    public static final String MOD_ID = "strawstatues";
    public static final String MOD_NAME = "Straw Statues";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Straw Statues");
    public static final NetworkHandlerV2 NETWORK = NetworkHandlerV2.build((String)"strawstatues");

    public void onConstructMod() {
        ModRegistry.touch();
        StrawStatues.registerMessages();
        StrawStatues.registerHandlers();
    }

    private static void registerMessages() {
        NETWORK.register(C2SStrawStatueModelPartMessage.class, C2SStrawStatueModelPartMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(C2SStrawStatueOwnerMessage.class, C2SStrawStatueOwnerMessage::new, MessageDirection.TO_SERVER);
        NETWORK.register(C2SStrawStatueScaleMessage.class, C2SStrawStatueScaleMessage::new, MessageDirection.TO_SERVER);
    }

    private static void registerHandlers() {
        PlayerInteractEvents.USE_ENTITY_AT.register(EventPhase.BEFORE, StrawStatue::onUseEntityAt);
    }

    public void onCommonSetup() {
        ArmorStandStyleOption.register((class_2960)StrawStatues.id("slimarms"), (ArmorStandStyleOption)ModRegistry.SLIM_ARMS_STYLE_OPTION);
        ArmorStandStyleOption.register((class_2960)StrawStatues.id("crouching"), (ArmorStandStyleOption)ModRegistry.CROUCHING_STYLE_OPTION);
        class_2315.method_10009((class_1935)((class_1935)ModRegistry.STRAW_STATUE_ITEM.get()), (class_2357)new class_2347(){

            public class_1799 method_10135(class_2342 blockSource, class_1799 stack) {
                class_2350 direction = (class_2350)blockSource.method_10120().method_11654((class_2769)class_2315.field_10918);
                class_2338 blockpos = blockSource.method_10122().method_10093(direction);
                class_3218 level = blockSource.method_10207();
                StrawStatue armorstand = new StrawStatue((class_1937)level, (double)blockpos.method_10263() + 0.5, blockpos.method_10264(), (double)blockpos.method_10260() + 0.5);
                class_1299.method_5881((class_1937)level, null, (class_1297)armorstand, (class_2487)stack.method_7969());
                armorstand.method_36456(direction.method_10144());
                ArmorStandPose.randomValue().applyToEntity((class_1531)armorstand);
                level.method_8649((class_1297)armorstand);
                stack.method_7934(1);
                return stack;
            }
        });
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((class_1299)ModRegistry.STRAW_STATUE_ENTITY_TYPE.get(), class_1309.method_26827());
    }

    public void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsContext context) {
        context.registerBuildListener(class_7706.field_40197, (itemDisplayParameters, output) -> output.method_45421((class_1935)ModRegistry.STRAW_STATUE_ITEM.get()));
        context.registerBuildListener(class_7706.field_40198, (itemDisplayParameters, output) -> output.method_45421((class_1935)ModRegistry.STRAW_STATUE_ITEM.get()));
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }
}

