/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.block.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5778;

public abstract class MultifaceClusterBlock
extends class_5778
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 UP = class_2741.field_12519;
    protected final class_265 northAabb;
    protected final class_265 southAabb;
    protected final class_265 eastAabb;
    protected final class_265 westAabb;
    protected final class_265 upAabb;
    protected final class_265 downAabb;
    private final Map<class_2350, class_265> shapeByDirection;
    private final ImmutableMap<class_2680, class_265> shapesCache;

    public MultifaceClusterBlock(int height, int xzOffset, class_4970.class_2251 properties) {
        super(properties.method_50012(class_3619.field_15971));
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.upAabb = class_2248.method_9541((double)xzOffset, (double)0.0, (double)xzOffset, (double)(16 - xzOffset), (double)height, (double)(16 - xzOffset));
        this.downAabb = class_2248.method_9541((double)xzOffset, (double)(16 - height), (double)xzOffset, (double)(16 - xzOffset), (double)16.0, (double)(16 - xzOffset));
        this.northAabb = class_2248.method_9541((double)xzOffset, (double)xzOffset, (double)(16 - height), (double)(16 - xzOffset), (double)(16 - xzOffset), (double)16.0);
        this.southAabb = class_2248.method_9541((double)xzOffset, (double)xzOffset, (double)0.0, (double)(16 - xzOffset), (double)(16 - xzOffset), (double)height);
        this.eastAabb = class_2248.method_9541((double)0.0, (double)xzOffset, (double)xzOffset, (double)height, (double)(16 - xzOffset), (double)(16 - xzOffset));
        this.westAabb = class_2248.method_9541((double)(16 - height), (double)xzOffset, (double)xzOffset, (double)16.0, (double)(16 - xzOffset), (double)(16 - xzOffset));
        this.shapeByDirection = (Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), shapes -> {
            shapes.put(class_2350.field_11043, this.southAabb);
            shapes.put(class_2350.field_11034, this.westAabb);
            shapes.put(class_2350.field_11035, this.northAabb);
            shapes.put(class_2350.field_11039, this.eastAabb);
            shapes.put(class_2350.field_11036, this.downAabb);
            shapes.put(class_2350.field_11033, this.upAabb);
        });
        this.shapesCache = this.method_33615(this::calculateMultifaceShape);
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return Objects.requireNonNull((class_265)this.shapesCache.get((Object)state));
    }

    public class_265 calculateMultifaceShape(class_2680 state) {
        class_265 voxelShape = class_259.method_1073();
        for (class_2350 direction : field_28421) {
            if (!MultifaceClusterBlock.method_33366((class_2680)state, (class_2350)direction)) continue;
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)this.shapeByDirection.get(direction));
        }
        return voxelShape.method_1110() ? class_259.method_1077() : voxelShape;
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighborState, @NotNull class_1936 world, @NotNull class_2338 pos, @NotNull class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    public boolean method_9579(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos) {
        return blockState.method_26227().method_15769();
    }
}

