/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.xjs;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Optional;
import net.frozenblock.lib.FrozenLogUtils;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.config.api.entry.TypedEntry;
import net.frozenblock.lib.config.api.entry.TypedEntryType;
import net.frozenblock.lib.config.api.instance.xjs.NonSerializableObjectException;
import net.frozenblock.lib.config.api.instance.xjs.XjsOps;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;

public final class XjsTypedEntrySerializer {
    private XjsTypedEntrySerializer() {
    }

    public static JsonValue toJsonValue(TypedEntry src) throws NonSerializableObjectException {
        Optional optional;
        DataResult encoded;
        Codec codec;
        TypedEntryType type;
        if (src != null && (type = src.type()) != null && (codec = type.codec()) != null && (encoded = codec.encodeStart((DynamicOps)XjsOps.INSTANCE, src.value())) != null && encoded.error().isEmpty() && (optional = encoded.result()).isPresent()) {
            return (JsonValue)optional.get();
        }
        throw new NonSerializableObjectException("Failed to serialize typed entry " + String.valueOf(src));
    }

    public static TypedEntry<?> fromJsonValue(String modId, JsonValue value) throws NonSerializableObjectException {
        TypedEntry modEntry = XjsTypedEntrySerializer.getFromRegistry(modId, value, ConfigRegistry.getTypedEntryTypesForMod(modId));
        if (modEntry != null) {
            return modEntry;
        }
        throw new NonSerializableObjectException("Failed to deserialize typed entry" + String.valueOf(value));
    }

    @Nullable
    private static <T> TypedEntry<T> getFromRegistry(String modId, JsonValue value, @NotNull Collection<TypedEntryType<?>> registry) throws ClassCastException {
        for (TypedEntryType<?> entryType : registry) {
            TypedEntryType<?> newType = entryType;
            TypedEntry<?> entry = XjsTypedEntrySerializer.getFromType(modId, value, newType);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    private static <T> TypedEntry<T> getFromType(String modId, JsonValue value, @NotNull TypedEntryType<T> entryType) throws ClassCastException {
        if (!entryType.modId().equals(modId)) {
            return null;
        }
        Codec<T> codec = entryType.codec();
        DataResult result = codec.decode((DynamicOps)XjsOps.INSTANCE, (Object)value);
        if (result.error().isPresent()) {
            return null;
        }
        Optional optional = result.result();
        if (optional.isEmpty()) {
            return null;
        }
        Pair pair = (Pair)optional.get();
        Object first = pair.getFirst();
        TypedEntry<Object> entry = TypedEntry.create(entryType, first);
        FrozenLogUtils.log("Built typed entry " + String.valueOf(entry), FrozenSharedConstants.UNSTABLE_LOGGING);
        return entry;
    }
}

