/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.file.nbt;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Contract;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import org.slf4j.Logger;

public class NbtFileUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final File CONFIG_PATH = FabricLoader.getInstance().getConfigDir().toFile();

    public static void saveToConfigFile(class_2487 compoundTag, String fileName) {
        CONFIG_PATH.mkdirs();
        NbtFileUtils.saveToFile(compoundTag, new File(CONFIG_PATH, NbtFileUtils.withNBTExtension(fileName)));
    }

    public static void saveToFile(class_2487 compoundTag, @NotNull File file, String fileName) {
        file.mkdirs();
        File destFile = new File(file, NbtFileUtils.withNBTExtension(fileName));
        NbtFileUtils.saveToFile(compoundTag, destFile);
    }

    public static void saveToFile(class_2487 compoundTag, @NotNull File file) {
        file.getParentFile().mkdirs();
        try {
            class_2507.method_30614((class_2487)compoundTag, (File)file);
        }
        catch (IOException iOException) {
            LOGGER.error("Could not save data {}", (Object)file, (Object)iOException);
        }
    }

    @Nullable
    public static class_2487 readFromConfigFile(String fileName) {
        return NbtFileUtils.readFromFile(new File(CONFIG_PATH, NbtFileUtils.withNBTExtension(fileName)));
    }

    @Nullable
    public static class_2487 readFromFile(File file, String fileName) {
        return NbtFileUtils.readFromFile(new File(file, NbtFileUtils.withNBTExtension(fileName)));
    }

    @Nullable
    public static class_2487 readFromFile(@NotNull File file) {
        class_2487 compoundTag = null;
        try {
            compoundTag = class_2507.method_10633((File)file);
        }
        catch (IOException iOException) {
            LOGGER.error("Could not read data {}", (Object)file, (Object)iOException);
        }
        return compoundTag;
    }

    @Contract(pure=true)
    @NotNull
    public static String withNBTExtension(String string) {
        return string + ".nbt";
    }
}

