/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.personthecat.fresult;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.CheckReturnValue;
import net.frozenblock.lib.shadow.personthecat.fresult.OptionalResult;
import net.frozenblock.lib.shadow.personthecat.fresult.PartialOptionalResult;
import net.frozenblock.lib.shadow.personthecat.fresult.PartialResult;
import net.frozenblock.lib.shadow.personthecat.fresult.Protocol;
import net.frozenblock.lib.shadow.personthecat.fresult.Resolver;
import net.frozenblock.lib.shadow.personthecat.fresult.Shorthand;
import net.frozenblock.lib.shadow.personthecat.fresult.Void;
import net.frozenblock.lib.shadow.personthecat.fresult.WithResource;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.OptionalResultFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ResultFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingBiConsumer;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingBiFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingConsumer;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingOptionalSupplier;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingRunnable;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingSupplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Result<T, E extends Throwable>
extends OptionalResult<T, E> {
    public static <E extends Throwable> void IGNORE(E e) {
    }

    public static <E extends Throwable> void WARN(E e) {
        Shorthand.warn("{}", e);
    }

    public static <E extends Throwable> void THROW(E e) {
        throw Shorthand.runEx(e);
    }

    public static void WARN_NULL() {
        Shorthand.warn("Null value in wrapper", new Object[0]);
    }

    @CheckReturnValue
    public static <E extends Throwable> Value<Void, E> ok() {
        return Value.OK;
    }

    @CheckReturnValue
    public static <T, E extends Throwable> Value<T, E> ok(T val) {
        return new Value(val);
    }

    @CheckReturnValue
    public static <T, E extends Throwable> Error<T, E> err(E e) {
        return new Error(e);
    }

    @CheckReturnValue
    public static <T, E extends Throwable> Empty<T, E> empty() {
        return Empty.INSTANCE;
    }

    @CheckReturnValue
    public static <T, E extends Throwable> Pending<T, E> of(ThrowingSupplier<T, E> attempt) {
        return new Pending<T, E>(attempt);
    }

    @CheckReturnValue
    public static <E extends Throwable> Pending<Void, E> of(ThrowingRunnable<E> attempt) {
        return new Pending<Void, E>(Result.wrapVoid(attempt));
    }

    @CheckReturnValue
    public static <T> Result<T, Throwable> suppress(ThrowingSupplier<T, Throwable> attempt) {
        try {
            return Result.ok(attempt.get());
        }
        catch (Throwable t) {
            return Result.err(t);
        }
    }

    @CheckReturnValue
    public static Result<Void, Throwable> suppress(ThrowingRunnable<Throwable> attempt) {
        try {
            attempt.run();
            return Result.ok();
        }
        catch (Throwable t) {
            return Result.err(t);
        }
    }

    @CheckReturnValue
    public static <T, E extends Throwable> OptionalResult<T, E> nullable(T value) {
        return value != null ? Result.ok(value) : Result.empty();
    }

    @CheckReturnValue
    public static <T, E extends Throwable> OptionalResult<T, E> nullable(Optional<T> value) {
        return value.isPresent() ? Result.ok(value.get()) : Result.empty();
    }

    @CheckReturnValue
    public static <T, E extends Throwable> PartialOptionalResult<T, E> nullable(ThrowingSupplier<T, E> attempt) {
        return new PendingNullable<T, E>(attempt);
    }

    @CheckReturnValue
    public static <T, E extends Throwable> PartialOptionalResult<T, E> nullable(ThrowingOptionalSupplier<T, E> attempt) {
        return new PendingNullable(() -> attempt.get().orElse(null));
    }

    public static <T> OptionalResult<T, Throwable> suppressNullable(ThrowingSupplier<T, Throwable> attempt) {
        try {
            return Result.nullable(attempt.get());
        }
        catch (Throwable t) {
            return Result.err(t);
        }
    }

    public static <T> OptionalResult<T, Throwable> suppressNullable(ThrowingOptionalSupplier<T, Throwable> attempt) {
        return Result.suppressNullable(() -> attempt.get().orElse(null));
    }

    @CheckReturnValue
    public static <R extends AutoCloseable, E extends Throwable> WithResource<R, E> with(ThrowingSupplier<R, E> resource) {
        return new WithResource<R, E>(resource);
    }

    @CheckReturnValue
    public static <R extends AutoCloseable, T, E extends Throwable> Pending<T, E> with(ThrowingSupplier<R, E> resource, ThrowingFunction<R, T, E> attempt) {
        return Result.with(resource).of(attempt);
    }

    @CheckReturnValue
    public static <R extends AutoCloseable, E extends Throwable> Pending<Void, E> with(ThrowingSupplier<R, E> resource, ThrowingConsumer<R, E> attempt) {
        return Result.with(resource).of(attempt);
    }

    @CheckReturnValue
    public static <E extends Throwable> Protocol define(Class<E> clazz, Consumer<E> f) {
        return new Protocol().define(clazz, f);
    }

    @CheckReturnValue
    public static <T, E extends Throwable> Resolver<T> resolve(Class<E> clazz, Function<E, T> f) {
        return new Resolver<T>().resolve(clazz, f);
    }

    @SafeVarargs
    @CheckReturnValue
    public static <E extends Throwable> Result<Void, E> join(Result<Void, E> ... results) {
        for (Result<Void, E> result : results) {
            if (!result.isErr()) continue;
            return result;
        }
        return Result.ok();
    }

    @SafeVarargs
    @CheckReturnValue
    public static <E extends Throwable> Pending<Void, E> join(Pending<Void, E> ... results) {
        return new Pending(() -> {
            for (Pending result : results) {
                try {
                    result.orElseThrow();
                }
                catch (Throwable e) {
                    throw Shorthand.errorFound(e);
                }
            }
            return Void.INSTANCE;
        });
    }

    @SafeVarargs
    @CheckReturnValue
    public static <T, E extends Throwable> Pending<List<T>, E> collect(Result<T, E> ... results) {
        return new Pending(() -> {
            ArrayList list = new ArrayList();
            for (Result result : results) {
                list.add(result.orElseThrow());
            }
            return list;
        });
    }

    public static <E extends Throwable> ThrowingSupplier<Void, E> wrapVoid(ThrowingRunnable<E> attempt) {
        return () -> {
            attempt.run();
            return Void.INSTANCE;
        };
    }

    public static <R, E extends Throwable> ThrowingFunction<R, Void, E> wrapVoid(ThrowingConsumer<R, E> attempt) {
        return r -> {
            attempt.accept(r);
            return Void.INSTANCE;
        };
    }

    public static <R1, R2, E extends Throwable> ThrowingBiFunction<R1, R2, Void, E> wrapVoid(ThrowingBiConsumer<R1, R2, E> attempt) {
        return (r1, r2) -> {
            attempt.accept(r1, r2);
            return Void.INSTANCE;
        };
    }

    @Override
    @CheckReturnValue
    public boolean isErr();

    @Override
    public Result<T, E> ifErr(Consumer<E> var1);

    @Override
    @CheckReturnValue
    public boolean isOk();

    @Override
    public Result<T, E> ifOk(Consumer<T> var1);

    @Override
    @CheckReturnValue
    public Optional<T> get();

    @Override
    @CheckReturnValue
    public Optional<E> getErr();

    @CheckReturnValue
    public <U> U fold(Function<T, U> var1, Function<E, U> var2);

    @CheckReturnValue
    public Value<T, E> resolve(Function<E, T> var1);

    @Override
    @CheckReturnValue
    public T orElse(T var1);

    @Override
    @CheckReturnValue
    public T orElseGet(Supplier<T> var1);

    @CheckReturnValue
    public T orElseGet(Function<E, T> var1);

    @CheckReturnValue
    public PartialResult<T, E> orElseTry(ThrowingFunction<E, T, E> var1);

    @Override
    @CheckReturnValue
    public PartialResult<T, E> orElseTry(ThrowingSupplier<T, E> var1);

    @CheckReturnValue
    public Result<T, Throwable> orElseTry(Protocol var1, ThrowingFunction<E, T, Throwable> var2);

    @Override
    @CheckReturnValue
    default public Result<T, Throwable> orElseTry(Protocol protocol, ThrowingSupplier<T, Throwable> f) {
        return this.orElseTry(protocol, (E e) -> f.get());
    }

    @CheckReturnValue
    public Value<T, Throwable> orElseTry(Resolver<T> var1, ThrowingFunction<E, T, Throwable> var2);

    @CheckReturnValue
    default public Value<T, Throwable> orElseTry(Resolver<T> resolver, ThrowingSupplier<T, Throwable> f) {
        return this.orElseTry(resolver, (E e) -> f.get());
    }

    @Override
    @CheckReturnValue
    public <M> Result<M, E> map(Function<T, M> var1);

    @Override
    @CheckReturnValue
    public <E2 extends Throwable> Result<T, E2> mapErr(Function<E, E2> var1);

    @Override
    @CheckReturnValue
    public <M> Result<M, E> flatMap(ResultFunction<T, M, E> var1);

    @Override
    @CheckReturnValue
    public <M> OptionalResult<M, E> flatMap(OptionalResultFunction<T, M, E> var1);

    @Override
    @CheckReturnValue
    public <E2 extends Throwable> Result<T, E2> flatMapErr(ResultFunction<E, T, E2> var1);

    @Override
    @CheckReturnValue
    public <E2 extends Throwable> OptionalResult<T, E2> flatMapErr(OptionalResultFunction<E, T, E2> var1);

    @Override
    @CheckReturnValue
    public OptionalResult<T, E> filter(Predicate<T> var1);

    @Override
    @CheckReturnValue
    public Result<T, E> filter(Predicate<T> var1, Supplier<E> var2);

    @Override
    @CheckReturnValue
    public OptionalResult<T, E> filterErr(Predicate<E> var1);

    @Override
    @CheckReturnValue
    public Result<T, E> filterErr(Predicate<E> var1, Supplier<T> var2);

    @Override
    @CheckReturnValue
    public <M> Result<M, E> andThen(Function<T, M> var1);

    @Override
    @CheckReturnValue
    public <M> PartialResult<M, E> andThenTry(ThrowingFunction<T, M, E> var1);

    @Override
    @CheckReturnValue
    public <M> Result<M, Throwable> andThenSuppress(ThrowingFunction<T, M, Throwable> var1);

    @Override
    public Result<Void, E> andThen(Runnable var1);

    @Override
    @CheckReturnValue
    public PartialResult<Void, E> andThenTry(ThrowingRunnable<E> var1);

    @CheckReturnValue
    public Result<Void, Throwable> andThenSuppress(ThrowingRunnable<Throwable> var1);

    @Override
    @CheckReturnValue
    default public E unwrapErr() {
        return this.expectErr("Attempted to unwrap a result with no error.");
    }

    @Override
    @CheckReturnValue
    public E expectErr(String var1);

    @Override
    @CheckReturnValue
    default public E expectErr(String message, Object ... args) {
        return this.expectErr(Shorthand.f(message, args));
    }

    @Override
    default public T orElseThrow() throws E {
        this.throwIfErr();
        return this.unwrap();
    }

    @Override
    public void throwIfErr() throws E;

    public record Value<T, E extends Throwable>(T value) implements PartialResult<T, E>,
    Result<T, E>,
    PartialOptionalResult<T, E>,
    OptionalResult<T, E>
    {
        private static final Value<Void, ?> OK = new Value(Void.INSTANCE);
        private static final long serialVersionUID = 3L;

        public Value {
            Objects.requireNonNull(value, "Value may not be null");
        }

        public T expose() {
            return this.value;
        }

        @Override
        @Deprecated
        public Value<T, E> errIfEmpty(Supplier<E> defaultGetter) {
            return this;
        }

        @Override
        @Deprecated
        public boolean isEmpty() {
            return false;
        }

        @Override
        @Deprecated
        public boolean isErr() {
            return false;
        }

        @Override
        @Deprecated
        public boolean isErr(Class<? super E> clazz) {
            return false;
        }

        @Override
        @Deprecated
        public boolean isAnyErr() {
            return false;
        }

        @Override
        @Deprecated
        public Value<T, E> ifErr(Consumer<E> f) {
            return this;
        }

        @Override
        @Deprecated
        public boolean isOk() {
            return true;
        }

        @Override
        @Deprecated
        public Value<T, E> ifOk(Consumer<T> f) {
            f.accept(this.value);
            return this;
        }

        @Override
        @Deprecated
        public Optional<T> get(Consumer<E> func) {
            return Optional.of(this.value);
        }

        @Override
        @Deprecated
        public Optional<T> get() {
            return Optional.of(this.value);
        }

        @Override
        @Deprecated
        public Optional<E> getErr() {
            return Optional.empty();
        }

        @Override
        @Deprecated
        public Optional<Throwable> getAnyErr() {
            return Optional.empty();
        }

        @Override
        @Deprecated
        public <U> U fold(Function<T, U> ifOk, Function<E, U> ifErr) {
            return ifOk.apply(this.value);
        }

        @Override
        @Deprecated
        public Value<T, E> resolve(Function<E, T> ifErr) {
            return this;
        }

        @Override
        @Deprecated
        public T expect(String message) {
            return this.value;
        }

        @Override
        @Deprecated
        public T expect(String message, Object ... args) {
            return this.value;
        }

        @Override
        @Deprecated
        public E expectErr(String message) {
            throw Shorthand.unwrapEx(message);
        }

        @Override
        @Deprecated
        public E expectErr(String message, Object ... args) {
            throw Shorthand.unwrapEx(Shorthand.f(message, args));
        }

        @Override
        @Deprecated
        public T orElseThrow() {
            return this.value;
        }

        @Override
        @Deprecated
        public void throwIfErr() {
        }

        @Override
        @Deprecated
        public Value<T, E> defaultIfEmpty(Supplier<T> defaultGetter) {
            return this;
        }

        @Override
        @Deprecated
        public Value<T, E> ifEmpty(Runnable f) {
            return this;
        }

        @Override
        @Deprecated
        public void assertEmpty() {
            throw Shorthand.unwrapEx("Result contains a value");
        }

        @Override
        @Deprecated
        public void expectEmpty(String message) {
            throw Shorthand.unwrapEx(message);
        }

        @Override
        @Deprecated
        public void expectEmpty(String message, Object ... args) {
            throw Shorthand.unwrapEx(Shorthand.f(message, args));
        }

        @Override
        @Deprecated
        public T orElse(T val) {
            return this.value;
        }

        @Override
        @Deprecated
        public T orElseGet(Supplier<T> f) {
            return this.value;
        }

        @Override
        @Deprecated
        public T orElseGet(Function<E, T> f) {
            return this.value;
        }

        @Override
        @Deprecated
        public Value<T, E> orElseTry(ThrowingFunction<E, T, E> f) {
            return this;
        }

        @Override
        @Deprecated
        public Value<T, E> orElseTry(ThrowingSupplier<T, E> f) {
            return this;
        }

        @Override
        @Deprecated
        public Value<T, Throwable> orElseTry(Protocol protocol, ThrowingFunction<E, T, Throwable> f) {
            return this;
        }

        @Override
        @Deprecated
        public Value<T, Throwable> orElseTry(Protocol protocol, ThrowingSupplier<T, Throwable> f) {
            return this;
        }

        @Override
        @Deprecated
        public Value<T, Throwable> orElseTry(Resolver<T> resolver, ThrowingFunction<E, T, Throwable> f) {
            return this;
        }

        @Override
        @Deprecated
        public Value<T, Throwable> orElseTry(Resolver<T> resolver, ThrowingSupplier<T, Throwable> f) {
            return this;
        }

        @Override
        public <M> Value<M, E> map(Function<T, M> f) {
            return new Value<M, E>(f.apply(this.value));
        }

        @Override
        @Deprecated
        public <E2 extends Throwable> Value<T, E2> mapErr(Function<E, E2> f) {
            return this;
        }

        @Override
        public <M> Result<M, E> flatMap(ResultFunction<T, M, E> f) {
            return (Result)f.apply(this.value);
        }

        @Override
        public <M> OptionalResult<M, E> flatMap(OptionalResultFunction<T, M, E> f) {
            return (OptionalResult)f.apply(this.value);
        }

        @Override
        @Deprecated
        public <E2 extends Throwable> Result<T, E2> flatMapErr(ResultFunction<E, T, E2> f) {
            return this;
        }

        @Override
        @Deprecated
        public <E2 extends Throwable> OptionalResult<T, E2> flatMapErr(OptionalResultFunction<E, T, E2> f) {
            return this;
        }

        @Override
        public OptionalResult<T, E> filter(Predicate<T> f) {
            return f.test(this.value) ? this : Result.empty();
        }

        @Override
        public Result<T, E> filter(Predicate<T> f, Supplier<E> err) {
            return f.test(this.value) ? this : Result.err((Throwable)err.get());
        }

        @Override
        @Deprecated
        public Value<T, E> filterErr(Predicate<E> f) {
            return this;
        }

        @Override
        @Deprecated
        public Value<T, E> filterErr(Predicate<E> f, Supplier<T> val) {
            return this;
        }

        @Override
        public <M> Value<M, E> andThen(Function<T, M> f) {
            return Result.ok(f.apply(this.value));
        }

        @Override
        public PartialResult<Void, E> andThenTry(ThrowingRunnable<E> attempt) {
            return Result.of(attempt);
        }

        @Override
        public <M> Result<M, Throwable> andThenSuppress(ThrowingFunction<T, M, Throwable> attempt) {
            return Result.suppress(() -> attempt.apply(this.value));
        }

        @Override
        public Value<Void, E> andThen(Runnable f) {
            f.run();
            return Result.ok();
        }

        @Override
        @Deprecated
        public <M> PartialResult<M, E> andThenTry(ThrowingFunction<T, M, E> attempt) {
            return Result.of(() -> attempt.apply(this.value));
        }

        @Override
        @Deprecated
        public Result<Void, Throwable> andThenSuppress(ThrowingRunnable<Throwable> attempt) {
            return Result.suppress(attempt);
        }

        @Override
        @Deprecated
        public T unwrap() {
            return this.value;
        }

        @Override
        @Deprecated
        public E unwrapErr() {
            throw Shorthand.unwrapEx("Attempted to unwrap a result with no error.");
        }
    }

    public record Error<T, E extends Throwable>(E error) implements PartialResult<T, E>,
    Result<T, E>,
    PartialOptionalResult<T, E>,
    OptionalResult<T, E>
    {
        private static final long serialVersionUID = 3L;

        public Error {
            Objects.requireNonNull(error, "Error may not be null");
        }

        public E expose() {
            return this.error;
        }

        @Override
        @Deprecated
        public Error<T, E> errIfEmpty(Supplier<E> defaultGetter) {
            return this;
        }

        @Override
        @Deprecated
        public boolean isEmpty() {
            return false;
        }

        @Override
        @Deprecated
        public boolean isErr() {
            return true;
        }

        @Override
        @Deprecated
        public boolean isErr(Class<? super E> clazz) {
            if (!clazz.isInstance(this.error)) {
                throw Shorthand.wrongErrorEx(this.error);
            }
            return true;
        }

        @Override
        @Deprecated
        public boolean isAnyErr() {
            return true;
        }

        @Override
        @Deprecated
        public Error<T, E> ifErr(Consumer<E> f) {
            try {
                f.accept(this.error);
            }
            catch (ClassCastException ignored) {
                throw Shorthand.wrongErrorEx(this.error);
            }
            return this;
        }

        @Override
        @Deprecated
        public boolean isOk() {
            return false;
        }

        @Override
        @Deprecated
        public Error<T, E> ifOk(Consumer<T> f) {
            return this;
        }

        @Override
        @Deprecated
        public Optional<T> get(Consumer<E> func) {
            return Optional.empty();
        }

        @Override
        @Deprecated
        public Optional<Throwable> getAnyErr() {
            return Optional.of(this.error);
        }

        @Override
        @Deprecated
        public Optional<T> get() {
            return Optional.empty();
        }

        @Override
        @Deprecated
        public Optional<E> getErr() {
            return Optional.of(this.error);
        }

        @Override
        @Deprecated
        public <U> U fold(Function<T, U> ifOk, Function<E, U> ifErr) {
            try {
                return ifErr.apply(this.error);
            }
            catch (ClassCastException ignored) {
                throw Shorthand.wrongErrorEx(this.error);
            }
        }

        @Override
        public Value<T, E> resolve(Function<E, T> ifErr) {
            return Result.ok(ifErr.apply(this.error));
        }

        @Override
        @Deprecated
        public T expect(String message) {
            throw Shorthand.unwrapEx(message);
        }

        @Override
        @Deprecated
        public T expect(String message, Object ... args) {
            throw Shorthand.unwrapEx(Shorthand.f(message, args));
        }

        @Override
        @Deprecated
        public E expectErr(String message) {
            return this.error;
        }

        @Override
        @Deprecated
        public E expectErr(String message, Object ... args) {
            return this.error;
        }

        @Override
        @Deprecated
        public T orElseThrow() throws E {
            throw this.error;
        }

        @Override
        @Deprecated
        public void throwIfErr() throws E {
            throw this.error;
        }

        @Override
        @Deprecated
        public Error<T, E> defaultIfEmpty(Supplier<T> defaultGetter) {
            return this;
        }

        @Override
        @Deprecated
        public Error<T, E> ifEmpty(Runnable f) {
            return this;
        }

        @Override
        @Deprecated
        public void assertEmpty() {
            throw Shorthand.unwrapEx("Result contains an error.");
        }

        @Override
        @Deprecated
        public void expectEmpty(String message) {
            throw Shorthand.unwrapEx(message);
        }

        @Override
        @Deprecated
        public void expectEmpty(String message, Object ... args) {
            throw Shorthand.unwrapEx(Shorthand.f(message, args));
        }

        @Override
        public T orElse(T val) {
            return val;
        }

        @Override
        public T orElseGet(Supplier<T> f) {
            return f.get();
        }

        @Override
        public T orElseGet(Function<E, T> f) {
            try {
                return f.apply(this.error);
            }
            catch (ClassCastException ignored) {
                throw Shorthand.wrongErrorEx(this.error);
            }
        }

        @Override
        public Pending<T, E> orElseTry(ThrowingFunction<E, T, E> f) {
            try {
                return Result.of(() -> f.apply(this.error));
            }
            catch (ClassCastException ignored) {
                throw Shorthand.wrongErrorEx(this.error);
            }
        }

        @Override
        public PartialResult<T, E> orElseTry(ThrowingSupplier<T, E> f) {
            return Result.of(f);
        }

        @Override
        public Result<T, Throwable> orElseTry(Protocol protocol, ThrowingFunction<E, T, Throwable> f) {
            return protocol.suppress(() -> f.apply(this.error));
        }

        @Override
        public Result<T, Throwable> orElseTry(Protocol protocol, ThrowingSupplier<T, Throwable> f) {
            return protocol.suppress(f);
        }

        @Override
        public Value<T, Throwable> orElseTry(Resolver<T> resolver, ThrowingFunction<E, T, Throwable> f) {
            return resolver.suppress(() -> f.apply(this.error));
        }

        @Override
        public Value<T, Throwable> orElseTry(Resolver<T> resolver, ThrowingSupplier<T, Throwable> f) {
            return resolver.suppress(f);
        }

        @Override
        @Deprecated
        public <M> Error<M, E> map(Function<T, M> f) {
            try {
                return this;
            }
            catch (ClassCastException ignored) {
                throw Shorthand.wrongErrorEx(this.error);
            }
        }

        @Override
        public <E2 extends Throwable> Error<T, E2> mapErr(Function<E, E2> f) {
            try {
                return new Error<T, Throwable>((Throwable)f.apply(this.error));
            }
            catch (ClassCastException ignored) {
                throw Shorthand.wrongErrorEx(this.error);
            }
        }

        @Override
        @Deprecated
        public <M> Result<M, E> flatMap(ResultFunction<T, M, E> f) {
            return this;
        }

        @Override
        public <E2 extends Throwable> Result<T, E2> flatMapErr(ResultFunction<E, T, E2> f) {
            try {
                return (Result)f.apply(this.error);
            }
            catch (ClassCastException ignored) {
                throw Shorthand.wrongErrorEx(this.error);
            }
        }

        @Override
        @Deprecated
        public <M> OptionalResult<M, E> flatMap(OptionalResultFunction<T, M, E> f) {
            return this;
        }

        @Override
        public <E2 extends Throwable> OptionalResult<T, E2> flatMapErr(OptionalResultFunction<E, T, E2> f) {
            return (OptionalResult)f.apply(this.error);
        }

        @Override
        @Deprecated
        public OptionalResult<T, E> filter(Predicate<T> f) {
            return this;
        }

        @Override
        @Deprecated
        public Error<T, E> filter(Predicate<T> f, Supplier<E> err) {
            return this;
        }

        @Override
        public OptionalResult<T, E> filterErr(Predicate<E> f) {
            return f.test(this.error) ? this : Result.empty();
        }

        @Override
        public Result<T, E> filterErr(Predicate<E> f, Supplier<T> val) {
            return f.test(this.error) ? this : Result.ok(val.get());
        }

        @Override
        @Deprecated
        public <M> Error<M, E> andThen(Function<T, M> f) {
            return this;
        }

        @Override
        @Deprecated
        public <M> Error<M, E> andThenTry(ThrowingFunction<T, M, E> attempt) {
            return this;
        }

        @Override
        @Deprecated
        public <M> Error<M, Throwable> andThenSuppress(ThrowingFunction<T, M, Throwable> attempt) {
            return this;
        }

        @Override
        @Deprecated
        public Error<Void, E> andThen(Runnable f) {
            return this;
        }

        @Deprecated
        public Error<Void, Throwable> andThenSuppress(ThrowingRunnable<Throwable> attempt) {
            return this;
        }

        @Override
        @Deprecated
        public Error<Void, E> andThenTry(ThrowingRunnable<E> attempt) {
            return this;
        }

        @Override
        @Deprecated
        public T unwrap() {
            throw Shorthand.unwrapEx("Attempted to unwrap a result with no value.");
        }

        @Override
        @Deprecated
        public E unwrapErr() {
            return this.error;
        }
    }

    public static final class Empty<T, E extends Throwable>
    implements OptionalResult<T, E>,
    PartialOptionalResult<T, E> {
        private static final long serialVersionUID = 3L;
        static final Empty<?, ?> INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public Value<T, E> defaultIfEmpty(Supplier<T> defaultGetter) {
            return new Value(Objects.requireNonNull(defaultGetter.get(), "Default getter"));
        }

        @Override
        public Error<T, E> errIfEmpty(Supplier<E> defaultGetter) {
            return new Error(Objects.requireNonNull((Throwable)defaultGetter.get(), "Default getter"));
        }

        @Override
        @Deprecated
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Deprecated
        @CheckReturnValue
        public Empty<T, E> ifEmpty(Runnable f) {
            f.run();
            return this;
        }

        @Override
        @Deprecated
        public boolean isErr() {
            return false;
        }

        @Override
        @Deprecated
        public Empty<T, E> ifErr(Consumer<E> f) {
            return this;
        }

        @Override
        @Deprecated
        public boolean isOk() {
            return false;
        }

        @Override
        @Deprecated
        public Empty<T, E> ifOk(Consumer<T> f) {
            return this;
        }

        @Override
        @Deprecated
        public boolean isErr(Class<? super E> clazz) {
            return false;
        }

        @Override
        @Deprecated
        @CheckReturnValue
        public boolean isAnyErr() {
            return false;
        }

        @Override
        @Deprecated
        @CheckReturnValue
        public Optional<T> get(Consumer<E> func) {
            return Optional.empty();
        }

        @Override
        @Deprecated
        public Optional<T> get() {
            return Optional.empty();
        }

        @Override
        @Deprecated
        public Optional<E> getErr() {
            return Optional.empty();
        }

        @Override
        @Deprecated
        public T orElse(T val) {
            return val;
        }

        @Override
        @Deprecated
        public T orElseGet(Supplier<T> f) {
            return f.get();
        }

        @Override
        @Deprecated
        public PartialResult<T, E> orElseTry(ThrowingSupplier<T, E> f) {
            return Result.of(f);
        }

        @Override
        @Deprecated
        public Result<T, Throwable> orElseTry(Protocol protocol, ThrowingSupplier<T, Throwable> f) {
            return protocol.suppress(f);
        }

        @Override
        @Deprecated
        public <M> Empty<M, E> map(Function<T, M> f) {
            return this;
        }

        @Override
        @Deprecated
        public <E2 extends Throwable> Empty<T, E2> mapErr(Function<E, E2> f) {
            return this;
        }

        @Override
        @Deprecated
        public <M> OptionalResult<M, E> flatMap(OptionalResultFunction<T, M, E> f) {
            return this;
        }

        @Override
        @Deprecated
        public <E2 extends Throwable> OptionalResult<T, E2> flatMapErr(OptionalResultFunction<E, T, E2> f) {
            return this;
        }

        @Override
        @Deprecated
        public Empty<T, E> filter(Predicate<T> f) {
            return this;
        }

        @Override
        @Deprecated
        public OptionalResult<T, E> filter(Predicate<T> f, Supplier<E> err) {
            return this;
        }

        @Override
        @Deprecated
        public Empty<T, E> filterErr(Predicate<E> f) {
            return this;
        }

        @Override
        @Deprecated
        public OptionalResult<T, E> filterErr(Predicate<E> f, Supplier<T> val) {
            return this;
        }

        @Override
        @Deprecated
        public <M> Empty<M, E> andThen(Function<T, M> f) {
            return this;
        }

        @Override
        @Deprecated
        public <M> Empty<M, E> andThenTry(ThrowingFunction<T, M, E> attempt) {
            return this;
        }

        @Override
        @Deprecated
        public <M> Empty<M, Throwable> andThenSuppress(ThrowingFunction<T, M, Throwable> attempt) {
            return this;
        }

        @Override
        @Deprecated
        public Empty<Void, E> andThen(Runnable f) {
            return this;
        }

        @Override
        @Deprecated
        public Empty<Void, E> andThenTry(ThrowingRunnable<E> attempt) {
            return this;
        }

        @Deprecated
        public Empty<Void, Throwable> andThenSuppress(ThrowingRunnable<Throwable> attempt) {
            return this;
        }

        @Override
        @Deprecated
        public Optional<Throwable> getAnyErr() {
            return Optional.empty();
        }

        @Override
        @Deprecated
        public T unwrap() {
            throw Shorthand.unwrapEx("Attempted to unwrap a result with no value.");
        }

        @Override
        @Deprecated
        public E unwrapErr() {
            throw Shorthand.unwrapEx("Attempted to unwrap a result with no error.");
        }

        @Override
        @Deprecated
        public void assertEmpty() {
        }

        @Override
        @Deprecated
        public T expect(String message) {
            throw new NullPointerException(message);
        }

        @Override
        @Deprecated
        public T expect(String message, Object ... args) {
            throw new NullPointerException(Shorthand.f(message, args));
        }

        @Override
        @Deprecated
        public E expectErr(String message) {
            throw new NullPointerException(message);
        }

        @Override
        @Deprecated
        public E expectErr(String message, Object ... args) {
            throw new NullPointerException(Shorthand.f(message, args));
        }

        @Override
        @Deprecated
        public void expectEmpty(String message) {
        }

        @Override
        @Deprecated
        public void expectEmpty(String message, Object ... args) {
        }

        @Override
        @Deprecated
        public T orElseThrow() {
            throw new NullPointerException("No value in wrapper.");
        }

        @Override
        @Deprecated
        public void throwIfErr() {
            throw new NullPointerException("No value in wrapper");
        }
    }

    public static final class Pending<T, E extends Throwable>
    implements PartialResult<T, E>,
    PartialOptionalResult<T, E> {
        private final ThrowingSupplier<T, E> resultGetter;
        private final Supplier<Result<T, E>> defaultGetter;
        private volatile Result<T, E> result = null;

        private Pending(ThrowingSupplier<T, E> getter) {
            this(getter, null);
        }

        private Pending(ThrowingSupplier<T, E> resultGetter, Supplier<Result<T, E>> defaultGetter) {
            this.resultGetter = resultGetter;
            this.defaultGetter = defaultGetter;
        }

        @Override
        @Deprecated
        public PartialResult<T, E> errIfEmpty(Supplier<E> defaultGetter) {
            return this;
        }

        @Override
        public Result<T, E> ifErr(Consumer<E> f) {
            return this.execute().ifErr((Consumer)f);
        }

        @Override
        public Optional<T> get(Consumer<E> f) {
            return this.execute().get(f);
        }

        @Override
        public Optional<Throwable> getAnyErr() {
            return this.execute().getErr();
        }

        @Override
        @CheckReturnValue
        public boolean isErr(Class<? super E> clazz) {
            return Shorthand.checkError(this.execute(), clazz);
        }

        @Override
        @CheckReturnValue
        public boolean isAnyErr() {
            return this.execute().isErr();
        }

        @Override
        @CheckReturnValue
        public <U> U fold(Function<T, U> ifOk, Function<E, U> ifErr) {
            return this.execute().fold(ifOk, ifErr);
        }

        @Override
        public Value<T, E> resolve(Function<E, T> ifErr) {
            return this.execute().resolve(ifErr);
        }

        @Override
        public T expect(String message) {
            return this.execute().expect(message);
        }

        @Override
        public Throwable expectErr(String message) {
            return this.execute().expectErr(message);
        }

        @Override
        public void throwIfErr() throws E {
            this.execute().throwIfErr();
        }

        @Override
        @CheckReturnValue
        public T orElseGet(Function<E, T> f) {
            return this.execute().orElseGet(f);
        }

        @Override
        @CheckReturnValue
        public PartialResult<T, E> orElseTry(ThrowingFunction<E, T, E> f) {
            return this.execute().orElseTry(f);
        }

        @Override
        @CheckReturnValue
        public Result<T, Throwable> orElseTry(Protocol protocol, ThrowingFunction<E, T, Throwable> f) {
            return this.execute().orElseTry(protocol, f);
        }

        @Override
        @CheckReturnValue
        public Value<T, Throwable> orElseTry(Resolver<T> resolver, ThrowingFunction<E, T, Throwable> f) {
            return this.execute().orElseTry(resolver, f);
        }

        private synchronized Result<T, E> execute() {
            T value;
            if (this.result != null) {
                return this.result;
            }
            try {
                value = this.resultGetter.get();
            }
            catch (Throwable e) {
                this.result = new Error(Shorthand.errorFound(e));
                return this.result;
            }
            if (value != null) {
                this.result = new Value(value);
                return this.result;
            }
            this.result = Objects.requireNonNull(this.defaultGetter, "nonnull attempt").get();
            return this.result;
        }
    }

    public static final class PendingNullable<T, E extends Throwable>
    implements PartialOptionalResult<T, E> {
        private final ThrowingSupplier<T, E> resultGetter;
        private volatile OptionalResult<T, E> result = null;

        private PendingNullable(ThrowingSupplier<T, E> resultGetter) {
            this.resultGetter = resultGetter;
        }

        @Override
        @CheckReturnValue
        public PartialResult<T, E> defaultIfEmpty(Supplier<T> defaultGetter) {
            return new Pending<T, E>(this.resultGetter, () -> new Value(defaultGetter.get()));
        }

        @Override
        @CheckReturnValue
        public PartialResult<T, E> errIfEmpty(Supplier<E> defaultGetter) {
            return new Pending<T, E>(this.resultGetter, () -> new Error((Throwable)defaultGetter.get()));
        }

        @Override
        @CheckReturnValue
        public PartialOptionalResult<T, E> ifEmpty(Runnable f) {
            this.execute().ifEmpty(f);
            return this;
        }

        @Override
        @CheckReturnValue
        public boolean isErr(Class<? super E> clazz) {
            return Shorthand.checkError(this.execute(), clazz);
        }

        @Override
        @CheckReturnValue
        public boolean isAnyErr() {
            return this.execute().isErr();
        }

        @Override
        public OptionalResult<T, E> ifErr(Consumer<E> f) {
            return this.execute().ifErr(f);
        }

        @Override
        @CheckReturnValue
        public Optional<T> get(Consumer<E> f) {
            return this.execute().get(f);
        }

        @Override
        public Optional<Throwable> getAnyErr() {
            return this.execute().getErr();
        }

        @Override
        public T expect(String message) {
            return this.execute().expect(message);
        }

        @Override
        public void expectEmpty(String message) {
            this.execute().expectEmpty(message);
        }

        @Override
        public Throwable expectErr(String message) {
            return this.execute().expectErr(message);
        }

        @Override
        public void throwIfErr() throws Throwable {
            this.execute().throwIfErr();
        }

        private synchronized OptionalResult<T, E> execute() {
            if (this.result != null) {
                return this.result;
            }
            try {
                this.result = Result.nullable(this.resultGetter.get());
                return this.result;
            }
            catch (Throwable e) {
                this.result = new Error(Shorthand.errorFound(e));
                return this.result;
            }
        }
    }
}

