/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.spotting_icons.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.spotting_icons.api.ClientSpottingIconMethods;
import net.frozenblock.lib.spotting_icons.api.SpottingIconPredicate;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconPacket;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconRemovePacket;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class SpottingIconManager {
    public class_1297 entity;
    public int ticksToCheck;
    public SpottingIcon icon;
    public boolean clientHasIconResource;

    public SpottingIconManager(class_1297 entity) {
        this.entity = entity;
    }

    public void tick() {
        if (this.ticksToCheck > 0) {
            --this.ticksToCheck;
        } else {
            this.ticksToCheck = 20;
            if (this.icon != null) {
                if (this.entity.method_37908().field_9236) {
                    this.clientHasIconResource = ClientSpottingIconMethods.hasTexture(this.icon.texture());
                }
                if (!SpottingIconPredicate.getPredicate(this.icon.restrictionID).test(this.entity)) {
                    this.removeIcon();
                }
            }
        }
    }

    public void setIcon(class_2960 texture, float startFade, float endFade, class_2960 restrictionID) {
        this.icon = new SpottingIcon(texture, startFade, endFade, restrictionID);
        if (!this.entity.method_37908().field_9236) {
            SpottingIconPacket packet = new SpottingIconPacket(this.entity.method_5628(), texture, startFade, endFade, restrictionID);
            for (class_3222 player : PlayerLookup.tracking((class_1297)this.entity)) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
            }
        } else {
            this.clientHasIconResource = ClientSpottingIconMethods.hasTexture(this.icon.texture());
        }
        SpottingIconPredicate.getPredicate(this.icon.restrictionID).onAdded(this.entity);
    }

    public void removeIcon() {
        SpottingIconPredicate.getPredicate(this.icon.restrictionID).onRemoved(this.entity);
        this.icon = null;
        if (!this.entity.method_37908().field_9236) {
            SpottingIconRemovePacket packet = new SpottingIconRemovePacket(this.entity.method_5628());
            for (class_3222 player : PlayerLookup.tracking((class_1297)this.entity)) {
                ServerPlayNetworking.send((class_3222)player, (FabricPacket)packet);
            }
        }
    }

    public void sendIconPacket(class_3222 player) {
        if (this.icon != null) {
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            byteBuf.method_10804(this.entity.method_5628());
            byteBuf.method_10812(this.icon.texture);
            byteBuf.writeFloat(this.icon.startFadeDist);
            byteBuf.writeFloat(this.icon.endFadeDist);
            byteBuf.method_10812(this.icon.restrictionID);
            ServerPlayNetworking.send((class_3222)player, (FabricPacket)new SpottingIconPacket(this.entity.method_5628(), this.icon.texture, this.icon.startFadeDist(), this.icon.endFadeDist(), this.icon.restrictionID()));
        }
    }

    public void load(class_2487 nbt) {
        this.ticksToCheck = nbt.method_10550("frozenSpottingIconTicksToCheck");
        if (nbt.method_10545("frozenSpottingIcons")) {
            this.icon = null;
            DataResult var10000 = SpottingIcon.CODEC.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("frozenSpottingIcons")));
            NOPLogger var10001 = FrozenSharedConstants.LOGGER4;
            Objects.requireNonNull(var10001);
            Optional icon = var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0));
            icon.ifPresent(spottingIcon -> {
                this.icon = spottingIcon;
            });
        }
    }

    public void save(class_2487 nbt) {
        nbt.method_10569("frozenSpottingIconTicksToCheck", this.ticksToCheck);
        if (this.icon != null) {
            DataResult var10000 = SpottingIcon.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.icon);
            NOPLogger var10001 = FrozenSharedConstants.LOGGER4;
            Objects.requireNonNull(var10001);
            var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(iconNBT -> nbt.method_10566("frozenSpottingIcons", iconNBT));
        } else if (nbt.method_10545("frozenSpottingIcons")) {
            nbt.method_10551("frozenSpottingIcons");
        }
    }

    public record SpottingIcon(class_2960 texture, float startFadeDist, float endFadeDist, class_2960 restrictionID) {
        public static final Codec<SpottingIcon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("texture").forGetter(SpottingIcon::texture), (App)Codec.FLOAT.fieldOf("startFadeDist").forGetter(SpottingIcon::startFadeDist), (App)Codec.FLOAT.fieldOf("endFadeDist").forGetter(SpottingIcon::endFadeDist), (App)class_2960.field_25139.fieldOf("restrictionID").forGetter(SpottingIcon::restrictionID)).apply((Applicative)instance, SpottingIcon::new));
    }
}

