/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.tag.api;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7157;

public class TagKeyArgument<T>
implements ArgumentType<Result<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    final class_5321<? extends class_2378<T>> registryKey;

    public TagKeyArgument(class_5321<? extends class_2378<T>> registryKey) {
        this.registryKey = registryKey;
    }

    public static <T> TagKeyArgument<T> tagKey(class_5321<? extends class_2378<T>> registryKey) {
        return new TagKeyArgument<T>(registryKey);
    }

    public static <T> Result<T> getTagKey(CommandContext<class_2168> context, String argument, class_5321<class_2378<T>> registryKey, DynamicCommandExceptionType dynamicCommandExceptionType) throws CommandSyntaxException {
        Result result = (Result)context.getArgument(argument, Result.class);
        Optional<Result<T>> optional = result.cast(registryKey);
        return optional.orElseThrow(() -> dynamicCommandExceptionType.create((Object)result));
    }

    public Result<T> parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        try {
            reader.skip();
            class_2960 resourceLocation = class_2960.method_12835((StringReader)reader);
            return new Result(class_6862.method_40092(this.registryKey, (class_2960)resourceLocation));
        }
        catch (CommandSyntaxException var4) {
            reader.setCursor(cursor);
            throw var4;
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        CompletableFuture completableFuture;
        Object var4 = commandContext.getSource();
        if (var4 instanceof class_2172) {
            class_2172 sharedSuggestionProvider = (class_2172)var4;
            completableFuture = sharedSuggestionProvider.method_41213(this.registryKey, class_2172.class_7078.field_37262, suggestionsBuilder, commandContext);
        } else {
            completableFuture = suggestionsBuilder.buildFuture();
        }
        return completableFuture;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    record Result<T>(class_6862<T> key) {
        public <E> Optional<Result<E>> cast(class_5321<? extends class_2378<E>> registryKey) {
            return this.key.method_41008(registryKey).map(Result::new);
        }

        public String asPrintable() {
            return "#" + String.valueOf(this.key.comp_327());
        }
    }

    public static class Info<T>
    implements class_2314<TagKeyArgument<T>, Template> {
        public void serializeToNetwork(Template template, class_2540 buffer) {
            buffer.method_10812(template.registryKey.method_29177());
        }

        public Template deserializeFromNetwork(class_2540 buffer) {
            class_2960 resourceLocation = buffer.method_10810();
            return new Template(class_5321.method_29180((class_2960)resourceLocation));
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("registry", template.registryKey.method_29177().toString());
        }

        public Template unpack(TagKeyArgument<T> argument) {
            return new Template(argument.registryKey);
        }

        public final class Template
        implements class_2314.class_7217<TagKeyArgument<T>> {
            final class_5321<? extends class_2378<T>> registryKey;

            Template(class_5321<? extends class_2378<T>> registryKey) {
                this.registryKey = registryKey;
            }

            public TagKeyArgument<T> instantiate(class_7157 context) {
                return new TagKeyArgument(this.registryKey);
            }

            public class_2314<TagKeyArgument<T>, ?> method_41728() {
                return Info.this;
            }
        }
    }
}

