/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.features;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import net.frozenblock.lib.math.api.EasyNoiseSampler;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.worldgen.feature.api.features.config.PathTagFeatureConfig;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3756;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6646;

public class NoisePathTagUnderWaterFeature
extends class_3031<PathTagFeatureConfig> {
    public NoisePathTagUnderWaterFeature(Codec<PathTagFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(@NotNull class_5821<PathTagFeatureConfig> context) {
        boolean generated = false;
        PathTagFeatureConfig config = (PathTagFeatureConfig)context.method_33656();
        class_2338 blockPos = context.method_33655();
        class_5281 level = context.method_33652();
        long noiseSeed = level.method_8412();
        class_3756 sampler = config.noise() == 1 ? EasyNoiseSampler.createLocalNoise(noiseSeed) : (config.noise() == 2 ? EasyNoiseSampler.createCheckedNoise(noiseSeed) : (config.noise() == 3 ? EasyNoiseSampler.createLegacyThreadSafeNoise(noiseSeed) : EasyNoiseSampler.createXoroNoise(noiseSeed)));
        float chance = config.placementChance();
        class_2338.class_2339 mutable = blockPos.method_25503();
        int bx = mutable.method_10263();
        int by = mutable.method_10264();
        int bz = mutable.method_10260();
        int radiusSquared = config.radius() * config.radius();
        class_5819 random = level.method_8409();
        class_6646 predicate = config.onlyPlaceWhenExposed() ? class_6646.field_35697 : class_6646.method_39011();
        for (int x = bx - config.radius(); x <= bx + config.radius(); ++x) {
            for (int z = bz - config.radius(); z <= bz + config.radius(); ++z) {
                if (!config.is3D()) {
                    double distance = (bx - x) * (bx - x) + (bz - z) * (bz - z);
                    if (!(distance < (double)radiusSquared)) continue;
                    mutable.method_10103(x, level.method_8624(class_2902.class_2903.field_13200, x, z) - 1, z);
                    double sample = EasyNoiseSampler.sample(sampler, (class_2382)mutable, config.noiseScale(), config.scaleY(), config.useY());
                    if (!(sample > config.minThreshold()) || !(sample < config.maxThreshold()) || !level.method_8320((class_2338)mutable).method_26164(config.replaceableBlocks()) || !NoisePathTagUnderWaterFeature.checkSurroundingBlocks(level, (class_2338)mutable, predicate) || !NoisePathTagUnderWaterFeature.isWaterNearby(level, (class_2338)mutable, 2) || !(random.method_43057() <= chance)) continue;
                    generated = true;
                    level.method_8652((class_2338)mutable, config.state().method_23455(random, (class_2338)mutable), 3);
                    continue;
                }
                for (int y = by - config.radius(); y <= by + config.radius(); ++y) {
                    double distance = (bx - x) * (bx - x) + (bz - z) * (bz - z) + (by - y) * (by - y);
                    if (!(distance < (double)radiusSquared)) continue;
                    mutable.method_10103(x, y, z);
                    double sample = EasyNoiseSampler.sample(sampler, (class_2382)mutable, config.noiseScale(), config.scaleY(), config.useY());
                    if (!(sample > config.minThreshold()) || !(sample < config.maxThreshold()) || !level.method_8320((class_2338)mutable).method_26164(config.replaceableBlocks()) || !NoisePathTagUnderWaterFeature.checkSurroundingBlocks(level, (class_2338)mutable, predicate) || !NoisePathTagUnderWaterFeature.isWaterNearby(level, (class_2338)mutable, 2) || !(random.method_43057() <= chance)) continue;
                    generated = true;
                    level.method_8652((class_2338)mutable, config.state().method_23455(random, (class_2338)mutable), 3);
                }
            }
        }
        return generated;
    }

    private static boolean checkSurroundingBlocks(class_5281 level, class_2338 pos, class_6646 predicate) {
        for (class_2350 direction : class_2350.values()) {
            if (!predicate.test((Object)level, (Object)pos.method_10093(direction))) continue;
            return true;
        }
        return false;
    }

    public static boolean isWaterNearby(class_5281 level, @NotNull class_2338 blockPos, int x) {
        class_2338 blockPos2;
        Iterator var2 = class_2338.method_10097((class_2338)blockPos.method_10069(-x, -x, -x), (class_2338)blockPos.method_10069(x, x, x)).iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!level.method_8320(blockPos2 = (class_2338)var2.next()).method_27852(class_2246.field_10382));
        return true;
    }
}

