/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.converter;

import io.github.mortuusars.exposure.camera.capture.Capture;
import io.github.mortuusars.exposure.camera.capture.converter.IImageToMapColorsConverter;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_3620;
import net.minecraft.class_5253;

public class SimpleColorConverter
implements IImageToMapColorsConverter {
    private final double[] shadeCoeffs = new double[]{0.71, 0.86, 1.0, 0.53};

    public static class_3620[] getMapColors() {
        class_3620[] colors = new class_3620[64];
        for (int i = 0; i <= 63; ++i) {
            colors[i] = class_3620.method_38479((int)i);
        }
        return colors;
    }

    @Override
    public byte[] convert(Capture capture, class_1011 image) {
        return this.convert(image);
    }

    @Override
    public byte[] convert(class_1011 image) {
        int width = image.method_4307();
        int height = image.method_4323();
        class_3620[] mapColors = (class_3620[])Arrays.stream(SimpleColorConverter.getMapColors()).filter(Objects::nonNull).toArray(class_3620[]::new);
        byte[] bytes = new byte[width * height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                byte mapColorIndex;
                int pixelRGBA = image.method_4315(x, y);
                int R = class_5253.class_8045.method_48345((int)pixelRGBA);
                int G = class_5253.class_8045.method_48346((int)pixelRGBA);
                int B = class_5253.class_8045.method_48347((int)pixelRGBA);
                int A = class_5253.class_8045.method_48342((int)pixelRGBA);
                bytes[x + y * width] = A == 0 ? (byte)class_3620.field_16008.field_16021 : (mapColorIndex = (byte)this.nearestColor(mapColors, R, G, B, A));
            }
        }
        return bytes;
    }

    private double[] applyShade(double[] color, int shadeIndex) {
        double coeff = this.shadeCoeffs[shadeIndex];
        return new double[]{color[0] * coeff, color[1] * coeff, color[2] * coeff};
    }

    private int nearestColor(class_3620[] colors, int r, int g, int b, int a) {
        double[] imageVector = new double[]{(double)r / 255.0, (double)g / 255.0, (double)b / 255.0};
        int best_color = 0;
        double lowest_distance = 10000.0;
        for (int colorIndex = 0; colorIndex < colors.length; ++colorIndex) {
            int mapColor = colors[colorIndex].field_16011;
            int mapR = class_5253.class_5254.method_27765((int)mapColor);
            int mapG = class_5253.class_5254.method_27766((int)mapColor);
            int mapB = class_5253.class_5254.method_27767((int)mapColor);
            double[] mcColorVector = new double[]{(double)mapR / 255.0, (double)mapG / 255.0, (double)mapB / 255.0};
            for (int shadeInd = 0; shadeInd < this.shadeCoeffs.length; ++shadeInd) {
                double distance = this.distance(imageVector, this.applyShade(mcColorVector, shadeInd));
                if (!(distance < lowest_distance)) continue;
                lowest_distance = distance;
                best_color = colorIndex == 0 && a == 255 ? 119 : colorIndex * this.shadeCoeffs.length + shadeInd;
            }
        }
        return best_color;
    }

    private double distance(double[] vectorA, double[] vectorB) {
        return Math.sqrt(Math.pow(vectorA[0] - vectorB[0], 2.0) + Math.pow(vectorA[1] - vectorB[1], 2.0) + Math.pow(vectorA[2] - vectorB[2], 2.0));
    }
}

