/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.gui.screen.LightroomScreen;
import io.github.mortuusars.exposure.gui.screen.ZoomableScreen;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.menu.LightroomMenu;
import io.github.mortuusars.exposure.util.GuiUtil;
import io.github.mortuusars.exposure.util.PagingDirection;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilmFrameInspectScreen
extends ZoomableScreen {
    public static final class_2960 TEXTURE = Exposure.resource("textures/gui/film_frame_inspect.png");
    public static final class_2960 WIDGETS_TEXTURE = Exposure.resource("textures/gui/widgets.png");
    public static final int BG_SIZE = 78;
    public static final int FRAME_SIZE = 54;
    public static final int BUTTON_SIZE = 16;
    private final LightroomScreen lightroomScreen;
    private final LightroomMenu lightroomMenu;
    private class_344 previousButton;
    private class_344 nextButton;

    public FilmFrameInspectScreen(LightroomScreen lightroomScreen, LightroomMenu lightroomMenu) {
        super((class_2561)class_2561.method_43473());
        this.lightroomScreen = lightroomScreen;
        this.lightroomMenu = lightroomMenu;
        this.zoom.minZoom = this.zoom.defaultZoom / (float)Math.pow(this.zoom.step, 2.0);
    }

    public boolean method_25421() {
        return false;
    }

    private LightroomMenu getLightroomMenu() {
        return this.lightroomMenu;
    }

    protected void method_25426() {
        super.method_25426();
        this.zoomFactor = (float)this.field_22790 / 78.0f;
        this.previousButton = new class_344(0, (int)((float)this.field_22790 / 2.0f - 8.0f), 16, 16, 0, 0, 16, WIDGETS_TEXTURE, this::buttonPressed);
        this.nextButton = new class_344(this.field_22789 - 16, (int)((float)this.field_22790 / 2.0f - 8.0f), 16, 16, 16, 0, 16, WIDGETS_TEXTURE, this::buttonPressed);
        this.method_37063((class_364)this.previousButton);
        this.method_37063((class_364)this.nextButton);
    }

    private void buttonPressed(class_4185 button) {
        if (button == this.previousButton) {
            this.lightroomScreen.changeFrame(PagingDirection.PREVIOUS);
        } else if (button == this.nextButton) {
            this.lightroomScreen.changeFrame(PagingDirection.NEXT);
        }
    }

    public void close() {
        class_310.method_1551().method_1507((class_437)this.lightroomScreen);
        if (this.minecraft.field_1724 != null) {
            this.minecraft.field_1724.method_5783(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get(), 1.0f, 0.7f);
        }
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 500.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22909();
        if (this.zoom.targetZoom == this.zoom.minZoom) {
            this.close();
            return;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(this.x, this.y, 0.0f);
        guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22905(this.scale, this.scale, this.scale);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        guiGraphics.method_51448().method_46416(-39.0f, -39.0f, 0.0f);
        GuiUtil.blit(guiGraphics.method_51448(), 0.0f, 0.0f, 78.0f, 78.0f, 0, 0, 256, 256, 0.0f);
        class_1799 filmStack = this.lightroomMenu.method_7611(0).method_7677();
        class_1792 class_17922 = filmStack.method_7909();
        if (!(class_17922 instanceof DevelopedFilmItem)) {
            return;
        }
        DevelopedFilmItem film = (DevelopedFilmItem)class_17922;
        FilmType negative = film.getType();
        RenderSystem.setShaderColor((float)negative.filmR, (float)negative.filmG, (float)negative.filmB, (float)negative.filmA);
        GuiUtil.blit(guiGraphics.method_51448(), 0.0f, 0.0f, 78.0f, 78.0f, 0, 78, 256, 256, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_51448().method_46416(12.0f, 12.0f, 0.0f);
        int currentFrame = this.getLightroomMenu().getSelectedFrame();
        @Nullable class_2487 frame = this.getLightroomMenu().getFrameIdByIndex(currentFrame);
        if (frame != null) {
            this.lightroomScreen.renderFrame(frame, guiGraphics.method_51448(), 0.0f, 0.0f, 54.0f, 1.0f, negative);
        }
        guiGraphics.method_51448().method_22909();
        this.previousButton.field_22764 = currentFrame != 0;
        this.previousButton.field_22763 = currentFrame != 0;
        this.nextButton.field_22764 = currentFrame != this.getLightroomMenu().getTotalFrames() - 1;
        this.nextButton.field_22763 = currentFrame != this.getLightroomMenu().getTotalFrames() - 1;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 || this.minecraft.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.zoom.set(0.0f);
        } else if (this.minecraft.field_1690.field_1913.method_1417(keyCode, scanCode) || keyCode == 263) {
            this.lightroomScreen.changeFrame(PagingDirection.PREVIOUS);
        } else if (this.minecraft.field_1690.field_1849.method_1417(keyCode, scanCode) || keyCode == 262) {
            this.lightroomScreen.changeFrame(PagingDirection.NEXT);
        } else {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean handled = super.method_25402(mouseX, mouseY, button);
        if (handled) {
            return true;
        }
        if (button == 1) {
            this.zoom.set(0.0f);
            return true;
        }
        return false;
    }
}

