/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.gui.ClientGUI;
import io.github.mortuusars.exposure.gui.component.PhotographTooltip;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackedPhotographsItem
extends class_1792 {
    public static final String PHOTOGRAPHS_TAG = "Photographs";

    public StackedPhotographsItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public int getStackLimit() {
        return (Integer)Config.Common.STACKED_PHOTOGRAPHS_MAX_SIZE.get();
    }

    public int getPhotographsCount(class_1799 stack) {
        return this.getOrCreatePhotographsListTag(stack).size();
    }

    public List<ItemAndStack<PhotographItem>> getPhotographs(class_1799 stack) {
        return this.getPhotographs(stack, this.getStackLimit());
    }

    public List<ItemAndStack<PhotographItem>> getPhotographs(class_1799 stack, int limit) {
        class_2499 listTag = this.getOrCreatePhotographsListTag(stack);
        if (listTag.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ItemAndStack<PhotographItem>> photographs = new ArrayList<ItemAndStack<PhotographItem>>();
        for (int i = 0; i < Math.min(listTag.size(), limit); ++i) {
            photographs.add(this.getPhotograph(listTag, i));
        }
        return photographs;
    }

    public boolean canAddPhotograph(class_1799 stack) {
        return this.getPhotographsCount(stack) < this.getStackLimit();
    }

    public void addPhotograph(class_1799 stack, class_1799 photographStack, int index) {
        Preconditions.checkState((index >= 0 && index <= this.getPhotographsCount(stack) ? 1 : 0) != 0, (Object)(index + " is out of bounds. Count: " + this.getPhotographsCount(stack)));
        Preconditions.checkState((boolean)this.canAddPhotograph(stack), (Object)("Cannot add more photographs than this photo can store. Max count: " + this.getStackLimit()));
        class_2499 listTag = this.getOrCreatePhotographsListTag(stack);
        listTag.method_10531(index, (class_2520)photographStack.method_7953(new class_2487()));
        stack.method_7948().method_10566(PHOTOGRAPHS_TAG, (class_2520)listTag);
    }

    public void addPhotographOnTop(class_1799 stack, class_1799 photographStack) {
        this.addPhotograph(stack, photographStack, 0);
    }

    public void addPhotographToBottom(class_1799 stack, class_1799 photographStack) {
        this.addPhotograph(stack, photographStack, this.getPhotographsCount(stack));
    }

    public ItemAndStack<PhotographItem> removePhotograph(class_1799 stack, int index) {
        Preconditions.checkState((index >= 0 && index < this.getPhotographsCount(stack) ? 1 : 0) != 0, (Object)(index + " is out of bounds. Count: " + this.getPhotographsCount(stack)));
        class_2499 listTag = this.getOrCreatePhotographsListTag(stack);
        class_1799 photographStack = class_1799.method_7915((class_2487)((class_2487)listTag.method_10536(index)));
        stack.method_7948().method_10566(PHOTOGRAPHS_TAG, (class_2520)listTag);
        return new ItemAndStack<PhotographItem>(photographStack);
    }

    public ItemAndStack<PhotographItem> removeTopPhotograph(class_1799 stack) {
        return this.removePhotograph(stack, 0);
    }

    public ItemAndStack<PhotographItem> removeBottomPhotograph(class_1799 stack) {
        return this.removePhotograph(stack, this.getPhotographsCount(stack) - 1);
    }

    private class_2499 getOrCreatePhotographsListTag(class_1799 stack) {
        return stack.method_7969() != null ? stack.method_7948().method_10554(PHOTOGRAPHS_TAG, 10) : new class_2499();
    }

    private ItemAndStack<PhotographItem> getPhotograph(class_2499 photographsList, int index) {
        class_2487 stackTag = photographsList.method_10602(index);
        class_1799 stack = class_1799.method_7915((class_2487)stackTag);
        return new ItemAndStack<PhotographItem>(stack);
    }

    @Nullable
    public Either<String, class_2960> getFirstIdOrTexture(class_1799 stack) {
        class_2499 listTag = this.getOrCreatePhotographsListTag(stack);
        if (listTag.isEmpty()) {
            return null;
        }
        class_2487 first = listTag.method_10602(0).method_10562("tag");
        String id = first.method_10558("Id");
        if (!id.isEmpty()) {
            return Either.left((Object)id);
        }
        String resource = first.method_10558("Texture");
        if (!resource.isEmpty()) {
            return Either.right((Object)new class_2960(resource));
        }
        return null;
    }

    public List<@Nullable Either<String, class_2960>> getTopPhotographs(class_1799 stack, int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (String)"count '{}' is not valid. > 0", (int)count);
        ArrayList<@Nullable Either<String, class_2960>> photographs = new ArrayList<Either<String, class_2960>>();
        class_2499 listTag = this.getOrCreatePhotographsListTag(stack);
        for (int i = 0; i < Math.min(listTag.size(), count); ++i) {
            class_2487 photographTag = listTag.method_10602(i).method_10562("tag");
            String id = photographTag.method_10558("Id");
            if (!id.isEmpty()) {
                photographs.add((Either<String, class_2960>)Either.left((Object)id));
                continue;
            }
            String resource = photographTag.method_10558("Texture");
            if (!resource.isEmpty()) {
                photographs.add((Either<String, class_2960>)Either.right((Object)new class_2960(resource)));
                continue;
            }
            photographs.add(null);
        }
        while (photographs.size() < count) {
            photographs.add(null);
        }
        return photographs;
    }

    @NotNull
    public Optional<class_5632> method_32346(@NotNull class_1799 stack) {
        List<ItemAndStack<PhotographItem>> photographs = this.getPhotographs(stack);
        if (photographs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PhotographTooltip(new ItemAndStack<StackedPhotographsItem>(stack)));
    }

    public boolean method_31565(@NotNull class_1799 stack, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player) {
        if (action != class_5536.field_27014 || this.getPhotographsCount(stack) == 0 || !slot.method_7680(new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get()))) {
            return false;
        }
        class_1799 slotItem = slot.method_7677();
        if (slotItem.method_7960()) {
            ItemAndStack<PhotographItem> photograph = this.removeBottomPhotograph(stack);
            slot.method_7673(photograph.getStack());
            if (this.getPhotographsCount(stack) == 1) {
                player.field_7512.method_34254(this.removeTopPhotograph(stack).getStack());
            }
            StackedPhotographsItem.playRemoveSoundClientside(player);
            return true;
        }
        if (slotItem.method_7909() instanceof PhotographItem && this.canAddPhotograph(stack)) {
            this.addPhotographToBottom(stack, slotItem);
            slot.method_7673(class_1799.field_8037);
            StackedPhotographsItem.playAddSoundClientside(player);
            return true;
        }
        return false;
    }

    public boolean method_31566(@NotNull class_1799 stack, @NotNull class_1799 other, @NotNull class_1735 slot, @NotNull class_5536 action, @NotNull class_1657 player, @NotNull class_5630 access) {
        if (action != class_5536.field_27014 || !slot.method_7680(new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get()))) {
            return false;
        }
        if (this.getPhotographsCount(stack) > 0 && other.method_7960()) {
            ItemAndStack<PhotographItem> photograph = this.removeTopPhotograph(stack);
            access.method_32332(photograph.getStack());
            if (this.getPhotographsCount(stack) == 1) {
                ItemAndStack<PhotographItem> lastPhotograph = this.removeTopPhotograph(stack);
                slot.method_7673(lastPhotograph.getStack());
            }
            StackedPhotographsItem.playRemoveSoundClientside(player);
            return true;
        }
        if (other.method_7909() instanceof PhotographItem) {
            if (this.canAddPhotograph(stack)) {
                this.addPhotographOnTop(stack, other);
                access.method_32332(class_1799.field_8037);
                StackedPhotographsItem.playAddSoundClientside(player);
                return true;
            }
            return false;
        }
        class_1792 lastPhotograph = other.method_7909();
        if (lastPhotograph instanceof StackedPhotographsItem) {
            StackedPhotographsItem otherStackedItem = (StackedPhotographsItem)lastPhotograph;
            int otherCount = otherStackedItem.getPhotographsCount(other);
            int addedCount = 0;
            for (int i = 0; i < otherCount; ++i) {
                if (!this.canAddPhotograph(stack)) continue;
                ItemAndStack<PhotographItem> photograph = otherStackedItem.removeBottomPhotograph(other);
                this.addPhotographOnTop(stack, photograph.getStack());
                ++addedCount;
            }
            if (otherStackedItem.getPhotographsCount(other) == 0) {
                access.method_32332(class_1799.field_8037);
            } else if (otherStackedItem.getPhotographsCount(other) == 1) {
                access.method_32332(otherStackedItem.removeTopPhotograph(other).getStack());
            }
            if (addedCount > 0) {
                StackedPhotographsItem.playAddSoundClientside(player);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        if (player.method_21823()) {
            this.cyclePhotographs(itemInHand, player);
            return class_1271.method_22427((Object)itemInHand);
        }
        List<ItemAndStack<PhotographItem>> photographs = this.getPhotographs(itemInHand);
        if (!photographs.isEmpty()) {
            if (level.field_9236) {
                ClientGUI.openPhotographScreen(photographs);
                player.method_5783(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, 1.1f);
            }
            return class_1271.method_22427((Object)itemInHand);
        }
        return class_1271.method_22431((Object)itemInHand);
    }

    public boolean cyclePhotographs(class_1799 stack, @Nullable class_1657 player) {
        if (this.getPhotographsCount(stack) < 2) {
            return false;
        }
        ItemAndStack<PhotographItem> topPhotograph = this.removeTopPhotograph(stack);
        this.addPhotographToBottom(stack, topPhotograph.getStack());
        if (player != null) {
            player.method_37908().method_43129(player, (class_1297)player, Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), class_3419.field_15248, 0.6f, player.method_37908().method_8409().method_43057() * 0.2f + 1.2f);
            player.method_32876(class_5712.field_28146);
        }
        return true;
    }

    public static void playAddSoundClientside(class_1657 player) {
        if (player.method_37908().field_9236) {
            player.method_5783(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.6f, player.method_37908().method_8409().method_43057() * 0.2f + 1.2f);
        }
    }

    public static void playRemoveSoundClientside(class_1657 player) {
        if (player.method_37908().field_9236) {
            player.method_5783(Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), 0.75f, player.method_37908().method_8409().method_43057() * 0.2f + 0.75f);
        }
    }
}

