/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import java.beans.ConstructorProperties;

public class Color {
    int value;
    private float[] frgbvalue = null;
    private float[] fvalue = null;
    private float falpha = 0.0f;

    private static void testColorValueRange(int r, int g, int b, int a) {
        boolean rangeError = false;
        Object badComponentString = "";
        if (a < 0 || a > 255) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Alpha";
        }
        if (r < 0 || r > 255) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Red";
        }
        if (g < 0 || g > 255) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Green";
        }
        if (b < 0 || b > 255) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Blue";
        }
        if (rangeError) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + (String)badComponentString);
        }
    }

    private static void testColorValueRange(float r, float g, float b, float a) {
        boolean rangeError = false;
        Object badComponentString = "";
        if ((double)a < 0.0 || (double)a > 1.0) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Alpha";
        }
        if ((double)r < 0.0 || (double)r > 1.0) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Red";
        }
        if ((double)g < 0.0 || (double)g > 1.0) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Green";
        }
        if ((double)b < 0.0 || (double)b > 1.0) {
            rangeError = true;
            badComponentString = (String)badComponentString + " Blue";
        }
        if (rangeError) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + (String)badComponentString);
        }
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    @ConstructorProperties(value={"red", "green", "blue", "alpha"})
    public Color(int r, int g, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        Color.testColorValueRange(r, g, b, a);
    }

    public Color(int rgb) {
        this.value = 0xFF000000 | rgb;
    }

    public Color(int rgba, boolean hasalpha) {
        this.value = hasalpha ? rgba : 0xFF000000 | rgba;
    }

    public Color(float r, float g, float b) {
        this((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5));
        Color.testColorValueRange(r, g, b, 1.0f);
        this.frgbvalue = new float[3];
        this.frgbvalue[0] = r;
        this.frgbvalue[1] = g;
        this.frgbvalue[2] = b;
        this.falpha = 1.0f;
        this.fvalue = this.frgbvalue;
    }

    public Color(float r, float g, float b, float a) {
        this((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5), (int)((double)(a * 255.0f) + 0.5));
        this.frgbvalue = new float[3];
        this.frgbvalue[0] = r;
        this.frgbvalue[1] = g;
        this.frgbvalue[2] = b;
        this.falpha = a;
        this.fvalue = this.frgbvalue;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof Color && ((Color)obj).getRGB() == this.getRGB();
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float hue;
        int cmin;
        int cmax;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public static Color getHSBColor(float h, float s, float b) {
        return new Color(Color.HSBtoRGB(h, s, b));
    }

    public static int BGRtoRGB(int bgr) {
        int a = bgr >> 24 & 0xFF;
        int b = bgr >> 16 & 0xFF;
        int g = bgr >> 8 & 0xFF;
        int r = bgr & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int getRGBFromHex(String hexColor) {
        return new Color((int)Long.parseLong(hexColor.replace("#", ""), 16), true).getRGB();
    }
}

