/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.tclayer.mixin;

import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.logging.LogUtils;
import dev.emi.trinkets.compat.WrappingTrinketsUtils;
import dev.emi.trinkets.data.EntitySlotLoader;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={io.wispforest.accessories.data.EntitySlotLoader.class})
public abstract class EntitySlotLoaderMixin {
    @Unique
    private static final Logger TRINKET_LOGGER = LogUtils.getLogger();

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableMap;copyOf(Ljava/util/Map;)Lcom/google/common/collect/ImmutableMap;")})
    private void injectTrinketSpecificSlots(Map<class_2960, JsonObject> data, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci, @Local(name={"tempMap"}) HashMap<class_1299<?>, Map<String, SlotType>> tempMap) {
        EntitySlotLoader loader = EntitySlotLoader.SERVER;
        Map slotTypes = SlotTypeLoader.INSTANCE.getSlotTypes(false);
        for (Map.Entry<class_1299<?>, Map<String, Set<String>>> entry : loader.slotInfo.entrySet()) {
            Map innerMap = tempMap.computeIfAbsent(entry.getKey(), entityType -> new HashMap());
            Map<String, Set<String>> groupedSlots = entry.getValue();
            for (Map.Entry<String, Set<String>> groupEntry : groupedSlots.entrySet()) {
                for (String s : groupEntry.getValue()) {
                    String convertedType = WrappingTrinketsUtils.trinketsToAccessories_Slot(Optional.of(groupEntry.getKey()), s);
                    if (innerMap.containsKey(convertedType)) continue;
                    SlotType slotType = (SlotType)slotTypes.get(convertedType);
                    if (slotType == null) {
                        TRINKET_LOGGER.warn("Unable to locate the given slot for a given entity binding, it will be skipped: [Name: {}]", (Object)convertedType);
                        continue;
                    }
                    innerMap.put(slotType.name(), slotType);
                }
            }
        }
    }
}

