/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.init;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.handler.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.Iterator;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.item.InventoryStorageImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_7923;

public class ModBlockEntityTypes {
    public static class_2591<BackpackBlockEntity> BACKPACK;

    public static void init() {
        BACKPACK = (class_2591)class_2378.method_10226((class_2378)class_7923.field_41181, (String)"travelersbackpack:travelers_backpack", (Object)FabricBlockEntityTypeBuilder.create(BackpackBlockEntity::new, (class_2248[])new class_2248[]{ModBlocks.STANDARD_TRAVELERS_BACKPACK, ModBlocks.NETHERITE_TRAVELERS_BACKPACK, ModBlocks.DIAMOND_TRAVELERS_BACKPACK, ModBlocks.GOLD_TRAVELERS_BACKPACK, ModBlocks.EMERALD_TRAVELERS_BACKPACK, ModBlocks.IRON_TRAVELERS_BACKPACK, ModBlocks.LAPIS_TRAVELERS_BACKPACK, ModBlocks.REDSTONE_TRAVELERS_BACKPACK, ModBlocks.COAL_TRAVELERS_BACKPACK, ModBlocks.QUARTZ_TRAVELERS_BACKPACK, ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK, ModBlocks.END_TRAVELERS_BACKPACK, ModBlocks.NETHER_TRAVELERS_BACKPACK, ModBlocks.SANDSTONE_TRAVELERS_BACKPACK, ModBlocks.SNOW_TRAVELERS_BACKPACK, ModBlocks.SPONGE_TRAVELERS_BACKPACK, ModBlocks.CAKE_TRAVELERS_BACKPACK, ModBlocks.CACTUS_TRAVELERS_BACKPACK, ModBlocks.HAY_TRAVELERS_BACKPACK, ModBlocks.MELON_TRAVELERS_BACKPACK, ModBlocks.PUMPKIN_TRAVELERS_BACKPACK, ModBlocks.CREEPER_TRAVELERS_BACKPACK, ModBlocks.DRAGON_TRAVELERS_BACKPACK, ModBlocks.ENDERMAN_TRAVELERS_BACKPACK, ModBlocks.BLAZE_TRAVELERS_BACKPACK, ModBlocks.GHAST_TRAVELERS_BACKPACK, ModBlocks.MAGMA_CUBE_TRAVELERS_BACKPACK, ModBlocks.SKELETON_TRAVELERS_BACKPACK, ModBlocks.SPIDER_TRAVELERS_BACKPACK, ModBlocks.WITHER_TRAVELERS_BACKPACK, ModBlocks.WARDEN_TRAVELERS_BACKPACK, ModBlocks.BAT_TRAVELERS_BACKPACK, ModBlocks.BEE_TRAVELERS_BACKPACK, ModBlocks.WOLF_TRAVELERS_BACKPACK, ModBlocks.FOX_TRAVELERS_BACKPACK, ModBlocks.OCELOT_TRAVELERS_BACKPACK, ModBlocks.HORSE_TRAVELERS_BACKPACK, ModBlocks.COW_TRAVELERS_BACKPACK, ModBlocks.PIG_TRAVELERS_BACKPACK, ModBlocks.SHEEP_TRAVELERS_BACKPACK, ModBlocks.CHICKEN_TRAVELERS_BACKPACK, ModBlocks.SQUID_TRAVELERS_BACKPACK, ModBlocks.VILLAGER_TRAVELERS_BACKPACK, ModBlocks.IRON_GOLEM_TRAVELERS_BACKPACK}).build(null));
    }

    public static void initSidedStorage() {
        FluidStorage.SIDED.registerForBlockEntity(ModBlockEntityTypes::getProperTank, BACKPACK);
        ItemStorage.SIDED.registerForBlockEntity(ModBlockEntityTypes::getProperInventory, BACKPACK);
    }

    public static SingleVariantStorage<FluidVariant> getProperTank(BackpackBlockEntity blockEntity, class_2350 clickedDirection) {
        class_2350 direction = blockEntity.getBlockDirection();
        if (blockEntity.getWrapper() != BackpackWrapper.DUMMY && blockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
            TanksUpgrade tanksUpgrade = blockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
            if (clickedDirection == null) {
                return tanksUpgrade.getLeftTank();
            }
            if (direction == class_2350.field_11043) {
                switch (clickedDirection) {
                    case field_11039: {
                        return tanksUpgrade.getRightTank();
                    }
                    case field_11034: {
                        return tanksUpgrade.getLeftTank();
                    }
                }
            }
            if (direction == class_2350.field_11035) {
                switch (clickedDirection) {
                    case field_11034: {
                        return tanksUpgrade.getRightTank();
                    }
                    case field_11039: {
                        return tanksUpgrade.getLeftTank();
                    }
                }
            }
            if (direction == class_2350.field_11034) {
                switch (clickedDirection) {
                    case field_11043: {
                        return tanksUpgrade.getRightTank();
                    }
                    case field_11035: {
                        return tanksUpgrade.getLeftTank();
                    }
                }
            }
            if (direction == class_2350.field_11039) {
                switch (clickedDirection) {
                    case field_11035: {
                        return tanksUpgrade.getRightTank();
                    }
                    case field_11043: {
                        return tanksUpgrade.getLeftTank();
                    }
                }
            }
            return tanksUpgrade.getLeftTank();
        }
        return new FluidTank(0L);
    }

    public static Storage<ItemVariant> getProperInventory(BackpackBlockEntity blockEntity, class_2350 clickedDirection) {
        if (blockEntity.getWrapper() != BackpackWrapper.DUMMY) {
            return new BackpackStorage(blockEntity.getWrapper().getStorageForInputOutput());
        }
        return InventoryStorageImpl.of((class_1263)new ItemStackHandler(0), null);
    }

    public static class BackpackStorage
    implements Storage<ItemVariant> {
        private final SlottedStorage<ItemVariant> storage;
        private final StorageAccessWrapper backingStorage;

        public BackpackStorage(StorageAccessWrapper backingStorage) {
            this.storage = InventoryStorage.of((class_1263)backingStorage, null);
            this.backingStorage = backingStorage;
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            class_1799 stack = resource.toStack();
            if (this.backingStorage.tryVoiding(stack)) {
                return maxAmount;
            }
            long totalInserted = 0L;
            long remaining = maxAmount;
            for (Pair<Integer, Pair<class_1799, Boolean>> memorizedStack : this.backingStorage.wrapper.getMemorySlots()) {
                SingleSlotStorage slot;
                long inserted;
                int result;
                if (((class_1799)((Pair)memorizedStack.getSecond()).getFirst()).method_7909() != stack.method_7909() || (result = this.matchesStack(stack, memorizedStack)) == -1 || (inserted = (slot = this.storage.getSlot(result)).insert((Object)resource, remaining, transaction)) <= 0L) continue;
                totalInserted += inserted;
                if ((remaining -= inserted) > 0L) continue;
                return totalInserted;
            }
            for (int i = 0; i < this.storage.getSlotCount() && remaining > 0L; ++i) {
                SingleSlotStorage slot;
                long inserted;
                if (this.backingStorage.wrapper.getUnsortableSlots().contains(i) || (inserted = (slot = this.storage.getSlot(i)).insert((Object)resource, remaining, transaction)) <= 0L) continue;
                totalInserted += inserted;
                remaining -= inserted;
            }
            return totalInserted;
        }

        public int matchesStack(class_1799 inserted, Pair<Integer, Pair<class_1799, Boolean>> memorizedStack) {
            if (((Boolean)((Pair)memorizedStack.getSecond()).getSecond()).booleanValue()) {
                return ItemStackUtils.isSameItemSameTags(inserted, (class_1799)((Pair)memorizedStack.getSecond()).getFirst()) ? (Integer)memorizedStack.getFirst() : -1;
            }
            return class_1799.method_7984((class_1799)inserted, (class_1799)((class_1799)((Pair)memorizedStack.getSecond()).getFirst())) ? (Integer)memorizedStack.getFirst() : -1;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            long totalExtracted = 0L;
            long remaining = maxAmount;
            for (int i = 0; i < this.storage.getSlotCount() && remaining > 0L; ++i) {
                long extracted;
                SingleSlotStorage slot;
                if (this.backingStorage.wrapper.getUnsortableSlots().contains(i) || (slot = this.storage.getSlot(i)).isResourceBlank() || !((ItemVariant)slot.getResource()).equals(resource) || (extracted = slot.extract((Object)resource, remaining, transaction)) <= 0L) continue;
                totalExtracted += extracted;
                remaining -= extracted;
            }
            return totalExtracted;
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            final Iterator baseIt = this.storage.iterator();
            return new Iterator<StorageView<ItemVariant>>(){

                @Override
                public boolean hasNext() {
                    return baseIt.hasNext();
                }

                @Override
                public StorageView<ItemVariant> next() {
                    final StorageView original = (StorageView)baseIt.next();
                    return new StorageView<ItemVariant>(){

                        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
                            int slotIndex = this.getSlotIndex((StorageView<ItemVariant>)original);
                            if (backingStorage.wrapper.getUnsortableSlots().contains(slotIndex)) {
                                return 0L;
                            }
                            return original.extract((Object)resource, maxAmount, transaction);
                        }

                        public ItemVariant getResource() {
                            return (ItemVariant)original.getResource();
                        }

                        public long getAmount() {
                            return original.getAmount();
                        }

                        public long getCapacity() {
                            return original.getCapacity();
                        }

                        public boolean isResourceBlank() {
                            return original.isResourceBlank();
                        }

                        public StorageView<ItemVariant> getUnderlyingView() {
                            return original;
                        }
                    };
                }

                private int getSlotIndex(StorageView<ItemVariant> view) {
                    for (int i = 0; i < storage.getSlotCount(); ++i) {
                        if (storage.getSlot(i) != view) continue;
                        return i;
                    }
                    return -1;
                }
            };
        }
    }
}

