/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.refill;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilterSlots;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import org.jetbrains.annotations.Nullable;

public class RefillUpgrade
extends UpgradeBase<RefillUpgrade>
implements IEnable,
ITickableUpgrade,
IFilterSlots {
    private final FilterHandler filter;

    public RefillUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter) {
        super(manager, dataHolderSlot, new Point(66, 28));
        this.filter = this.createFilter(filter, this.getFilterSlotCount());
    }

    @Override
    public int getFilterSlotCount() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.refillUpgradeSettings.filterSlotCount;
    }

    @Override
    public int getSlotsInRow() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.refillUpgradeSettings.slotsInRow;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase createWidget(BackpackScreen screen, int x, int y) {
        return new UpgradeWidgetBase<RefillUpgrade>(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), new Point(137, 0), "screen.travelersbackpack.refill_upgrade");
    }

    @Override
    public List<? extends class_1735> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<1> slots = new ArrayList<1>();
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getSlotsInRow(i); ++j) {
                slots.add(new FilterSlotItemHandler(this, this.filter, j + i * this.getSlotsInRow(), x + 7 + j * 18, y + 23 + i * 18, this.getFilterSlotCount()){

                    @Override
                    public boolean method_7680(class_1799 pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.method_7680(pStack);
                    }
                });
            }
        }
        return slots;
    }

    @Override
    public void tick(@Nullable class_1657 player, class_1937 level, class_2338 pos, int currentTick) {
        if (this.getCooldown() == 0) {
            return;
        }
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        this.getUpgradeManager().getWrapper().loadAdditionally(0);
        this.tryRefillItems(player);
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    public void tryRefillItems(class_1657 player) {
        InventoryHelper.iterateHandler(this.filter, (slot, filterStack) -> {
            if (!filterStack.method_7960()) {
                this.refill(player.method_31548(), player, (class_1799)filterStack);
            }
        });
    }

    public void refill(class_1661 playerInv, class_1657 player, class_1799 filterStack) {
        Pair pair = this.countAndSupply(playerInv, filterStack, player);
        int missingCount = this.getMissingCount(filterStack, (Integer)pair.getFirst());
        if ((Integer)pair.getFirst() >= filterStack.method_7914() || missingCount <= 0) {
            return;
        }
        boolean standalone = false;
        if ((Integer)pair.getFirst() == 0) {
            int count = (Integer)pair.getFirst();
            pair = Pair.of((Object)count, (Object)player.method_31548().method_7376());
            standalone = true;
        }
        if ((Integer)pair.getSecond() == -1) {
            return;
        }
        ItemStackHandler backpackStorage = this.upgradeManager.getWrapper().getStorage();
        class_1799 extracted = InventoryHelper.extractFromBackpack(backpackStorage, filterStack, missingCount, true);
        if (extracted.method_7960()) {
            return;
        }
        boolean addItem = true;
        int extractedCount = extracted.method_7947();
        if (!standalone) {
            player.method_31548().method_5438(((Integer)pair.getSecond()).intValue()).method_7933(extractedCount);
        } else {
            addItem = player.method_7270(extracted);
        }
        if (addItem) {
            InventoryHelper.extractFromBackpack(backpackStorage, filterStack, extractedCount, false);
        }
    }

    private Pair<Integer, Integer> countAndSupply(class_1661 playerInv, class_1799 filterStack, class_1657 player) {
        AtomicInteger count = new AtomicInteger();
        AtomicInteger supplySlot = new AtomicInteger(-1);
        InventoryHelper.iteratePlayerInv(playerInv, (slot, stack) -> {
            if (class_1799.method_31577((class_1799)stack, (class_1799)filterStack)) {
                if (supplySlot.get() == -1) {
                    supplySlot.set((int)slot);
                }
                count.addAndGet(stack.method_7947());
            }
        });
        if (player.field_7512 != null && class_1799.method_31577((class_1799)player.field_7512.method_34255(), (class_1799)filterStack)) {
            count.addAndGet(player.field_7512.method_34255().method_7947());
        }
        return Pair.of((Object)count.get(), (Object)supplySlot.get());
    }

    private int getMissingCount(class_1799 filterStack, int count) {
        return filterStack.method_7914() - count;
    }

    @Override
    public int getTickRate() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.refillUpgradeSettings.tickRate;
    }

    protected FilterHandler createFilter(class_2371<class_1799> stacks, int size) {
        return new FilterHandler(stacks, size){

            @Override
            protected void onContentsChanged(int slot) {
                RefillUpgrade.this.updateDataHolderUnchecked("Inventory", RefillUpgrade.this.filter);
            }
        };
    }
}

