/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotDrawer
extends class_1735 {
    private static final class_1263 emptyInventory = new EmptyInventory();
    private final ContainerDrawers container;
    private final IDrawerGroup group;
    private final IDrawer drawer;

    public SlotDrawer(ContainerDrawers container, IDrawerGroup drawerGroup, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.container = container;
        this.group = drawerGroup;
        this.drawer = this.group.getDrawer(index);
    }

    public boolean method_7680(@NotNull class_1799 stack) {
        return !stack.method_7960() && this.drawer.canItemBeStored(stack);
    }

    @NotNull
    public class_1799 method_7677() {
        class_1799 stack = ItemStackHelper.encodeItemStack(this.drawer.getStoredItemPrototype(), this.drawer.getStoredItemCount());
        this.container.setLastAccessedItem(stack);
        return stack;
    }

    public void method_7673(@NotNull class_1799 stack) {
        IDrawer target = this.drawer.setStoredItem(stack);
        stack = ItemStackHelper.decodeItemStack(stack);
        target.setStoredItemCount(stack.method_7947());
    }

    public void method_7670(@NotNull class_1799 p_75220_1_, @NotNull class_1799 p_75220_2_) {
    }

    public int method_7676(@NotNull class_1799 stack) {
        return Math.min(stack.method_7914(), this.drawer.getRemainingCapacity());
    }

    public boolean method_7674(@NotNull class_1657 playerIn) {
        return false;
    }

    @NotNull
    public class_1799 method_7671(int amount) {
        int withdraw = Math.min(amount, this.drawer.getStoredItemCount());
        this.drawer.setStoredItemCount(withdraw);
        class_1799 stack = this.drawer.getStoredItemPrototype().method_7972();
        stack.method_7939(this.drawer.getStoredItemCount() - withdraw);
        return stack;
    }

    public IDrawerGroup getDrawerGroup() {
        return this.group;
    }

    public IDrawer getDrawer() {
        return this.drawer;
    }

    public boolean isSameInventory(@NotNull class_1735 other) {
        return other instanceof SlotDrawer && ((SlotDrawer)other).getDrawerGroup() == this.group;
    }

    static class EmptyInventory
    extends class_1277
    implements class_1278 {
        public EmptyInventory() {
            super(0);
        }

        public int[] method_5494(@NotNull class_2350 side) {
            return new int[0];
        }

        public boolean method_5492(int index, @NotNull class_1799 itemStackIn, @Nullable class_2350 direction) {
            return false;
        }

        public boolean method_5493(int index, @NotNull class_1799 stack, @NotNull class_2350 direction) {
            return false;
        }
    }
}

