/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.inventory.tooltip.KeyringTooltip;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import com.texelsaurus.minecraft.chameleon.registry.RegistryEntry;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemKeyring
extends class_1792 {
    private static final String TAG_ITEMS = "Items";
    private final RegistryEntry<? extends ItemKey> key;

    public ItemKeyring(RegistryEntry<? extends ItemKey> key, class_1792.class_1793 properties) {
        super(properties);
        this.key = key;
    }

    public class_1799 getKey() {
        if (this.key == null) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)this.key.get(), 1);
    }

    public boolean method_31566(class_1799 targetStack, class_1799 stack, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        class_1799 newStack;
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        if (stack.method_7960()) {
            ItemKeyring.removeOne(targetStack).ifPresent(s -> access.method_32332(s));
            if (ItemKeyring.getContents(targetStack).count() == 0L) {
                class_1799 newStack2 = new class_1799((class_1935)ModItems.KEYRING.get(), 1);
                newStack2.method_7980(targetStack.method_7969());
                slot.method_7673(newStack2);
            } else {
                class_1799 newStack3 = this.rotateKeyring(targetStack);
                slot.method_7673(newStack3);
            }
            return true;
        }
        int added = ItemKeyring.add(targetStack, stack);
        stack.method_7934(added);
        if (targetStack.method_7909() == ModItems.KEYRING.get() && ItemKeyring.getContents(targetStack).count() > 0L && !(newStack = ItemKeyring.getKeyring(ItemKeyring.getContents(targetStack).findFirst().orElse(class_1799.field_8037))).method_7960()) {
            newStack.method_7980(targetStack.method_7969());
            slot.method_7673(newStack);
        }
        return true;
    }

    public static class_1799 getKeyring(class_1799 item) {
        if (item.method_7960() || !(item.method_7909() instanceof ItemKey)) {
            return class_1799.field_8037;
        }
        Optional<ItemKeyring> keyring = ModItems.getKeyrings().filter(s -> s.getKey().method_7909() == item.method_7909()).findFirst();
        if (!keyring.isPresent()) {
            return class_1799.field_8037;
        }
        return new class_1799((class_1935)keyring.get(), 1);
    }

    public static int add(class_1799 target, class_1799 item) {
        class_2499 list;
        if (item.method_7960() || !(item.method_7909() instanceof ItemKey)) {
            return 0;
        }
        class_2487 tag = target.method_7948();
        if (!tag.method_10545(TAG_ITEMS)) {
            tag.method_10566(TAG_ITEMS, (class_2520)new class_2499());
        }
        if ((list = tag.method_10554(TAG_ITEMS, 10)).size() >= 64) {
            return 0;
        }
        Optional<class_2487> match = ItemKeyring.getMatchingItem(item, list);
        if (match.isPresent()) {
            return 0;
        }
        class_1799 copy = item.method_7972();
        copy.method_7939(1);
        class_2487 entry = new class_2487();
        copy.method_7953(entry);
        list.method_10531(0, (class_2520)entry);
        return 1;
    }

    private static Optional<class_2487> getMatchingItem(class_1799 stack, class_2499 list) {
        return list.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).filter(t -> class_1799.method_31577((class_1799)class_1799.method_7915((class_2487)t), (class_1799)stack)).findFirst();
    }

    private static class_1799 getActiveKey(class_1799 stack, class_1792 item) {
        class_2487 tag = stack.method_7948();
        if (!tag.method_10545(TAG_ITEMS)) {
            return null;
        }
        class_2499 list = tag.method_10554(TAG_ITEMS, 10);
        if (list.isEmpty()) {
            return null;
        }
        return list.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).map(class_1799::method_7915).filter(t -> class_1799.method_7984((class_1799)t, (class_1799)new class_1799((class_1935)item))).findFirst().orElse(null);
    }

    private static Optional<class_1799> removeOne(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (!tag.method_10545(TAG_ITEMS)) {
            return Optional.empty();
        }
        class_2499 list = tag.method_10554(TAG_ITEMS, 10);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        class_2487 first = list.method_10602(0);
        class_1799 firstStack = class_1799.method_7915((class_2487)first);
        list.method_10536(0);
        if (list.isEmpty()) {
            tag.method_10551(TAG_ITEMS);
        }
        return Optional.of(firstStack);
    }

    private static Stream<class_1799> getContents(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return Stream.empty();
        }
        class_2499 list = tag.method_10554(TAG_ITEMS, 10);
        return list.stream().map(class_2487.class::cast).map(class_1799::method_7915);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_2371 nonnulllist = class_2371.method_10211();
        ItemKeyring.getContents(stack).forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new KeyringTooltip((class_2371<class_1799>)nonnulllist));
    }

    public class_2561 method_7864(class_1799 stack) {
        if (this.key == null || this.key.get() == null) {
            return super.method_7864(stack);
        }
        class_1799 activeKey = ItemKeyring.getActiveKey(stack, (class_1792)this.key.get());
        Object subName = activeKey != null ? activeKey.method_7964() : class_2561.method_43471((String)((ItemKey)((Object)this.key.get())).method_7876());
        class_5250 name = class_2561.method_43471((String)((ItemKeyring)((Object)ModItems.KEYRING.get())).method_7876());
        return name.method_27693(" (").method_10852(subName).method_27693(")");
    }

    @NotNull
    public class_2561 method_7848() {
        return class_2561.method_43471((String)(((ItemKeyring)((Object)ModItems.KEYRING.get())).method_7876() + ".desc"));
    }

    public void method_7851(@NotNull class_1799 itemStack, @Nullable class_1937 world, List<class_2561> list, class_1836 advanced) {
        ComponentUtil.appendSplitDescription(list, this);
    }

    public void method_33261(class_1542 entity) {
        class_5328.method_33263((class_1542)entity, ItemKeyring.getContents(entity.method_6983()));
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036().method_5715()) {
            return class_1269.field_5811;
        }
        if (this.key != null) {
            class_1269 result = ((ItemKey)((Object)this.key.get())).method_7884(context);
            if (result == class_1269.field_5812) {
                context.method_8036().method_7357().method_7906((class_1792)this, 5);
            }
            return result;
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!player.method_5715()) {
            return class_1271.method_22430((Object)stack);
        }
        List<class_1799> list = ItemKeyring.getContents(stack).toList();
        if (list.isEmpty()) {
            return class_1271.method_22430((Object)stack);
        }
        class_1799 keyring = this.rotateKeyring(stack);
        return class_1271.method_22427((Object)keyring);
    }

    private class_1799 rotateKeyring(class_1799 stack) {
        List<class_1799> list = ItemKeyring.getContents(stack).toList();
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).method_7909() != this.key.get()) continue;
            index = i;
            break;
        }
        if (++index >= list.size()) {
            index = 0;
        }
        class_1799 nextItem = list.get(index);
        class_1799 keyring = ItemKeyring.getKeyring(nextItem);
        keyring.method_7980(stack.method_7969());
        return keyring;
    }
}

