/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_1429;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2902;
import net.minecraft.class_5132;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import samebutdifferent.ecologics.block.properties.ModWoodType;
import samebutdifferent.ecologics.entity.CoconutCrab;
import samebutdifferent.ecologics.entity.Penguin;
import samebutdifferent.ecologics.entity.Squirrel;
import samebutdifferent.ecologics.platform.CommonPlatformHelper;
import samebutdifferent.ecologics.registry.ModBlockEntityTypes;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModFeatures;
import samebutdifferent.ecologics.registry.ModFoliagePlacerTypes;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.ModMobEffects;
import samebutdifferent.ecologics.registry.ModPotions;
import samebutdifferent.ecologics.registry.ModSoundEvents;
import samebutdifferent.ecologics.registry.ModTrunkPlacerTypes;

public class Ecologics {
    public static final String MOD_ID = "ecologics";
    public static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        ModBlocks.init();
        ModItems.init();
        ModSoundEvents.init();
        ModEntityTypes.init();
        ModBlockEntityTypes.init();
        ModFeatures.init();
        ModTrunkPlacerTypes.init();
        ModFoliagePlacerTypes.init();
        ModMobEffects.init();
        ModPotions.init();
    }

    public static void commonSetup() {
        Ecologics.registerWoodTypes();
        Ecologics.registerBrewingRecipes();
        Ecologics.registerCompostables();
        Ecologics.registerStrippables();
        Ecologics.registerFlammables();
        Ecologics.registerSpawnPlacements();
    }

    public static void registerWoodTypes() {
        CommonPlatformHelper.registerWoodType(ModWoodType.COCONUT);
        CommonPlatformHelper.registerWoodType(ModWoodType.WALNUT);
        CommonPlatformHelper.registerWoodType(ModWoodType.AZALEA);
        CommonPlatformHelper.registerWoodType(ModWoodType.FLOWERING_AZALEA);
    }

    public static void registerBrewingRecipes() {
        CommonPlatformHelper.registerBrewingRecipe(class_1847.field_8999, ModItems.PENGUIN_FEATHER.get(), ModPotions.SLIDING.get());
        CommonPlatformHelper.registerBrewingRecipe(ModPotions.SLIDING.get(), class_1802.field_8725, ModPotions.LONG_SLIDING.get());
    }

    public static void registerCompostables() {
        CommonPlatformHelper.registerCompostable(0.3f, (class_1935)ModItems.COCONUT_SLICE.get());
        CommonPlatformHelper.registerCompostable(0.65f, (class_1935)ModItems.COCONUT_HUSK.get());
        CommonPlatformHelper.registerCompostable(0.3f, (class_1935)ModBlocks.COCONUT_LEAVES.get());
        CommonPlatformHelper.registerCompostable(0.3f, (class_1935)ModBlocks.COCONUT_SEEDLING.get());
        CommonPlatformHelper.registerCompostable(0.3f, (class_1935)ModBlocks.WALNUT_LEAVES.get());
        CommonPlatformHelper.registerCompostable(0.3f, (class_1935)ModBlocks.WALNUT_SAPLING.get());
        CommonPlatformHelper.registerCompostable(0.65f, (class_1935)ModBlocks.AZALEA_FLOWER.get());
    }

    public static void registerStrippables() {
        ImmutableMap strippables = new ImmutableMap.Builder().put((Object)((class_2248)ModBlocks.COCONUT_LOG.get()), (Object)((class_2248)ModBlocks.STRIPPED_COCONUT_LOG.get())).put((Object)((class_2248)ModBlocks.COCONUT_WOOD.get()), (Object)((class_2248)ModBlocks.STRIPPED_COCONUT_WOOD.get())).put((Object)((class_2248)ModBlocks.WALNUT_LOG.get()), (Object)((class_2248)ModBlocks.STRIPPED_WALNUT_LOG.get())).put((Object)((class_2248)ModBlocks.WALNUT_WOOD.get()), (Object)((class_2248)ModBlocks.STRIPPED_WALNUT_WOOD.get())).put((Object)((class_2248)ModBlocks.AZALEA_LOG.get()), (Object)((class_2248)ModBlocks.STRIPPED_AZALEA_LOG.get())).put((Object)((class_2248)ModBlocks.FLOWERING_AZALEA_LOG.get()), (Object)((class_2248)ModBlocks.STRIPPED_AZALEA_LOG.get())).put((Object)((class_2248)ModBlocks.FLOWERING_AZALEA_WOOD.get()), (Object)((class_2248)ModBlocks.STRIPPED_AZALEA_WOOD.get())).put((Object)((class_2248)ModBlocks.AZALEA_WOOD.get()), (Object)((class_2248)ModBlocks.STRIPPED_AZALEA_WOOD.get())).build();
        CommonPlatformHelper.registerStrippables((Map<class_2248, class_2248>)strippables);
    }

    public static void registerFlammables() {
        CommonPlatformHelper.setFlammable(ModBlocks.COCONUT_PLANKS, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.COCONUT_SLAB, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.COCONUT_FENCE_GATE, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.COCONUT_FENCE, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.COCONUT_STAIRS, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.COCONUT_LOG, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.STRIPPED_COCONUT_LOG, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.STRIPPED_COCONUT_WOOD, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.COCONUT_WOOD, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.COCONUT_LEAVES, 30, 60);
        CommonPlatformHelper.setFlammable(ModBlocks.WALNUT_PLANKS, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.WALNUT_SLAB, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.WALNUT_FENCE_GATE, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.WALNUT_FENCE, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.WALNUT_STAIRS, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.WALNUT_LOG, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.STRIPPED_WALNUT_LOG, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.STRIPPED_WALNUT_WOOD, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.WALNUT_WOOD, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.WALNUT_LEAVES, 30, 60);
        CommonPlatformHelper.setFlammable(ModBlocks.AZALEA_PLANKS, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.AZALEA_SLAB, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.AZALEA_FENCE_GATE, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.AZALEA_FENCE, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.AZALEA_STAIRS, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.AZALEA_LOG, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.STRIPPED_AZALEA_LOG, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.STRIPPED_AZALEA_WOOD, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.AZALEA_WOOD, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.FLOWERING_AZALEA_PLANKS, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.FLOWERING_AZALEA_SLAB, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.FLOWERING_AZALEA_FENCE_GATE, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.FLOWERING_AZALEA_FENCE, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.FLOWERING_AZALEA_STAIRS, 5, 20);
        CommonPlatformHelper.setFlammable(ModBlocks.FLOWERING_AZALEA_LOG, 5, 5);
        CommonPlatformHelper.setFlammable(ModBlocks.FLOWERING_AZALEA_WOOD, 5, 5);
    }

    public static void registerSpawnPlacements() {
        CommonPlatformHelper.registerSpawnPlacement(ModEntityTypes.PENGUIN.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, Penguin::checkPenguinSpawnRules);
        CommonPlatformHelper.registerSpawnPlacement(ModEntityTypes.SQUIRREL.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_1429::method_20663);
    }

    public static void registerEntityAttributes(Map<class_1299<? extends class_1309>, class_5132.class_5133> attributes) {
        attributes.put(ModEntityTypes.COCONUT_CRAB.get(), CoconutCrab.createAttributes());
        attributes.put(ModEntityTypes.PENGUIN.get(), Penguin.createAttributes());
        attributes.put(ModEntityTypes.SQUIRREL.get(), Squirrel.createAttributes());
    }
}

