/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.loader;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1767;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2356;
import net.minecraft.class_2362;
import net.minecraft.class_2420;
import net.minecraft.class_2431;
import net.minecraft.class_2440;
import net.minecraft.class_2468;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2563;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5547;
import net.minecraft.class_5699;
import net.minecraft.class_5812;
import net.minecraft.class_5813;
import net.minecraft.class_5814;
import net.minecraft.class_6017;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8170;
import org.apache.commons.lang3.NotImplementedException;
import snownee.kiwi.customization.block.BasicBlock;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.loader.InjectedBlockPropertiesCodec;
import snownee.kiwi.customization.block.loader.KBlockComponents;
import snownee.kiwi.customization.duck.KBlockProperties;
import snownee.kiwi.util.codec.CustomizationCodecs;

public class BlockCodecs {
    private static final Map<class_2960, MapCodec<class_2248>> CODECS = Maps.newHashMap();
    public static final String BLOCK_PROPERTIES_KEY = "properties";
    private static final Codec<class_4970.class_2251> BLOCK_PROPERTIES = new InjectedBlockPropertiesCodec((Codec<class_4970.class_2251>)Codec.unit(class_4970.class_2251::method_9637));
    public static final Function<class_4970.class_2251, class_2248> SIMPLE_BLOCK_FACTORY = properties -> {
        KBlockSettings settings = ((KBlockProperties)properties).kiwi$getSettings();
        if (settings != null && settings.hasComponent(KBlockComponents.WATER_LOGGABLE.getOrCreate())) {
            return new BasicBlock((class_4970.class_2251)properties);
        }
        return new class_2248(properties);
    };
    public static final MapCodec<class_2248> BLOCK = BlockCodecs.simpleCodec(SIMPLE_BLOCK_FACTORY);
    public static final MapCodec<class_2510> STAIR = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2680.field_24734.optionalFieldOf("base_state", (Object)class_2246.field_10124.method_9564()).forGetter(block -> {
        throw new UnsupportedOperationException();
    }), BlockCodecs.propertiesCodec()).apply((Applicative)instance, class_2510::new));
    public static final MapCodec<class_2323> DOOR = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)CustomizationCodecs.BLOCK_SET_TYPE.fieldOf("block_set_type").forGetter(class_2323::method_51169)).apply((Applicative)instance, class_2323::new));
    public static final MapCodec<class_2533> TRAPDOOR = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)CustomizationCodecs.BLOCK_SET_TYPE.fieldOf("block_set_type").forGetter(block -> block.field_42779)).apply((Applicative)instance, class_2533::new));
    public static final MapCodec<class_2349> FENCE_GATE = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)CustomizationCodecs.WOOD_TYPE.optionalFieldOf("wood_type", (Object)class_4719.field_21676).forGetter($ -> class_4719.field_21676)).apply((Applicative)instance, class_2349::new));
    public static final MapCodec<class_2468> SAND = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("falling_dust_color", (Object)14406560).forGetter($ -> 14406560), BlockCodecs.propertiesCodec()).apply((Applicative)instance, class_2468::new));
    public static final MapCodec<class_2431> DROP_EXPERIENCE = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)class_6017.field_33450.fieldOf("xp").forGetter(BlockCodecs::notImplemented)).apply((Applicative)instance, class_2431::new));
    public static final MapCodec<class_2420> MUSHROOM = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)class_5321.method_39154((class_5321)class_7924.field_41239).fieldOf("feature").forGetter(BlockCodecs::notImplemented)).apply((Applicative)instance, class_2420::new));
    public static final MapCodec<class_2356> FLOWER = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41174.method_39673().fieldOf("suspicious_stew_effect").forGetter(class_2356::method_10188), (App)class_5699.field_33442.fieldOf("effect_duration").forGetter(class_2356::method_10187), BlockCodecs.propertiesCodec()).apply((Applicative)instance, class_2356::new));
    public static final MapCodec<class_2362> FLOWER_POT = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("content").forGetter(class_2362::method_16231), BlockCodecs.propertiesCodec()).apply((Applicative)instance, class_2362::new));
    public static final MapCodec<class_2563> WITHER_ROSE = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41174.method_39673().fieldOf("effect").forGetter(class_2356::method_10188), BlockCodecs.propertiesCodec()).apply((Applicative)instance, class_2563::new));
    public static final MapCodec<class_2269> BUTTON = RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec(), (App)CustomizationCodecs.BLOCK_SET_TYPE.fieldOf("block_set_type").forGetter(BlockCodecs::notImplemented), (App)class_5699.field_33442.optionalFieldOf("ticks_to_stay_pressed").forGetter(BlockCodecs::notImplemented), (App)Codec.BOOL.optionalFieldOf("arrows_can_press").forGetter(BlockCodecs::notImplemented)).apply((Applicative)instance, (properties, blockSetType, ticksToStayPressed, arrowsCanPress) -> new class_2269(properties, blockSetType, ticksToStayPressed.orElse(blockSetType.comp_1471() ? 30 : 20).intValue(), arrowsCanPress.orElse(blockSetType.comp_1471()).booleanValue())));
    public static final MapCodec<class_2440> PRESSURE_PLATE = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.SENSITIVITY_CODEC.optionalFieldOf("sensitivity").forGetter(BlockCodecs::notImplemented), BlockCodecs.propertiesCodec(), (App)CustomizationCodecs.BLOCK_SET_TYPE.fieldOf("block_set_type").forGetter(BlockCodecs::notImplemented)).apply((Applicative)instance, (sensitivity, properties, blockSetType) -> new class_2440(sensitivity.orElse(blockSetType.comp_1471() ? class_2440.class_2441.field_11361 : class_2440.class_2441.field_11362), properties, blockSetType)));
    public static final MapCodec<class_5812> WEATHERING_COPPER_FULL = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.WEATHER_STATE.fieldOf("weather_state").forGetter(class_5547::method_33622), BlockCodecs.propertiesCodec()).apply((Applicative)instance, class_5812::new));
    public static final MapCodec<class_5813> WEATHERING_COPPER_SLAB = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.WEATHER_STATE.fieldOf("weather_state").forGetter(class_5547::method_33622), BlockCodecs.propertiesCodec()).apply((Applicative)instance, class_5813::new));
    public static final MapCodec<class_5814> WEATHERING_COPPER_STAIR = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CustomizationCodecs.WEATHER_STATE.fieldOf("weather_state").forGetter(class_5547::method_33622), (App)class_2680.field_24734.fieldOf("base_state").forGetter($ -> {
        throw new UnsupportedOperationException();
    }), BlockCodecs.propertiesCodec()).apply((Applicative)instance, class_5814::new));
    public static final MapCodec<class_2244> BED = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1767.field_41600.fieldOf("color").forGetter(class_2244::method_9487), BlockCodecs.propertiesCodec()).apply((Applicative)instance, class_2244::new));
    public static final MapCodec<class_8170> BRUSHABLE = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("turns_into").forGetter(class_8170::method_49810), BlockCodecs.propertiesCodec(), (App)class_7923.field_41172.method_39673().optionalFieldOf("brush_sound", (Object)class_3417.field_43156).forGetter(class_8170::method_49811), (App)class_7923.field_41172.method_39673().optionalFieldOf("brush_completed_sound", (Object)class_3417.field_43158).forGetter(class_8170::method_49812)).apply((Applicative)instance, class_8170::new));

    public static <B extends class_2248> RecordCodecBuilder<B, class_4970.class_2251> propertiesCodec() {
        return BLOCK_PROPERTIES.fieldOf(BLOCK_PROPERTIES_KEY).forGetter(block -> block.field_23155);
    }

    public static <B extends class_2248> MapCodec<B> simpleCodec(Function<class_4970.class_2251, B> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(BlockCodecs.propertiesCodec()).apply((Applicative)instance, function));
    }

    public static void register(class_2960 key, MapCodec<? extends class_2248> codec) {
        CODECS.put(key, codec);
    }

    public static MapCodec<class_2248> get(class_2960 key) {
        return Objects.requireNonNull(CODECS.get(key), () -> ((class_2960)key).toString());
    }

    public static <O, A> A notImplemented(O block) {
        throw new NotImplementedException();
    }

    static {
        BlockCodecs.register(new class_2960("block"), BLOCK);
        BlockCodecs.register(new class_2960("stair"), STAIR);
        BlockCodecs.register(new class_2960("door"), DOOR);
        BlockCodecs.register(new class_2960("trapdoor"), TRAPDOOR);
        BlockCodecs.register(new class_2960("fence_gate"), FENCE_GATE);
        BlockCodecs.register(new class_2960("colored_falling"), SAND);
        BlockCodecs.register(new class_2960("drop_experience"), DROP_EXPERIENCE);
        BlockCodecs.register(new class_2960("mushroom"), MUSHROOM);
        BlockCodecs.register(new class_2960("flower"), FLOWER);
        BlockCodecs.register(new class_2960("flower_pot"), FLOWER_POT);
        BlockCodecs.register(new class_2960("wither_rose"), WITHER_ROSE);
        BlockCodecs.register(new class_2960("button"), BUTTON);
        BlockCodecs.register(new class_2960("pressure_plate"), PRESSURE_PLATE);
        BlockCodecs.register(new class_2960("weathering_copper_full"), WEATHERING_COPPER_FULL);
        BlockCodecs.register(new class_2960("weathering_copper_slab"), WEATHERING_COPPER_SLAB);
        BlockCodecs.register(new class_2960("weathering_copper_stair"), WEATHERING_COPPER_STAIR);
        BlockCodecs.register(new class_2960("bed"), BED);
        BlockCodecs.register(new class_2960("brushable"), BRUSHABLE);
    }
}

