/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import snownee.kiwi.customization.block.loader.BlockCodecs;
import snownee.kiwi.customization.block.loader.BlockDefinitionProperties;
import snownee.kiwi.customization.block.loader.InjectedBlockPropertiesCodec;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.block.loader.KBlockTemplates;
import snownee.kiwi.customization.block.loader.KMaterial;
import snownee.kiwi.util.resource.OneTimeLoader;

public final class BuiltInBlockTemplate
extends KBlockTemplate {
    private final Optional<class_2960> key;
    private MapCodec<class_2248> codec;

    public BuiltInBlockTemplate(Optional<BlockDefinitionProperties> properties, Optional<class_2960> key) {
        super(properties);
        this.key = key;
    }

    public static Codec<BuiltInBlockTemplate> directCodec(MapCodec<Optional<KMaterial>> materialCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)BlockDefinitionProperties.mapCodecField(materialCodec).forGetter(KBlockTemplate::properties), (App)class_2960.field_25139.optionalFieldOf("codec").forGetter(BuiltInBlockTemplate::key)).apply((Applicative)instance, BuiltInBlockTemplate::new));
    }

    @Override
    public KBlockTemplate.Type<?> type() {
        return KBlockTemplates.BUILT_IN.getOrCreate();
    }

    @Override
    public void resolve(class_2960 key, OneTimeLoader.Context context) {
        this.codec = BlockCodecs.get(this.key.orElse(key));
    }

    @Override
    public class_2248 createBlock(class_2960 id, class_4970.class_2251 properties, JsonObject json) {
        if (!json.has("properties")) {
            json.add("properties", (JsonElement)new JsonObject());
        }
        InjectedBlockPropertiesCodec.INJECTED.set(properties);
        DataResult result = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (MapLike)JsonOps.INSTANCE.getMap((JsonElement)json).result().orElseThrow());
        if (result.error().isPresent()) {
            throw new IllegalStateException(((DataResult.PartialResult)result.error().get()).message());
        }
        return (class_2248)result.result().orElseThrow();
    }

    public Optional<class_2960> key() {
        return this.key;
    }

    public String toString() {
        return "BuiltInBlockTemplate[properties=" + this.properties + ", key=" + this.key + ", codec=" + this.codec + "]";
    }
}

