/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.family.BlockFamilies;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PacketHandler;
import snownee.kiwi.util.KHolder;

@KiwiPacket(value="convert_item", dir=KiwiPacket.Direction.PLAY_TO_SERVER)
public class CConvertItemPacket
extends PacketHandler {
    public static final int MAX_STEPS = 4;
    public static CConvertItemPacket I;

    public static void send(boolean inContainer, int slot, Entry entry, class_1792 from, boolean convertOne) {
        I.sendToServer(buf -> {
            buf.writeBoolean(inContainer);
            buf.writeBoolean(convertOne);
            buf.method_10804(slot);
            buf.method_42065((class_2359)class_7923.field_41178, (Object)from);
            buf.method_10804(entry.steps().size());
            for (Pair<KHolder<BlockFamily>, class_1792> step : entry.steps()) {
                buf.method_10812(((KHolder)step.getFirst()).key());
                buf.method_42065((class_2359)class_7923.field_41178, (Object)((class_1792)step.getSecond()));
            }
        });
    }

    @Override
    public CompletableFuture<class_2540> receive(Function<Runnable, CompletableFuture<class_2540>> function, class_2540 buf, @Nullable class_3222 player) {
        boolean inContainer = buf.readBoolean();
        boolean convertOne = buf.readBoolean();
        int slotIndex = buf.method_10816();
        class_1792 from = (class_1792)buf.method_42064((class_2359)class_7923.field_41178);
        if (from == null) {
            return null;
        }
        int size = buf.method_10816();
        ArrayList steps = Lists.newArrayListWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            class_2960 familyId = buf.method_10810();
            class_1792 item = (class_1792)buf.method_42064((class_2359)class_7923.field_41178);
            if (item == null) {
                return null;
            }
            steps.add(Pair.of((Object)familyId, (Object)item));
        }
        if (steps.isEmpty() || steps.size() > 4) {
            return null;
        }
        class_1792 to = (class_1792)((Pair)steps.get(steps.size() - 1)).getSecond();
        if (from == to) {
            return null;
        }
        return function.apply(() -> {
            class_1799 newItem;
            class_1799 sourceItem;
            Objects.requireNonNull(player);
            class_1792 item = from;
            int index = 0;
            float ratio = 1.0f;
            for (Pair step : steps) {
                BlockFamily family = BlockFamilies.get((class_2960)step.getFirst());
                if (!(family != null && family.switchAttrs().enabled() && family.contains(item) && family.contains((class_1792)step.getSecond()))) {
                    return;
                }
                if (!family.switchAttrs().cascading() && index != steps.size() - 1) {
                    return;
                }
                if (!player.method_7337()) {
                    ratio *= BlockFamilies.getConvertRatio(item) / BlockFamilies.getConvertRatio((class_1792)step.getSecond());
                }
                item = (class_1792)step.getSecond();
                ++index;
            }
            class_1735 slot = null;
            class_1661 playerInventory = player.method_31548();
            try {
                if (slotIndex == -500) {
                    if (!player.method_7337()) return;
                    sourceItem = from.method_7854();
                } else if (inContainer) {
                    slot = (class_1735)player.field_7512.field_7761.get(slotIndex);
                    if (!slot.method_32754((class_1657)player)) {
                        return;
                    }
                    sourceItem = slot.method_7677();
                } else {
                    sourceItem = playerInventory.method_5438(slotIndex);
                }
            }
            catch (Exception e) {
                return;
            }
            if (!sourceItem.method_31574(from)) {
                return;
            }
            boolean skipSettingSlot = false;
            int inventorySwap = Integer.MIN_VALUE;
            if (ratio >= 1.0f) {
                newItem = to.method_7854();
            } else {
                if (convertOne) {
                    return;
                }
                for (int i = 0; i < playerInventory.method_5439(); ++i) {
                    class_1799 stack = playerInventory.method_5438(i);
                    if (!stack.method_31574(to)) continue;
                    inventorySwap = i;
                    break;
                }
                if (inventorySwap == Integer.MIN_VALUE) {
                    return;
                }
                newItem = playerInventory.method_5438(inventorySwap);
            }
            newItem.method_7912(5);
            int ratioInt = class_3532.method_15375((float)ratio);
            if (convertOne) {
                if (!player.method_7337()) {
                    sourceItem.method_7934(1);
                    newItem.method_7939(ratioInt);
                }
                if (!sourceItem.method_7960()) {
                    this.addToPlayer(player, newItem, !inContainer);
                    skipSettingSlot = true;
                }
            } else if (inventorySwap == Integer.MIN_VALUE) {
                int maxSize = newItem.method_7914();
                int count = Math.min(sourceItem.method_7947(), maxSize / ratioInt);
                newItem.method_7939(count * ratioInt);
                if (!player.method_7337()) {
                    sourceItem.method_7934(count);
                }
            }
            if (slotIndex != -500 && !skipSettingSlot) {
                try {
                    if (inContainer) {
                        if (!slot.method_7680(newItem)) {
                            return;
                        }
                        slot.method_48931(newItem);
                    } else {
                        playerInventory.method_5447(slotIndex, newItem);
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
            if (inventorySwap != Integer.MIN_VALUE) {
                playerInventory.method_5447(inventorySwap, sourceItem);
            } else if (!skipSettingSlot && !player.method_7337()) {
                this.addToPlayer(player, sourceItem.method_7972(), !inContainer);
            }
            CConvertItemPacket.playPickupSound((class_1657)player);
            player.field_7512.method_7623();
        });
    }

    private void addToPlayer(class_3222 player, class_1799 itemStack, boolean nextToSelected) {
        int slot;
        class_1661 inventory = player.method_31548();
        IntStream intStream = IntStream.range(0, 9);
        if (nextToSelected) {
            IntStream leftAndRight = IntStream.of(inventory.field_7545 + 1, inventory.field_7545 - 1);
            intStream = IntStream.concat(leftAndRight, intStream);
        }
        if (!inventory.method_7367(slot = intStream.filter(class_1661::method_7380).filter(i -> {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                return true;
            }
            return stack.method_7947() < stack.method_7914() && class_1799.method_31577((class_1799)stack, (class_1799)itemStack);
        }).findFirst().orElse(-1), itemStack) && !player.method_7337()) {
            player.method_7328(itemStack, true);
        }
    }

    public static void playPickupSound(class_1657 player) {
        player.method_37908().method_43128((class_1657)(player.method_7340() ? player : null), player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((player.method_6051().method_43057() - player.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
    }

    public record Entry(float ratio, List<Pair<KHolder<BlockFamily>, class_1792>> steps) {
        public Entry(float ratio) {
            this(ratio, Lists.newArrayList());
        }

        public class_1792 item() {
            return (class_1792)this.steps.get(this.steps.size() - 1).getSecond();
        }
    }

    public record Group(LinkedHashSet<Entry> entries) {
        public Group() {
            this(Sets.newLinkedHashSet());
        }
    }
}

