/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.util.platform.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.registry.SyncedConfigRegistry;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\tJ\u0015\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0006J\u001d\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u001d\u0010\u001d\u001a\u00020\u001c2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002\u00a2\u0006\u0004\b\u001d\u0010!\u00a8\u0006\""}, d2={"Lme/fzzyhmstrs/fzzy_config/util/platform/impl/PlatformUtils;", "", "<init>", "()V", "", "isClient", "()Z", "Ljava/io/File;", "configDir", "()Ljava/io/File;", "gameDir", "", "mod", "isModLoaded", "(Ljava/lang/String;)Z", "isDev", "scope", "fallback", "configName", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "", "customScopes", "()Ljava/util/List;", "Lnet/minecraft/class_1657;", "player", "permission", "hasPermission", "(Lnet/minecraft/class_1657;Ljava/lang/String;)Z", "", "registerCommands", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "fzzy_config"})
public final class PlatformUtils {
    @NotNull
    public static final PlatformUtils INSTANCE = new PlatformUtils();

    private PlatformUtils() {
    }

    public final boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @NotNull
    public final File configDir() {
        File file = FabricLoader.getInstance().getConfigDir().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @NotNull
    public final File gameDir() {
        File file = FabricLoader.getInstance().getGameDir().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    public final boolean isModLoaded(@NotNull String mod) {
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        return FabricLoader.getInstance().isModLoaded(mod);
    }

    public final boolean isDev() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @NotNull
    public final String configName(@NotNull String scope, @NotNull String fallback) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        Object object = FabricLoader.getInstance().getModContainer(scope);
        if (object == null || (object = (ModContainer)((Optional)object).get()) == null || (object = object.getMetadata()) == null || (object = object.getName()) == null) {
            object = fallback;
        }
        return object;
    }

    @NotNull
    public final List<String> customScopes() {
        List list = new ArrayList();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            CustomValue customValue;
            if (container.getMetadata().getCustomValue("fzzy_config") == null || customValue.getType() != CustomValue.CvType.ARRAY) continue;
            CustomValue.CvArray arrayValue = customValue.getAsArray();
            for (CustomValue thing : arrayValue) {
                if (thing.getType() != CustomValue.CvType.STRING) continue;
                String string = thing.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                list.add(string);
            }
        }
        return list;
    }

    public final boolean hasPermission(@NotNull class_1657 player, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return Permissions.check((class_1297)((class_1297)player), (String)permission);
    }

    public final void registerCommands() {
        CommandRegistrationCallback.EVENT.register(PlatformUtils::registerCommands$lambda$0);
    }

    private final void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"configure_update").requires(PlatformUtils::registerCommands$lambda$1)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)((ArgumentType)StringArgumentType.string())).then(class_2170.method_9247((String)"inspect").executes(PlatformUtils::registerCommands$lambda$4))).then(class_2170.method_9247((String)"accept").executes(PlatformUtils::registerCommands$lambda$6))).then(class_2170.method_9247((String)"reject").executes(PlatformUtils::registerCommands$lambda$8))));
    }

    private static final void registerCommands$lambda$0(CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        Intrinsics.checkNotNull((Object)dispatcher);
        INSTANCE.registerCommands((CommandDispatcher<class_2168>)dispatcher);
    }

    private static final boolean registerCommands$lambda$1(class_2168 source) {
        return source.method_9259(3);
    }

    private static final class_2561 registerCommands$lambda$4$lambda$2(CommandContext $context, UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        class_3222 class_32222 = ((class_2168)$context.getSource()).method_9211().method_3760().method_14602(uuid);
        return class_32222 != null ? class_32222.method_5477() : null;
    }

    private static final void registerCommands$lambda$4$lambda$3(CommandContext $context, class_2561 message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ((class_2168)$context.getSource()).method_45068(message);
    }

    private static final int registerCommands$lambda$4(CommandContext context) {
        String id = StringArgumentType.getString((CommandContext)context, (String)"id");
        if (id == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)FcText.INSTANCE.translate("fc.command.error.no_id", new Object[0]));
            return 0;
        }
        SyncedConfigRegistry.INSTANCE.inspectQuarantine$fzzy_config(id, arg_0 -> PlatformUtils.registerCommands$lambda$4$lambda$2(context, arg_0), arg_0 -> PlatformUtils.registerCommands$lambda$4$lambda$3(context, arg_0));
        return 1;
    }

    private static final class_2561 registerCommands$lambda$6$lambda$5(String $id) {
        Object[] objectArray = new Object[]{$id};
        return (class_2561)FcText.INSTANCE.translate("fc.command.accepted", objectArray);
    }

    private static final int registerCommands$lambda$6(CommandContext context) {
        String id = StringArgumentType.getString((CommandContext)context, (String)"id");
        if (id == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)FcText.INSTANCE.translate("fc.command.error.no_id", new Object[0]));
            return 0;
        }
        MinecraftServer minecraftServer = ((class_2168)context.getSource()).method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        SyncedConfigRegistry.INSTANCE.acceptQuarantine$fzzy_config(id, minecraftServer);
        ((class_2168)context.getSource()).method_9226(() -> PlatformUtils.registerCommands$lambda$6$lambda$5(id), true);
        return 1;
    }

    private static final class_2561 registerCommands$lambda$8$lambda$7(String $id) {
        Object[] objectArray = new Object[]{$id};
        return (class_2561)FcText.INSTANCE.translate("fc.command.rejected", objectArray);
    }

    private static final int registerCommands$lambda$8(CommandContext context) {
        String id = StringArgumentType.getString((CommandContext)context, (String)"id");
        if (id == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)FcText.INSTANCE.translate("fc.command.error.no_id", new Object[0]));
            return 0;
        }
        MinecraftServer minecraftServer = ((class_2168)context.getSource()).method_9211();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        SyncedConfigRegistry.INSTANCE.rejectQuarantine$fzzy_config(id, minecraftServer);
        ((class_2168)context.getSource()).method_9226(() -> PlatformUtils.registerCommands$lambda$8$lambda$7(id), true);
        return 1;
    }
}

