/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.attributes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.attributes.AttributeModificationData;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.utils.AttributeUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class AccessoryAttributeBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<class_1320, Map<class_2960, AttributeModificationData>> exclusiveAttributes = new HashMap<class_1320, Map<class_2960, AttributeModificationData>>();
    private final Multimap<class_1320, AttributeModificationData> stackedAttributes = LinkedHashMultimap.create();
    private final SlotReference slotReference;
    private final Set<class_2960> previouslyWarnedLocations = new HashSet<class_2960>();

    @ApiStatus.Internal
    public AccessoryAttributeBuilder(SlotReference slotReference) {
        this.slotReference = slotReference;
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder(String slotName, int slot) {
        this.slotReference = SlotReference.of(null, slotName, slot);
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder() {
        this.slotReference = SlotReference.of(null, "", 0);
    }

    public AccessoryAttributeBuilder addExclusive(class_1320 attribute, class_2960 location, double amount, class_1322.class_1323 operation) {
        Pair<String, UUID> data = AttributeUtils.getModifierData(location);
        this.addExclusive(attribute, new class_1322((UUID)data.second(), (String)data.first(), amount, operation));
        return this;
    }

    public AccessoryAttributeBuilder addStackable(class_1320 attribute, class_2960 location, double amount, class_1322.class_1323 operation) {
        Pair<String, UUID> data = AttributeUtils.getModifierData(location);
        this.addStackable(attribute, new class_1322((UUID)data.second(), (String)data.first(), amount, operation));
        return this;
    }

    public AccessoryAttributeBuilder addExclusive(class_1320 attribute, class_1322 modifier) {
        class_2960 id = AttributeUtils.getLocation(modifier.method_6185());
        Map innerMap = this.exclusiveAttributes.computeIfAbsent(attribute, attributeHolder -> new HashMap());
        if (AccessoriesInternals.isDevelopmentEnv() && innerMap.containsKey(id) && !this.previouslyWarnedLocations.contains(id)) {
            LOGGER.warn("A given Modifier was found to have a duplicate location but was added as exclusive, was such on purpose as such will not stack with the other: {}", (Object)id);
            this.previouslyWarnedLocations.add(id);
        }
        innerMap.putIfAbsent(id, new AttributeModificationData(attribute, modifier));
        return this;
    }

    private AccessoryAttributeBuilder addStackable(class_1320 attribute, class_1322 modifier) {
        class_2960 location = AttributeUtils.getLocation(modifier.method_6185());
        this.stackedAttributes.put((Object)attribute, (Object)new AttributeModificationData(this.slotReference.createSlotPath(), attribute, modifier));
        return this;
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder addModifier(class_1320 attribute, class_1322 modifier, SlotReference slotReference, Function<String, class_2960> locationBuilder) {
        Pair<String, UUID> data = AttributeUtils.getModifierData(Accessories.of(AccessoryAttributeBuilder.createSlotPath(slotReference)));
        String validName = modifier.method_6185().toLowerCase().replace(" ", "_").replaceAll("([^a-z0-9/._-])", "");
        if (modifier.method_6189().equals(data.right())) {
            this.addStackable(attribute, locationBuilder.apply(validName), modifier.method_6186(), modifier.method_6182());
        } else {
            this.addExclusive(attribute, locationBuilder.apply(validName), modifier.method_6186(), modifier.method_6182());
        }
        return this;
    }

    @Nullable
    public AttributeModificationData getExclusive(class_1320 attribute, class_2960 location) {
        Map<class_2960, AttributeModificationData> innerMap = this.exclusiveAttributes.get(attribute);
        if (innerMap == null) {
            return null;
        }
        return innerMap.get(location);
    }

    public Collection<AttributeModificationData> getStacks(class_1320 attribute, class_2960 location) {
        return this.stackedAttributes.get((Object)attribute).stream().filter(data -> {
            class_2960 id = AttributeUtils.getLocation(data.modifier().method_6185());
            return id.equals((Object)location);
        }).toList();
    }

    @Nullable
    public AttributeModificationData removeExclusive(class_1320 attribute, class_2960 location) {
        Map<class_2960, AttributeModificationData> innerMap = this.exclusiveAttributes.get(attribute);
        if (innerMap == null) {
            return null;
        }
        return innerMap.remove(location);
    }

    public Collection<AttributeModificationData> removeStacks(class_1320 attribute, class_2960 location) {
        HashSet<AttributeModificationData> removedData = new HashSet<AttributeModificationData>();
        for (AttributeModificationData data : List.copyOf(this.stackedAttributes.get((Object)attribute))) {
            class_2960 id = AttributeUtils.getLocation(data.modifier().method_6185());
            if (!id.equals((Object)location)) continue;
            removedData.add(data);
            this.stackedAttributes.remove((Object)attribute, (Object)data);
        }
        return removedData;
    }

    public Multimap<String, class_1322> getSlotModifiers() {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        this.exclusiveAttributes.forEach((attribute, innerMap) -> innerMap.forEach((location, uniqueInstance) -> {
            class_1320 patt0$temp = uniqueInstance.attribute();
            if (!(patt0$temp instanceof SlotAttribute)) {
                return;
            }
            SlotAttribute slotAttribute = (SlotAttribute)patt0$temp;
            map.put((Object)slotAttribute.slotName(), (Object)uniqueInstance.modifier());
        }));
        this.stackedAttributes.forEach((location, stackedInstance) -> {
            class_1320 patt0$temp = stackedInstance.attribute();
            if (!(patt0$temp instanceof SlotAttribute)) {
                return;
            }
            SlotAttribute slotAttribute = (SlotAttribute)patt0$temp;
            map.put((Object)slotAttribute.slotName(), (Object)stackedInstance.modifier());
        });
        return map;
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(boolean filterSlots) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        this.exclusiveAttributes.forEach((attribute, innerMap) -> innerMap.forEach((location, uniqueInstance) -> {
            if (filterSlots && uniqueInstance.attribute() instanceof SlotAttribute) {
                return;
            }
            map.put((Object)uniqueInstance.attribute(), (Object)uniqueInstance.modifier());
        }));
        this.stackedAttributes.forEach((location, stackedInstance) -> {
            if (filterSlots && stackedInstance.attribute() instanceof SlotAttribute) {
                return;
            }
            map.put((Object)stackedInstance.attribute(), (Object)stackedInstance.modifier());
        });
        return map;
    }

    public boolean isEmpty() {
        return this.exclusiveAttributes.isEmpty() && this.stackedAttributes.isEmpty();
    }

    public Map<class_1320, Map<class_2960, AttributeModificationData>> exclusiveAttributes() {
        return ImmutableMap.copyOf(this.exclusiveAttributes);
    }

    public Multimap<class_1320, AttributeModificationData> stackedAttributes() {
        return ImmutableMultimap.copyOf(this.stackedAttributes);
    }

    public AccessoryAttributeBuilder addFrom(AccessoryAttributeBuilder builder) {
        builder.exclusiveAttributes.forEach(this.exclusiveAttributes::putIfAbsent);
        this.stackedAttributes.putAll(builder.stackedAttributes);
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessoryAttributeBuilder)) {
            return false;
        }
        AccessoryAttributeBuilder otherBuilder = (AccessoryAttributeBuilder)obj;
        if (!AccessoryAttributeBuilder.areMapsEqual(this.stackedAttributes, otherBuilder.stackedAttributes)) {
            return false;
        }
        return this.exclusiveAttributes.equals(otherBuilder.exclusiveAttributes);
    }

    private static <K, V> boolean areMapsEqual(Multimap<K, V> multimap1, Multimap<K, V> multimap2) {
        for (Map.Entry entry : multimap1.asMap().entrySet()) {
            if (!((Collection)entry.getValue()).equals(multimap2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String createSlotPath(SlotReference ref) {
        return ref.createSlotPath();
    }

    @Deprecated
    public static String createSlotPath(String slotname, int slot) {
        return slotname.replace(":", "-") + "/" + slot;
    }
}

