/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.menu;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.data.EntitySlotLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AccessoriesSlotGenerator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AccessoriesCapability capability;
    private final Consumer<class_1735> slotConsumer;
    private final List<SlotType> slotTypes;
    private int horizontalPadding = 0;
    private int verticalPadding = 0;
    private int startX;
    private int startY;

    private AccessoriesSlotGenerator(Consumer<class_1735> slotConsumer, int startX, int startY, List<SlotType> slotTypes, AccessoriesCapability capability) {
        this.slotConsumer = slotConsumer;
        this.startX = startX;
        this.startY = startY;
        this.slotTypes = slotTypes;
        this.capability = capability;
    }

    @Nullable
    public static AccessoriesSlotGenerator of(Consumer<class_1735> slotConsumer, int startX, int startY, class_1309 livingEntity, SlotTypeReference ... references) {
        class_1937 level = livingEntity.method_37908();
        SlotType[] slotTypes = (SlotType[])Arrays.stream(references).map(ref -> {
            SlotType slotType = ref.get(level);
            if (slotType == null) {
                LOGGER.error("Unable to find the SlotType based on the passed reference! [SlotName: {}]", (Object)ref.slotName());
            }
            return slotType;
        }).filter(Objects::nonNull).toArray(SlotType[]::new);
        return AccessoriesSlotGenerator.of(slotConsumer, startX, startY, livingEntity, slotTypes);
    }

    @Nullable
    public static AccessoriesSlotGenerator of(Consumer<class_1735> slotConsumer, int startX, int startY, class_1309 livingEntity, SlotType ... slotTypes) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability == null) {
            return null;
        }
        Collection<SlotType> validEntitySlotTypes = EntitySlotLoader.getEntitySlots(livingEntity).values();
        ArrayList<SlotType> validSlotTypes = new ArrayList<SlotType>();
        for (SlotType slotType : slotTypes) {
            if (!validEntitySlotTypes.contains(slotType)) {
                LOGGER.error("Unable to create Accessory Slot due to the given LivingEntity not having the given SlotType bound to it! [EntityType: {}, SlotType: {}]", (Object)livingEntity.method_5864(), (Object)slotType.name());
                continue;
            }
            validSlotTypes.add(slotType);
        }
        return new AccessoriesSlotGenerator(slotConsumer, startX, startY, validSlotTypes, capability);
    }

    public AccessoriesSlotGenerator padding(int value) {
        this.horizontalPadding(value);
        this.verticalPadding(value);
        return this;
    }

    public AccessoriesSlotGenerator horizontalPadding(int value) {
        this.horizontalPadding = value;
        return this;
    }

    public AccessoriesSlotGenerator verticalPadding(int value) {
        this.verticalPadding = value;
        return this;
    }

    public AccessoriesSlotGenerator setX(int x) {
        this.startX = x;
        return this;
    }

    public AccessoriesSlotGenerator setY(int y) {
        this.startY = y;
        return this;
    }

    public AccessoriesSlotGenerator moveX(int x) {
        this.startX += x;
        return this;
    }

    public AccessoriesSlotGenerator moveY(int y) {
        this.startY += y;
        return this;
    }

    public int row() {
        return this.layoutSlots(LayoutType.ROW);
    }

    public int column() {
        return this.layoutSlots(LayoutType.COLUMN);
    }

    private int layoutSlots(LayoutType type) {
        int xOffset = this.horizontalPadding;
        int yOffset = this.verticalPadding;
        int slotAddedAmount = 0;
        Map<String, AccessoriesContainer> allContainers = this.capability.getContainers();
        List<AccessoriesContainer> containers = this.slotTypes.stream().map(slotType -> {
            AccessoriesContainer container = allContainers.getOrDefault(slotType.name(), null);
            if (container == null) {
                LOGGER.error("Unable to locate the given container for the passed slotType. [Type: {}]", (Object)slotType.name());
            }
            return container;
        }).filter(Objects::nonNull).toList();
        for (AccessoriesContainer container : containers) {
            for (int i = 0; i < container.getSize(); ++i) {
                this.slotConsumer.accept(new AccessoriesBasedSlot(container, container.getAccessories(), i, this.startX + xOffset, this.startY + yOffset));
                if (type == LayoutType.COLUMN) {
                    yOffset += this.verticalPadding + 18;
                } else {
                    xOffset += this.horizontalPadding + 18;
                }
                ++slotAddedAmount;
            }
        }
        return slotAddedAmount;
    }

    public static enum LayoutType {
        COLUMN,
        ROW;

    }
}

