/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import com.google.common.collect.ImmutableList;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.NestedSlotReferenceImpl;
import io.wispforest.accessories.api.slot.SlotReferenceImpl;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SlotReference {
    public static SlotReference of(class_1309 livingEntity, String slotName, int slot) {
        return new SlotReferenceImpl(livingEntity, slotName, slot);
    }

    public static SlotReference ofNest(class_1309 livingEntity, String slotName, int initialHolderSlot, List<Integer> innerSlotIndices) {
        return new NestedSlotReferenceImpl(livingEntity, slotName, initialHolderSlot, (List<Integer>)ImmutableList.copyOf(innerSlotIndices));
    }

    public String slotName();

    public class_1309 entity();

    public int slot();

    default public boolean isValid() {
        AccessoriesCapability capability = this.capability();
        if (capability == null) {
            return false;
        }
        AccessoriesContainer container = capability.getContainers().get(this.slotName());
        if (container == null) {
            return false;
        }
        return this.slot() < container.getSize();
    }

    default public String createSlotPath() {
        return this.slotName().replace(":", "-") + "/" + this.slot();
    }

    @Nullable
    default public SlotType type() {
        return SlotTypeLoader.getSlotType(this.entity().method_37908(), this.slotName());
    }

    @Nullable
    default public AccessoriesCapability capability() {
        return this.entity().accessoriesCapability();
    }

    @Nullable
    default public AccessoriesContainer slotContainer() {
        AccessoriesCapability capability = this.capability();
        if (capability == null) {
            return null;
        }
        return capability.getContainers().get(this.slotName());
    }

    @Nullable
    default public class_1799 getStack() {
        AccessoriesContainer container = this.slotContainer();
        if (container == null) {
            return null;
        }
        return container.getAccessories().method_5438(this.slot());
    }

    default public boolean setStack(class_1799 stack) {
        AccessoriesContainer container = this.slotContainer();
        if (container == null) {
            return false;
        }
        container.getAccessories().method_5447(this.slot(), stack);
        return true;
    }
}

