/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ExpandedSimpleContainer
extends class_1277
implements Iterable<Pair<Integer, class_1799>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AccessoriesContainerImpl container;
    private final String name;
    private final class_2371<class_1799> previousItems;
    private final Int2BooleanMap setFlags = new Int2BooleanArrayMap();
    private boolean newlyConstructed;

    public ExpandedSimpleContainer(AccessoriesContainerImpl container, int size, String name) {
        this(container, size, name, true);
    }

    public ExpandedSimpleContainer(AccessoriesContainerImpl container, int size, String name, boolean toggleNewlyConstructed) {
        super(size);
        this.container = container;
        this.method_5489(container);
        if (toggleNewlyConstructed) {
            this.newlyConstructed = true;
        }
        this.name = name;
        this.previousItems = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public String name() {
        return this.name;
    }

    public boolean wasNewlyConstructed() {
        boolean bl = this.newlyConstructed;
        this.newlyConstructed = false;
        return bl;
    }

    public boolean isSlotFlagged(int slot) {
        boolean bl = this.setFlags.getOrDefault(slot, false);
        if (bl) {
            this.setFlags.put(slot, false);
        }
        return bl;
    }

    public void setPreviousItem(int slot, class_1799 stack) {
        if (!this.validIndex(slot)) {
            return;
        }
        this.previousItems.set(slot, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
    }

    public class_1799 getPreviousItem(int slot) {
        return slot >= 0 && slot < this.previousItems.size() ? (class_1799)this.previousItems.get(slot) : class_1799.field_8037;
    }

    public class_1799 method_5438(int slot) {
        if (!this.validIndex(slot)) {
            return class_1799.field_8037;
        }
        return super.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        if (!this.validIndex(slot)) {
            return class_1799.field_8037;
        }
        class_1799 stack = super.method_5434(slot, amount);
        if (!stack.method_7960()) {
            this.setFlags.put(slot, true);
        }
        return stack;
    }

    public class_1799 method_5441(int slot) {
        if (!this.validIndex(slot)) {
            return class_1799.field_8037;
        }
        return super.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        if (!this.validIndex(slot)) {
            return;
        }
        super.method_5447(slot, stack);
        this.setFlags.put(slot, true);
    }

    public boolean validIndex(int slot) {
        String nameInfo;
        boolean isValid = slot >= 0 && slot < this.method_5439();
        String string = nameInfo = this.name != null ? "Container: " + this.name + ", " : "";
        if (!isValid && AccessoriesInternals.isDevelopmentEnv()) {
            try {
                throw new IllegalStateException("Access to a given Inventory was found to be out of the range valid for the container! [Name: " + nameInfo + " Index: " + slot + "]");
            }
            catch (Exception e) {
                LOGGER.debug("Full Exception: ", (Throwable)e);
            }
        }
        return isValid;
    }

    public void method_7659(class_2499 containerNbt) {
        this.container.containerListenerLock = true;
        AccessoriesCapability capability = this.container.capability;
        ArrayList<class_1799> prevStacks = new ArrayList<class_1799>();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 currentStack = this.method_5438(i);
            prevStacks.add(currentStack);
            this.method_5447(i, class_1799.field_8037);
        }
        ArrayList<class_1799> invalidStacks = new ArrayList<class_1799>();
        ArrayList<class_1799> decodedStacks = new ArrayList<class_1799>();
        for (int i = 0; i < containerNbt.size(); ++i) {
            class_2487 compoundTag = containerNbt.method_10602(i);
            int j = compoundTag.method_10550("Slot");
            class_1799 stack = class_1799.method_7915((class_2487)compoundTag);
            decodedStacks.add(stack);
            if (j >= 0 && j < this.method_5439()) {
                this.method_5447(j, stack);
                continue;
            }
            invalidStacks.add(stack);
        }
        this.container.containerListenerLock = false;
        if (!capability.entity().method_37908().method_8608()) {
            if (!prevStacks.equals(decodedStacks)) {
                this.method_5431();
            }
            ((AccessoriesHolderImpl)capability.getHolder()).invalidStacks.addAll(invalidStacks);
        }
    }

    public class_2499 method_7660() {
        class_2499 listTag = new class_2499();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10569("Slot", i);
            listTag.add((Object)itemStack.method_7953(compoundTag));
        }
        return listTag;
    }

    @Override
    @NotNull
    public Iterator<Pair<Integer, class_1799>> iterator() {
        return new Iterator<Pair<Integer, class_1799>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ExpandedSimpleContainer.this.method_5439();
            }

            @Override
            public Pair<Integer, class_1799> next() {
                Pair pair = new Pair((Object)this.index, (Object)ExpandedSimpleContainer.this.method_5438(this.index));
                ++this.index;
                return pair;
            }
        };
    }

    public void setFromPrev(ExpandedSimpleContainer prevContainer) {
        prevContainer.forEach(pair -> this.setPreviousItem((Integer)pair.getFirst(), (class_1799)pair.getSecond()));
    }

    public void copyPrev(ExpandedSimpleContainer prevContainer) {
        for (int i = 0; i < prevContainer.method_5439(); ++i) {
            class_1799 prevItem;
            if (i >= this.method_5439() || (prevItem = prevContainer.getPreviousItem(i)).method_7960()) continue;
            this.setPreviousItem(i, prevItem);
        }
    }
}

