/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class InfiniteLavaStorageCell
implements StorageCell {
    private final class_1799 host;
    private final ISaveProvider saveProvider;
    private static final long INFINITE_AMOUNT = 0x1FFFFFFFFFFFFFFFL;

    public InfiniteLavaStorageCell(class_1799 host, ISaveProvider saveProvider) {
        this.host = host;
        this.saveProvider = saveProvider;
    }

    public CellState getStatus() {
        return CellState.FULL;
    }

    public double getIdleDrain() {
        return 0.0;
    }

    public boolean canFitInsideCell() {
        return true;
    }

    public void persist() {
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges();
        }
    }

    public class_2561 getDescription() {
        return class_2561.method_43470((String)"Infinite Lava Card");
    }

    private AEKey lavaKey() {
        return AEFluidKey.of((FluidVariant)FluidVariant.of((class_3611)class_3612.field_15908));
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (what.equals(this.lavaKey())) {
            return amount;
        }
        return 0L;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        AEKey lava = this.lavaKey();
        if (lava != null && lava.equals(what)) {
            if (mode == Actionable.SIMULATE) {
                return Math.min(amount, 0x1FFFFFFFFFFFFFFFL);
            }
            return Math.min(amount, 0x1FFFFFFFFFFFFFFFL);
        }
        return 0L;
    }

    public void getAvailableStacks(KeyCounter out) {
        AEKey lava = this.lavaKey();
        if (lava != null) {
            out.add(lava, 0x1FFFFFFFFFFFFFFFL);
        }
    }

    public KeyCounter getAvailableStacks() {
        KeyCounter kc = new KeyCounter();
        this.getAvailableStacks(kc);
        return kc;
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        AEKey lava = this.lavaKey();
        return lava != null && lava.equals(what);
    }
}

