/*
 * Decompiled with CFR 0.152.
 */
package galena.nirvana.world.item;

import galena.nirvana.index.NirvanaEffects;
import galena.nirvana.index.NirvanaSounds;
import galena.nirvana.platform.Services;
import galena.nirvana.world.effects.IStackingEffect;
import galena.nirvana.world.item.SmokingDispenserBehaviour;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class SmokingItem
extends class_1792 {
    public SmokingItem(class_1792.class_1793 properties) {
        super(properties);
    }

    protected void registerDispenserBehaviour() {
        SmokingDispenserBehaviour dispenserBehaviour = (source, pos, look, stack) -> {
            this.applyEffects(stack, (class_1937)source.method_10207(), class_243.method_24953((class_2382)source.method_10122()), null);
            class_243 mouth = pos.method_1019(look.method_1021(0.5));
            source.method_10207().method_14199((class_2394)class_2398.field_17430, mouth.method_10216(), mouth.method_10214(), mouth.method_10215(), 5, 0.0, 0.2 + source.method_10207().method_8409().method_43058() * 0.1, 0.0, 0.02);
        };
        class_2315.method_10009((class_1935)this, (class_2357)dispenserBehaviour);
    }

    abstract Stream<class_1293> getEffects(class_1799 var1, @Nullable class_1937 var2, @Nullable class_1309 var3);

    abstract double getRadius(class_1799 var1, @Nullable class_1937 var2, @Nullable class_1309 var3);

    private void addParticles(class_3218 level, class_1309 entity) {
        class_243 rot = entity.method_5720().method_1021(0.6);
        level.method_14199((class_2394)class_2398.field_17430, entity.method_23317() + rot.field_1352, entity.method_23320() + rot.field_1351, entity.method_23321() + rot.field_1350, 5, 0.0, 0.2 + entity.method_6051().method_43058() * 0.1, 0.0, 0.02);
    }

    private static boolean isStackingEffect(class_1291 effect) {
        class_6880 holder = class_7923.field_41174.method_47983((Object)effect);
        return holder.method_40220(NirvanaEffects.STACKING_EFFECTS);
    }

    public static void applyEffect(class_1293 instance, class_1799 source, class_1309 target, @Nullable class_1309 cause) {
        class_1293 existing = target.method_6112(instance.method_5579());
        if (existing != null && SmokingItem.isStackingEffect(instance.method_5579())) {
            IStackingEffect stacking;
            class_1291 class_12912 = instance.method_5579();
            if (class_12912 instanceof IStackingEffect && !(stacking = (IStackingEffect)class_12912).shouldIncrease(source, target, target.method_37908())) {
                return;
            }
            class_1293 increased = new class_1293(instance.method_5579(), instance.method_5584(), existing.method_5578() + 1, instance.method_5591(), instance.method_5581(), instance.method_5592(), null, instance.method_42129());
            target.method_6092(increased);
            class_1291 class_12913 = instance.method_5579();
            if (class_12913 instanceof IStackingEffect) {
                IStackingEffect stacking2 = (IStackingEffect)class_12913;
                stacking2.onIncreasedTo(increased, source, target, target.method_37908());
            }
        } else if (instance.method_5579().method_5561()) {
            instance.method_5579().method_5564((class_1297)cause, (class_1297)cause, target, instance.method_5578(), 1.0);
        } else {
            target.method_6092(instance);
        }
    }

    private void applyEffects(class_1799 source, class_1937 level, class_243 pos, @Nullable class_1309 user) {
        double range = this.getRadius(source, level, user) * 2.0;
        List targets = level.method_18467(class_1309.class, class_238.method_30048((class_243)pos, (double)range, (double)range, (double)range));
        targets.forEach(target -> this.getEffects(source, level, user).forEach(effect -> SmokingItem.applyEffect(effect, source, target, user)));
    }

    @Nullable
    protected class_3414 getUseSound() {
        return (class_3414)NirvanaSounds.SMOKING.get();
    }

    public static class_1799 takeHit(class_1657 player, class_1799 stack) {
        player.method_7357().method_7906(stack.method_7909(), 20);
        return SmokingItem.takeHit(player.method_37908(), player.method_19538(), class_3419.field_15248, player.method_31549().field_7477, stack);
    }

    static class_1799 takeHit(class_1937 level, class_243 pos, class_3419 soundSource, boolean simulate, class_1799 stack) {
        class_3414 sound;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof SmokingItem) {
            SmokingItem item = (SmokingItem)class_17922;
            v0 = item.getUseSound();
        } else {
            v0 = sound = (class_3414)NirvanaSounds.SMOKING.get();
        }
        if (sound != null) {
            level.method_43128(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), sound, soundSource, 1.0f, 1.0f);
        }
        if (simulate) {
            return stack;
        }
        class_1792 remainder = stack.method_7909().method_7858();
        if (stack.method_7963()) {
            stack.method_7974(stack.method_7919() + 1);
            if (stack.method_7919() == stack.method_7936()) {
                stack.method_7934(1);
            }
        } else {
            stack.method_7934(1);
        }
        if (stack.method_7960() && remainder != null) {
            return remainder.method_7854();
        }
        return stack;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 entity) {
        class_3222 player;
        entity.method_32876(class_5712.field_28734);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            this.applyEffects(stack, level, entity.method_19538(), entity);
            this.addParticles(serverLevel, entity);
        }
        if (entity instanceof class_3222) {
            player = (class_3222)entity;
            class_174.field_1198.method_8821(player, stack);
        }
        if (entity instanceof class_1657) {
            player = (class_1657)entity;
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return SmokingItem.takeHit((class_1657)player, stack);
        }
        return stack;
    }

    public static class_1271<class_1799> startUsing(class_1937 level, class_1657 player, class_1268 hand) {
        if (!SmokingItem.canUse((class_1309)player)) {
            return class_1271.method_22430((Object)player.method_5998(hand));
        }
        return class_5328.method_29282((class_1937)level, (class_1657)player, (class_1268)hand);
    }

    public static boolean canUse(class_1309 entity) {
        return Services.CONFIG.common().allowFakePlayerSmoking() || !Services.PLATFORM.isFakePlayer(entity);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        return SmokingItem.startUsing(level, player, hand);
    }

    public int method_7881(class_1799 stack) {
        return 32;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_27079;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }
}

