/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.ParticleRegistry;
import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.ShaderInstanceBlur;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.client.CustomParticleEngine;
import com.corosus.watut.client.screen.RenderHelper;
import com.corosus.watut.client.screen.ScreenParticleRenderer;
import com.corosus.watut.config.ConfigClient;
import com.corosus.watut.config.ConfigServerControlledSyncedToClient;
import com.corosus.watut.config.ConfigServerSyncHelper;
import com.corosus.watut.config.CustomArmCorrections;
import com.corosus.watut.math.Lerpables;
import com.corosus.watut.particle.ParticleAnimated;
import com.corosus.watut.particle.ParticleDynamic;
import com.corosus.watut.particle.ParticleItem;
import com.corosus.watut.particle.ParticleRotating;
import com.corosus.watut.particle.ParticleStatic;
import com.corosus.watut.particle.ParticleStaticLoD;
import com.corosus.watut.particle.ParticleStaticPartial;
import com.ibm.icu.impl.Pair;
import com.mojang.authlib.GameProfile;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_355;
import net.minecraft.class_3802;
import net.minecraft.class_408;
import net.minecraft.class_418;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_463;
import net.minecraft.class_466;
import net.minecraft.class_471;
import net.minecraft.class_472;
import net.minecraft.class_473;
import net.minecraft.class_476;
import net.minecraft.class_479;
import net.minecraft.class_480;
import net.minecraft.class_485;
import net.minecraft.class_486;
import net.minecraft.class_488;
import net.minecraft.class_489;
import net.minecraft.class_491;
import net.minecraft.class_492;
import net.minecraft.class_494;
import net.minecraft.class_495;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_703;
import net.minecraft.class_7743;
import org.joml.Vector3f;

public class PlayerStatusManagerClient
extends PlayerStatusManager {
    private PlayerStatus selfPlayerStatus = new PlayerStatus(PlayerStatus.PlayerGuiState.NONE);
    private PlayerStatus selfPlayerStatusPrev = new PlayerStatus(PlayerStatus.PlayerGuiState.NONE);
    public HashMap<UUID, PlayerStatus> lookupPlayerToStatusPrev = new HashMap();
    private long typingIdleTimeout = 60L;
    private int armMouseTickRate = 5;
    private int typeRatePollCounter = 0;
    private int steadyTickCounter = 0;
    private int forcedSyncRate = 40;
    private class_1937 lastLevel;
    private boolean wasMousePressed = false;
    private int mousePressedCountdown = 0;
    public static ShaderInstanceBlur positionTexBlur;
    public static ShaderInstanceBlur positionTexBlurHorizontal;
    public static ShaderInstanceBlur positionTexBlurVertical;
    public static ShaderInstanceBlur particle;
    private static CustomParticleEngine customParticleEngine;

    public static CustomParticleEngine getParticleEngine() {
        if (customParticleEngine == null) {
            customParticleEngine = new CustomParticleEngine(class_310.method_1551().field_1687, class_310.method_1551().method_1531());
            ((class_3304)class_310.method_1551().method_1478()).method_14477((class_3302)customParticleEngine);
        }
        return customParticleEngine;
    }

    public void tickGame() {
        ++this.steadyTickCounter;
        if (this.steadyTickCounter == Integer.MAX_VALUE) {
            this.steadyTickCounter = 0;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (class_310.method_1551().method_1562() != null) {
            Iterator it = this.lookupPlayerToStatus.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                class_640 playerInfo = class_310.method_1551().method_1562().method_2871((UUID)entry.getKey());
                PlayerStatus playerStatus = (PlayerStatus)entry.getValue();
                if (playerInfo == null) {
                    WatutMod.dbg("remove playerstatus for no longer existing player: " + entry.getKey());
                    playerStatus.reset();
                    it.remove();
                }
                if (level.method_18470((UUID)entry.getKey()) != null || playerStatus.getParticle() == null && playerStatus.getParticleIdle() == null) continue;
                WatutMod.dbg("remove player particles for player outside dimension: " + entry.getKey());
                playerStatus.resetParticles();
            }
        }
        if (this.lastLevel != level) {
            WatutMod.dbg("resetting player status");
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("reset player particles for " + entry.getKey() + " hash: " + entry.getValue());
                ((PlayerStatus)entry.getValue()).resetParticles();
            }
            this.selfPlayerStatus.reset();
            this.selfPlayerStatusPrev.reset();
            this.selfPlayerStatus.getScreenData().setGameTicksSinceLastScreenSend(0L);
        }
        this.lastLevel = level;
        long gameTime = 0L;
        if (class_310.method_1551().field_1687 != null) {
            gameTime = class_310.method_1551().field_1687.method_8510();
        }
        if (this.selfPlayerStatus.getTicksSinceLastAction() < 100) {
            if (this.selfPlayerStatus.getScreenData().getGameTicksSinceLastScreenSend() + (long)ConfigServerControlledSyncedToClient.dynamicGuiTickSendRateOfGUIUpdates < gameTime) {
                if (!(class_310.method_1551().field_1755 == null || this.selfPlayerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE || this.selfPlayerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHAT_SCREEN || ConfigServerControlledSyncedToClient.dynamicGuiDontSendConstantGUIUpdates && this.selfPlayerStatus.getScreenData().getLastScreen() == class_310.method_1551().field_1755)) {
                    this.selfPlayerStatus.getScreenData().setGameTicksSinceLastScreenSend(gameTime);
                    this.selfPlayerStatus.getScreenData().setNeedsNewRenderToPixelData(true);
                }
                this.selfPlayerStatus.getScreenData().setLastScreen(class_310.method_1551().field_1755);
            }
            if (class_310.method_1551().field_1755 == null) {
                this.selfPlayerStatus.getScreenData().setGameTicksSinceLastScreenSend(0L);
            }
        }
    }

    @Override
    public void tickPlayerClient(class_1657 player) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724.method_5667().equals(player.method_5667())) {
            this.tickLocalPlayerClient(player);
        }
        this.tickOtherPlayerClient(player);
        this.getStatus(player.method_5667()).tick();
        PlayerStatus status = this.getStatus(player);
        float adjRateTyping = 0.1f;
        if (status.getTypingAmplifierSmooth() < status.getTypingAmplifier() - adjRateTyping) {
            status.setTypingAmplifierSmooth(status.getTypingAmplifierSmooth() + adjRateTyping);
        } else if (status.getTypingAmplifierSmooth() > status.getTypingAmplifier() + adjRateTyping) {
            status.setTypingAmplifierSmooth(status.getTypingAmplifierSmooth() - adjRateTyping);
        }
    }

    public void tickLocalPlayerClient(class_1657 player) {
        PlayerStatus.PlayerGuiState playerGuiState;
        class_310 mc = class_310.method_1551();
        PlayerStatus statusLocal = this.getStatusLocal();
        PlayerStatus statusPrevLocal = this.getStatusPrevLocal();
        statusPrevLocal.setPlayerGuiState(statusLocal.getPlayerGuiState());
        if (ConfigClient.sendActiveGui && !statusLocal.isIdle()) {
            if (mc.field_1755 instanceof class_408) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.CHAT_SCREEN);
            } else if (mc.field_1755 instanceof class_485) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.INVENTORY);
            } else if (mc.field_1755 instanceof class_479) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.CRAFTING);
            } else if (mc.field_1755 instanceof class_433) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.ESCAPE);
            } else if (mc.field_1755 instanceof class_473) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.EDIT_BOOK);
            } else if (mc.field_1755 instanceof class_7743) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.EDIT_SIGN);
            } else if (mc.field_1755 instanceof class_476 || mc.field_1755 instanceof class_495) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.CHEST);
            } else if (mc.field_1755 instanceof class_486) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.ENCHANTING_TABLE);
            } else if (mc.field_1755 instanceof class_471) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.ANVIL);
            } else if (mc.field_1755 instanceof class_466) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.BEACON);
            } else if (mc.field_1755 instanceof class_472) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.BREWING_STAND);
            } else if (mc.field_1755 instanceof class_480) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.DISPENSER);
            } else if (mc.field_1755 instanceof class_489) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.FURNACE);
            } else if (mc.field_1755 instanceof class_3802) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.GRINDSTONE);
            } else if (mc.field_1755 instanceof class_488) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.HOPPER);
            } else if (mc.field_1755 instanceof class_491) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.HORSE);
            } else if (mc.field_1755 instanceof class_494) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.LOOM);
            } else if (mc.field_1755 instanceof class_492) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.VILLAGER);
            } else if (mc.field_1755 instanceof class_463) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.COMMAND_BLOCK);
            } else if (mc.field_1755 != null && !(mc.field_1755 instanceof class_418)) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.MISC);
            } else if (mc.field_1755 == null) {
                this.sendGuiStatus(PlayerStatus.PlayerGuiState.NONE);
            }
        } else {
            this.sendGuiStatus(PlayerStatus.PlayerGuiState.NONE);
        }
        String chatText = "";
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof class_408) {
            class_408 chatScreen = (class_408)class_4372;
            chatText = chatScreen.field_2382.method_1882();
        } else {
            class_4372 = mc.field_1755;
            if (class_4372 instanceof class_473) {
                class_473 bookEditScreen = (class_473)class_4372;
                chatText = (String)bookEditScreen.field_24269.field_24257.get();
            } else {
                class_4372 = mc.field_1755;
                if (class_4372 instanceof class_7743) {
                    class_7743 abstractSignEditScreen = (class_7743)class_4372;
                    chatText = (String)abstractSignEditScreen.field_40429.field_24257.get();
                } else {
                    class_4372 = mc.field_1755;
                    if (class_4372 instanceof class_463) {
                        class_463 abstractCommandBlockEditScreen = (class_463)class_4372;
                        chatText = abstractCommandBlockEditScreen.field_2751.method_1882();
                    }
                }
            }
        }
        if (this.checkIfTyping(chatText, player)) {
            this.sendChatStatus(PlayerStatus.PlayerChatState.CHAT_TYPING);
        } else if (this.isGuiFocusedOnTextBox(mc.field_1755)) {
            this.sendChatStatus(PlayerStatus.PlayerChatState.CHAT_FOCUSED);
        } else {
            this.sendChatStatus(PlayerStatus.PlayerChatState.NONE);
        }
        if (ConfigClient.sendMouseInfo && mc.field_1755 != null && mc.field_1687.method_8510() % (long)this.armMouseTickRate == 0L && PlayerStatus.PlayerGuiState.canPreventIdleInGui(playerGuiState = statusLocal.getPlayerGuiState())) {
            Pair<Float, Float> pos = this.getMousePos();
            if (((Float)pos.first).floatValue() != statusLocal.getScreenPosPercentX() || ((Float)pos.second).floatValue() != statusLocal.getScreenPosPercentY()) {
                this.onAction();
            }
            this.sendMouse(this.getMousePos(), statusLocal.isPressing());
        }
        if (statusPrevLocal.getTicksSinceLastAction() != statusLocal.getTicksSinceLastAction()) {
            statusPrevLocal.setTicksSinceLastAction(statusLocal.getTicksSinceLastAction());
        }
        if (ConfigClient.sendIdleState) {
            statusLocal.setTicksSinceLastAction(statusLocal.getTicksSinceLastAction() + 1);
            if (statusLocal.getTicksSinceLastAction() > statusLocal.getTicksToMarkPlayerIdleSyncedForClient() && statusLocal.isIdle() != statusPrevLocal.isIdle()) {
                WatutMod.dbg("send idle getTicksSinceLastAction: " + statusLocal.getTicksSinceLastAction() + " - " + statusPrevLocal.getTicksSinceLastAction());
                this.sendIdle(statusLocal);
            }
        } else {
            statusLocal.setTicksSinceLastAction(0);
        }
        if (!this.wasMousePressed && this.mousePressedCountdown > 0) {
            --this.mousePressedCountdown;
            if (this.mousePressedCountdown == 0) {
                this.sendMouse(this.getMousePos(), false);
            }
        }
        this.tickSyncing(player);
    }

    public boolean isGuiFocusedOnTextBox(class_437 screen) {
        return this.isGuiForceTypeFocused(screen);
    }

    public boolean isGuiForceTypeFocused(class_437 screen) {
        return screen instanceof class_408 || screen instanceof class_7743 || screen instanceof class_473 || screen instanceof class_463;
    }

    public void tickSyncing(class_1657 player) {
        if (this.steadyTickCounter % this.forcedSyncRate == 0) {
            PlayerStatus playerStatusLocal = this.getStatusLocal();
            this.sendIdle(playerStatusLocal);
            this.sendGuiStatus(playerStatusLocal.getPlayerGuiState(), true);
            this.sendTyping(playerStatusLocal);
        }
    }

    public void onMouse(boolean pressedAnything) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null && mc.field_1724 != null && mc.field_1724.method_37908() != null) {
            PlayerStatus.PlayerGuiState playerGuiState = this.getStatus((class_1657)mc.field_1724).getPlayerGuiState();
            if (ConfigClient.sendMouseInfo && PlayerStatus.PlayerGuiState.canPreventIdleInGui(playerGuiState)) {
                if (pressedAnything) {
                    this.mousePressedCountdown = 3;
                    this.wasMousePressed = true;
                } else {
                    this.wasMousePressed = false;
                }
                this.sendMouse(this.getMousePos(), this.mousePressedCountdown > 0);
            }
            if (mc.field_1755 == null || pressedAnything && PlayerStatus.PlayerGuiState.canPreventIdleInGui(playerGuiState)) {
                this.onAction();
            }
        }
    }

    public void onKey() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null && mc.field_1724 != null && mc.field_1724.method_37908() != null && (mc.field_1755 == null || this.isGuiFocusedOnTextBox(mc.field_1755))) {
            this.onAction();
        }
    }

    public void onAction() {
        if (!ConfigClient.sendIdleState) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null && mc.field_1724 != null && mc.field_1724.method_37908() != null) {
            PlayerStatus statusLocal = this.getStatusLocal();
            if (statusLocal.isIdle()) {
                statusLocal.setTicksSinceLastAction(0);
                WatutMod.dbg("send idle: 0");
                this.sendIdle(statusLocal);
            } else {
                statusLocal.setTicksSinceLastAction(0);
            }
        }
    }

    public Pair<Float, Float> getMousePos() {
        class_310 mc = class_310.method_1551();
        double guiScale = class_310.method_1551().method_22683().method_4495();
        double guiScaleMax = 4.0;
        double xPercent = mc.field_1729.method_1603() / (double)mc.method_22683().method_4480() - 0.5;
        double yPercent = mc.field_1729.method_1604() / (double)mc.method_22683().method_4507() - 0.5;
        double emphasis = guiScaleMax / guiScale;
        double edgeLimit = 0.75;
        double edgeLimitYLower = 0.2;
        xPercent *= emphasis;
        yPercent *= emphasis;
        xPercent = Math.max(Math.min(xPercent, edgeLimit), -edgeLimit);
        yPercent = Math.max(Math.min(yPercent, edgeLimit), -edgeLimit);
        return Pair.of((Object)Float.valueOf((float)xPercent), (Object)Float.valueOf((float)yPercent));
    }

    public boolean checkIfTyping(String input, class_1657 player) {
        PlayerStatus statusLocal = this.getStatusLocal();
        PlayerStatus statusPrevLocal = this.getStatusPrevLocal();
        if (statusPrevLocal.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE && statusLocal.getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE) {
            statusLocal.setLastTypeString(input);
            statusLocal.setLastTypeStringForAmp(input);
            statusLocal.setTypingAmplifier(0.0f);
            statusLocal.setLastTypeDiff(0);
            statusLocal.setLastTypeTime(0L);
        }
        ++this.typeRatePollCounter;
        if (input.length() > 0) {
            if (!input.startsWith("/")) {
                if (!input.equals(statusLocal.getLastTypeString())) {
                    statusLocal.setLastTypeString(input);
                    statusLocal.setLastTypeTime(player.method_37908().method_8510());
                }
                if (this.typeRatePollCounter >= 10) {
                    this.typeRatePollCounter = 0;
                    int lengthPrev = statusLocal.getLastTypeStringForAmp().length();
                    if (!input.equals(statusLocal.getLastTypeStringForAmp())) {
                        statusLocal.setLastTypeStringForAmp(input);
                        statusLocal.setLastTypeTimeForAmp(player.method_37908().method_8510());
                        int length = input.length();
                        int newDiff = length - lengthPrev;
                        float amp = Math.max(0.0f, Math.min(8.0f, (float)newDiff / 6.0f * 2.0f));
                        if (ConfigClient.sendTypingSpeed) {
                            statusLocal.setTypingAmplifier(amp);
                        } else {
                            statusLocal.setTypingAmplifier(1.0f);
                        }
                        this.sendTyping(statusLocal);
                    } else if (ConfigClient.sendTypingSpeed) {
                        statusLocal.setTypingAmplifier(0.0f);
                    }
                }
            }
        } else {
            statusLocal.setLastTypeString(input);
            statusLocal.setLastTypeDiff(0);
            return false;
        }
        return statusLocal.getLastTypeTime() + this.typingIdleTimeout >= player.method_37908().method_8510();
    }

    public void onGuiRender() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 instanceof class_408 && mc.method_1562() != null && ConfigClient.screenTypingVisible && ConfigServerControlledSyncedToClient.screenTypingVisible) {
            class_408 chat = (class_408)mc.field_1755;
            class_332 guigraphics = new class_332(mc, mc.method_22940().method_23000());
            int height = chat.field_22790 + 26;
            guigraphics.method_25303(mc.field_1772, WatutMod.getPlayerStatusManagerClient().getTypingPlayers(), 2 + ConfigClient.screenTypingRelativePosition_X, height - 50 + ConfigClient.screenTypingRelativePosition_Y, 0xFFFFFF);
            guigraphics.method_51452();
        }
    }

    public String getTypingPlayers() {
        class_310 mc = class_310.method_1551();
        Object str = "";
        for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
            GameProfile profile;
            class_640 info;
            if (((PlayerStatus)entry.getValue()).getPlayerGuiState() != PlayerStatus.PlayerGuiState.CHAT_SCREEN || ((PlayerStatus)entry.getValue()).getPlayerChatState() != PlayerStatus.PlayerChatState.CHAT_TYPING || (info = mc.method_1562().method_2871((UUID)entry.getKey())) == null || (profile = info.method_2966()) == null) continue;
            str = (String)str + profile.getName() + ", ";
        }
        int playersLengthStr = ((String)str).length();
        Object anim = "";
        int animRate = 6;
        for (long time = mc.field_1687.method_8510() % (long)(animRate * 4); time > (long)animRate; time -= (long)animRate) {
            anim = (String)anim + ".";
        }
        if (playersLengthStr > ConfigClient.screenTypingCharacterLimit) {
            str = ConfigClient.screenTypingMultiplePlayersText + (String)anim;
        } else if (((String)str).length() > 2) {
            str = ((String)str).substring(0, ((String)str).length() - 2) + ConfigClient.screenTypingText + (String)anim;
        }
        return str;
    }

    public boolean shouldAnimate(class_1657 player) {
        class_310 mc = class_310.method_1551();
        return player != mc.field_1724 || !mc.field_1690.method_31044().method_31034();
    }

    public void tickOtherPlayerClient(class_1657 player) {
        class_243 posParticle;
        ParticleRotating particle;
        boolean statusChatParticleChangeOrGone;
        PlayerStatus playerStatus = this.getStatus(player);
        PlayerStatus playerStatusPrev = this.getStatusPrev(player);
        long stableTime = this.steadyTickCounter;
        float sin = (float)Math.sin((float)stableTime / 30.0f % 360.0f);
        float cos = (float)Math.cos((float)stableTime / 30.0f % 360.0f);
        float idleY = (float)(2.6 + (double)(cos * 0.03f));
        boolean idleParticleChangeOrGone = playerStatus.isIdle() != playerStatusPrev.isIdle() || playerStatus.getParticleIdle() == null;
        boolean statusParticleChangeOrGone = playerStatus.getPlayerGuiState() != playerStatusPrev.getPlayerGuiState() || playerStatus.getParticle() == null;
        boolean bl = statusChatParticleChangeOrGone = playerStatus.getPlayerChatState() != playerStatusPrev.getPlayerChatState() && playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHAT_SCREEN;
        if ((idleParticleChangeOrGone || !playerStatus.isIdle()) && playerStatus.getParticleIdle() != null) {
            playerStatus.getParticleIdle().method_3085();
            playerStatus.setParticleIdle(null);
        }
        if ((statusParticleChangeOrGone || statusChatParticleChangeOrGone || playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) && playerStatus.getParticle() != null) {
            playerStatus.getParticle().method_3085();
            playerStatus.setParticle(null);
        }
        if (playerStatus.getParticle() != null && !playerStatus.getParticle().method_3086()) {
            playerStatus.getParticle().method_3085();
            playerStatus.setParticle(null);
        }
        if (playerStatus.getParticleIdle() != null && !playerStatus.getParticleIdle().method_3086()) {
            playerStatus.getParticleIdle().method_3085();
            playerStatus.setParticleIdle(null);
        }
        double quadSize = (double)0.3f + Math.sin((float)stableTime / 10.0f % 360.0f) * (double)0.01f;
        if (this.shouldAnimate(player) && !player.method_5767()) {
            if (idleParticleChangeOrGone && ConfigClient.showIdleStatesInPlayerAboveHead && ConfigServerControlledSyncedToClient.showIdleStatesInPlayerAboveHead && playerStatus.isIdle() && (particle = new ParticleStatic((class_638)player.method_37908(), player.method_19538().field_1352, player.method_19538().field_1351 + (double)idleY, player.method_19538().field_1350, ParticleRegistry.idle.getSprite())) != null) {
                playerStatus.setParticleIdle((class_703)particle);
                PlayerStatusManagerClient.getParticleEngine().add((class_703)particle);
                particle.setQuadSize((float)quadSize);
                WatutMod.dbg("spawning idle particle for " + player.method_5667());
            }
            if (statusParticleChangeOrGone || statusChatParticleChangeOrGone) {
                boolean newRender;
                particle = null;
                posParticle = this.getParticlePosition(player);
                boolean useChatIdleForTestingOtherGUIs = false;
                boolean bl2 = newRender = RenderHelper.useDynamicGUISystem() && !playerStatus.isPlayerGuiDontSendDetailedGUIInfo();
                if (ConfigClient.showPlayerActiveChatGui && ConfigServerControlledSyncedToClient.showPlayerActiveChatGui && PlayerStatus.PlayerGuiState.isTypingGui(this.getStatus(player).getPlayerGuiState())) {
                    if (this.getStatus(player).getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_FOCUSED) {
                        particle = new ParticleAnimated((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, ParticleRegistry.chat_idle.getSpriteSet());
                        if (useChatIdleForTestingOtherGUIs) {
                            particle = newRender && playerStatus.getScreenData().getParticleRenderType() != null ? new ParticleDynamic((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, playerStatus.getScreenData().getParticleRenderType(), 0.7f) : new ParticleStaticLoD((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, ParticleRegistry.inventory.getSpriteSet());
                        }
                    } else if (this.getStatus(player).getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_TYPING) {
                        particle = new ParticleAnimated((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, ParticleRegistry.chat_typing.getSpriteSet());
                    }
                }
                if (ConfigClient.showPlayerActiveNonChatGui && ConfigServerControlledSyncedToClient.showPlayerActiveNonChatGui) {
                    class_1058 sprite = null;
                    float brightness = 0.7f;
                    int subSizeX = 0;
                    int subSizeY = 0;
                    if (newRender) {
                        if (this.getStatus(player).getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE && this.getStatus(player).getPlayerGuiState() != PlayerStatus.PlayerGuiState.CHAT_SCREEN && playerStatus.getScreenData().getParticleRenderType() != null) {
                            particle = new ParticleDynamic((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, playerStatus.getScreenData().getParticleRenderType(), 0.7f);
                        }
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.INVENTORY) {
                        particle = new ParticleStaticLoD((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, ParticleRegistry.inventory.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.CRAFTING) {
                        particle = new ParticleStaticLoD((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, ParticleRegistry.crafting.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.ESCAPE) {
                        particle = new ParticleStaticLoD((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, ParticleRegistry.escape.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.CHEST) {
                        particle = new ParticleStaticLoD((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, ParticleRegistry.chest.getSpriteSet());
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.EDIT_BOOK) {
                        if (playerStatus.getScreenData().getParticleRenderType() != null) {
                            particle = new ParticleDynamic((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, playerStatus.getScreenData().getParticleRenderType(), 0.7f);
                        }
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.EDIT_SIGN) {
                        particle = new ParticleStatic((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, ParticleRegistry.sign.getSprite(), 0.7f);
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.ENCHANTING_TABLE) {
                        sprite = ParticleRegistry.enchanting_table.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.ANVIL) {
                        sprite = ParticleRegistry.anvil.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.BEACON) {
                        sprite = ParticleRegistry.beacon.getSprite();
                        subSizeX = 231;
                        subSizeY = 219;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.BREWING_STAND) {
                        sprite = ParticleRegistry.brewing_stand.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.DISPENSER) {
                        sprite = ParticleRegistry.dispenser.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.FURNACE) {
                        sprite = ParticleRegistry.furnace.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.GRINDSTONE) {
                        sprite = ParticleRegistry.grindstone.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.HOPPER) {
                        sprite = ParticleRegistry.hopper.getSprite();
                        subSizeX = 176;
                        subSizeY = 134;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.HORSE) {
                        sprite = ParticleRegistry.horse.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.LOOM) {
                        sprite = ParticleRegistry.loom.getSprite();
                        subSizeX = 176;
                        subSizeY = 166;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.VILLAGER) {
                        sprite = ParticleRegistry.villager.getSprite();
                        subSizeX = 277;
                        subSizeY = 167;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.COMMAND_BLOCK) {
                        sprite = ParticleRegistry.command_block.getSprite();
                        subSizeX = 308;
                        subSizeY = 213;
                    } else if (this.getStatus(player).getPlayerGuiState() == PlayerStatus.PlayerGuiState.MISC && ConfigClient.showPlayerActiveGuiIfNotExactMatch) {
                        particle = new ParticleStaticLoD((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, ParticleRegistry.chest.getSpriteSet());
                    }
                    if (sprite != null) {
                        particle = new ParticleStaticPartial((class_638)player.method_37908(), posParticle.field_1352, posParticle.field_1351, posParticle.field_1350, sprite, brightness, subSizeX, subSizeY);
                    }
                }
                if (particle != null) {
                    playerStatus.setParticle((class_703)particle);
                    PlayerStatusManagerClient.getParticleEngine().add((class_703)particle);
                }
            }
        }
        if (playerStatus.getParticleIdle() != null && (particle = (ParticleStatic)playerStatus.getParticleIdle()).method_3086()) {
            particle.keepAlive();
            particle.method_3063(player.method_19538().field_1352, player.method_19538().field_1351 + (double)idleY, player.method_19538().field_1350);
            particle.setPosPrev(player.method_19538().field_1352, player.method_19538().field_1351 + (double)idleY, player.method_19538().field_1350);
            particle.method_34753(0.0, 0.0, 0.0);
            ((ParticleStatic)particle).prevRotationYaw = ((ParticleStatic)particle).rotationYaw = -player.field_6283 + 180.0f;
            ((ParticleStatic)particle).prevRotationRoll = ((ParticleStatic)particle).rotationRoll = cos * 5.0f;
            particle.setQuadSize(0.15f + sin * 0.03f);
            particle.method_3083(0.5f);
        }
        if (playerStatus.getParticle() != null && playerStatus.getParticle() instanceof ParticleRotating && (particle = (ParticleRotating)playerStatus.getParticle()).method_3086()) {
            particle.keepAlive();
            posParticle = this.getParticlePosition(player);
            particle.method_3063(posParticle.field_1352, posParticle.field_1351, posParticle.field_1350);
            particle.method_34753(0.0, 0.0, 0.0);
            if (!(playerStatus.getParticle() instanceof ParticleAnimated)) {
                particle.setQuadSize((float)quadSize);
                if (class_310.method_1551().field_1719 != null) {
                    double distToCamera = class_310.method_1551().field_1719.method_5739((class_1297)player);
                    double distToCameraCapped = Math.max(3.0, Math.min(10.0, distToCamera));
                    double distToCameraCapped2 = Math.max(3.0, Math.min(6.0, distToCamera));
                    float alpha = (float)Math.max((double)0.35f, 1.0 - distToCameraCapped / 10.0) + 0.15f;
                    float brightness = (float)Math.max((double)0.55f, 1.0 - distToCameraCapped / 10.0) + 0.15f;
                    float huh = (float)Math.max(0.0, 1.0 - distToCameraCapped2 / 6.0);
                    quadSize = (double)0.3f + Math.sin((float)stableTime / 10.0f % 360.0f) * (double)0.01f * (double)huh;
                    particle.method_3083(alpha);
                    particle.setBrightness(brightness);
                    particle.setQuadSize((float)quadSize);
                    if (particle instanceof ParticleStaticLoD) {
                        ((ParticleStaticLoD)particle).setParticleFromDistanceToCamera((float)distToCamera);
                    }
                } else {
                    particle.method_3083(0.5f);
                }
            }
            particle.prevRotationYaw = particle.rotationYaw = -player.field_6283;
            particle.prevRotationPitch = particle.rotationPitch = 20.0f;
        }
        playerStatusPrev.setPlayerGuiState(playerStatus.getPlayerGuiState());
        playerStatusPrev.setPlayerChatState(playerStatus.getPlayerChatState());
        if (playerStatusPrev.getTicksSinceLastAction() != playerStatus.getTicksSinceLastAction()) {
            playerStatusPrev.setTicksSinceLastAction(playerStatus.getTicksSinceLastAction());
        }
    }

    public boolean renderPingIconHook(class_355 playerTabOverlay, class_332 pGuiGraphics, int p_281809_, int p_282801_, int pY, class_640 pPlayerInfo) {
        if (class_310.method_1551().field_1713 == null || pPlayerInfo == null || pPlayerInfo.method_2966() == null || !ConfigClient.showIdleStatesInPlayerList || !ConfigServerControlledSyncedToClient.showIdleStatesInPlayerList) {
            return false;
        }
        PlayerStatus playerStatus = this.getStatus(pPlayerInfo.method_2966().getId());
        if (playerStatus.isIdle()) {
            pGuiGraphics.method_51448().method_22903();
            pGuiGraphics.method_51448().method_46416(0.0f, 0.0f, 101.0f);
            class_1058 sprite = ParticleRegistry.idle.getSprite();
            int x = (int)((float)class_310.method_1551().field_1713.field_18301.field_43113 * sprite.method_4594());
            int y = (int)((float)class_310.method_1551().field_1713.field_18301.field_43114 * sprite.method_4593());
            pGuiGraphics.method_25290(sprite.method_45852(), p_282801_ + p_281809_ - 11, pY, (float)x, (float)y, 10, 8, class_310.method_1551().field_1713.field_18301.field_43113, class_310.method_1551().field_1713.field_18301.field_43114);
            pGuiGraphics.method_51448().method_22909();
            return true;
        }
        return false;
    }

    public void setupRotationsHook(class_583 model, class_1297 pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!ConfigClient.showPlayerAnimations || !ConfigServerControlledSyncedToClient.showPlayerAnimations) {
            return;
        }
        class_310 mc = class_310.method_1551();
        boolean inOwnInventory = pEntity == mc.field_1724 && mc.field_1755 instanceof class_485 && pEntity.method_5805();
        boolean isRealPlayer = pEntity.method_37908().method_18456().contains(pEntity);
        if (model instanceof class_591) {
            class_591 playerModel = (class_591)model;
            if (pEntity instanceof class_1657) {
                class_1657 player = (class_1657)pEntity;
                if (isRealPlayer && (!inOwnInventory && this.shouldAnimate((class_1657)pEntity) || this.singleplayerTesting)) {
                    boolean contextIsInventoryPaperDoll;
                    PlayerStatus playerStatus = this.getStatus(player);
                    boolean bl = contextIsInventoryPaperDoll = (double)playerModel.field_3398.field_3675 > Math.PI;
                    if (!contextIsInventoryPaperDoll) {
                        if (playerStatus.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) {
                            playerStatus.yRotHeadBeforeOverriding = playerModel.field_3398.field_3675;
                            playerStatus.xRotHeadBeforeOverriding = playerModel.field_3398.field_3654;
                            if (player.method_37908().method_8510() % 5L == 0L) {
                                // empty if block
                            }
                        } else if ((double)playerModel.field_3398.field_3675 <= Math.PI) {
                            playerStatus.yRotHeadWhileOverriding = playerModel.field_3398.field_3675;
                            playerStatus.xRotHeadWhileOverriding = playerModel.field_3398.field_3654;
                        }
                    }
                    if (playerStatus.isLerping() || playerStatus.getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE || playerStatus.isIdle()) {
                        float yRotDiff;
                        Vector3f adjLeftArm;
                        Vector3f adjRightArm;
                        float partialTick;
                        playerStatus.lastPartialTick = partialTick = pAgeInTicks - (float)((int)pAgeInTicks);
                        class_1306 mainArm = player.method_6068();
                        if (mainArm == class_1306.field_6183) {
                            adjRightArm = CustomArmCorrections.getAdjustmentForArm(player.method_6118(class_1304.field_6173), player.method_6118(class_1304.field_6171), class_1304.field_6173);
                            adjLeftArm = CustomArmCorrections.getAdjustmentForArm(player.method_6118(class_1304.field_6171), player.method_6118(class_1304.field_6173), class_1304.field_6171);
                        } else {
                            adjLeftArm = CustomArmCorrections.getAdjustmentForArm(player.method_6118(class_1304.field_6171), player.method_6118(class_1304.field_6173), class_1304.field_6171);
                            adjRightArm = CustomArmCorrections.getAdjustmentForArm(player.method_6118(class_1304.field_6173), player.method_6118(class_1304.field_6171), class_1304.field_6173);
                        }
                        if (adjRightArm.y != Float.MAX_VALUE) {
                            playerModel.field_3401.field_3675 += class_3532.method_16439((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.yRot, (float)playerStatus.getLerpTarget().rightArm.yRot);
                        }
                        if (adjRightArm.x != Float.MAX_VALUE) {
                            playerModel.field_3401.field_3654 += class_3532.method_16439((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.xRot, (float)playerStatus.getLerpTarget().rightArm.xRot);
                        }
                        playerModel.field_3401.field_3657 += class_3532.method_16439((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.x, (float)playerStatus.getLerpTarget().rightArm.x);
                        playerModel.field_3401.field_3656 += class_3532.method_16439((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.y, (float)playerStatus.getLerpTarget().rightArm.y);
                        playerModel.field_3401.field_3655 += class_3532.method_16439((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().rightArm.z, (float)playerStatus.getLerpTarget().rightArm.z);
                        if (adjLeftArm.y != Float.MAX_VALUE) {
                            playerModel.field_27433.field_3675 += class_3532.method_16439((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().leftArm.yRot, (float)playerStatus.getLerpTarget().leftArm.yRot);
                        }
                        if (adjLeftArm.x != Float.MAX_VALUE) {
                            playerModel.field_27433.field_3654 += class_3532.method_16439((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().leftArm.xRot, (float)playerStatus.getLerpTarget().leftArm.xRot);
                        }
                        if ((double)Math.abs(yRotDiff = playerStatus.getLerpTarget().head.yRot - playerStatus.getLerpPrev().head.yRot) < 1.5707963267948966) {
                            playerModel.field_3398.field_3675 = class_3532.method_16439((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.yRot, (float)playerStatus.getLerpTarget().head.yRot);
                            if (player.method_37908().method_8510() % 5L == 0L) {
                                // empty if block
                            }
                        }
                        playerModel.field_3398.field_3654 = class_3532.method_16439((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.xRot, (float)playerStatus.getLerpTarget().head.xRot);
                        playerModel.field_3398.field_3674 = class_3532.method_16439((float)playerStatus.getPartialLerp(partialTick), (float)playerStatus.getLerpPrev().head.zRot, (float)playerStatus.getLerpTarget().head.zRot);
                        playerModel.field_3486.field_3675 = playerModel.field_3401.field_3675;
                        playerModel.field_3486.field_3654 = playerModel.field_3401.field_3654;
                        playerModel.field_3486.field_3657 = playerModel.field_3401.field_3657;
                        playerModel.field_3486.field_3656 = playerModel.field_3401.field_3656;
                        playerModel.field_3486.field_3655 = playerModel.field_3401.field_3655;
                        playerModel.field_3484.field_3675 = playerModel.field_27433.field_3675;
                        playerModel.field_3484.field_3654 = playerModel.field_27433.field_3654;
                        playerModel.field_3394.field_3654 = playerModel.field_3398.field_3654;
                        playerModel.field_3394.field_3675 = playerModel.field_3398.field_3675;
                        if (ConfigClient.showPlayerAnimation_Typing && ConfigServerControlledSyncedToClient.showPlayerAnimation_Typing && playerStatus.getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_TYPING) {
                            float amp = playerStatus.getTypingAmplifierSmooth();
                            float typeAngle = (float)Math.toRadians(Math.sin(pAgeInTicks * 1.0f % 360.0f) * 15.0 * (double)amp);
                            float typeAngle2 = (float)Math.toRadians(-Math.sin(pAgeInTicks * 1.0f % 360.0f) * 15.0 * (double)amp);
                            if (adjRightArm.x != Float.MAX_VALUE) {
                                playerModel.field_3401.field_3654 -= typeAngle;
                            }
                            if (adjRightArm.x != Float.MAX_VALUE) {
                                playerModel.field_3486.field_3654 -= typeAngle;
                            }
                            if (adjLeftArm.x != Float.MAX_VALUE) {
                                playerModel.field_27433.field_3654 -= typeAngle2;
                            }
                            if (adjLeftArm.x != Float.MAX_VALUE) {
                                playerModel.field_3484.field_3654 -= typeAngle2;
                            }
                        }
                        if (adjRightArm.x != Float.MAX_VALUE) {
                            playerModel.field_3401.field_3654 -= adjRightArm.x;
                        }
                        if (adjRightArm.x != Float.MAX_VALUE) {
                            playerModel.field_3486.field_3654 -= adjRightArm.x;
                        }
                        if (adjLeftArm.x != Float.MAX_VALUE) {
                            playerModel.field_27433.field_3654 -= adjLeftArm.x;
                        }
                        if (adjLeftArm.x != Float.MAX_VALUE) {
                            playerModel.field_3484.field_3654 -= adjLeftArm.x;
                        }
                        if (adjRightArm.y != Float.MAX_VALUE) {
                            playerModel.field_3401.field_3675 -= adjRightArm.y;
                        }
                        if (adjRightArm.y != Float.MAX_VALUE) {
                            playerModel.field_3486.field_3675 -= adjRightArm.y;
                        }
                        if (adjLeftArm.y != Float.MAX_VALUE) {
                            playerModel.field_27433.field_3675 -= adjLeftArm.y;
                        }
                        if (adjLeftArm.y != Float.MAX_VALUE) {
                            playerModel.field_3484.field_3675 -= adjLeftArm.y;
                        }
                        if (adjRightArm.z != Float.MAX_VALUE) {
                            playerModel.field_3401.field_3674 -= adjRightArm.z;
                        }
                        if (adjRightArm.z != Float.MAX_VALUE) {
                            playerModel.field_3486.field_3674 -= adjRightArm.z;
                        }
                        if (adjLeftArm.z != Float.MAX_VALUE) {
                            playerModel.field_27433.field_3674 -= adjLeftArm.z;
                        }
                        if (adjLeftArm.z != Float.MAX_VALUE) {
                            playerModel.field_3484.field_3674 -= adjLeftArm.z;
                        }
                        if (ConfigClient.showPlayerAnimation_Idle && ConfigServerControlledSyncedToClient.showPlayerAnimation_Idle && playerStatus.isIdle()) {
                            float angle = (float)Math.toRadians(Math.sin(pAgeInTicks * 0.05f % 360.0f) * 15.0);
                            float angle2 = (float)Math.toRadians(Math.cos(pAgeInTicks * 0.05f % 360.0f) * 7.0);
                            playerModel.field_3398.field_3654 += angle2;
                            playerModel.field_3398.field_3674 += angle;
                        }
                    }
                    playerModel.field_3394.field_3654 = playerModel.field_3398.field_3654;
                    playerModel.field_3394.field_3675 = playerModel.field_3398.field_3675;
                    playerModel.field_3394.field_3674 = playerModel.field_3398.field_3674;
                }
            }
        }
    }

    public void setPoseTarget(UUID uuid, boolean becauseMousePress) {
        PlayerStatus playerStatus = this.getStatus(uuid);
        playerStatus.getLerpPrev().rightArm = playerStatus.getLerpTarget().rightArm.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().rightArm, playerStatus.lastPartialTick);
        playerStatus.getLerpPrev().leftArm = playerStatus.getLerpTarget().leftArm.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().leftArm, playerStatus.lastPartialTick);
        playerStatus.getLerpPrev().head = playerStatus.getLerpTarget().head.copyPartialLerp(playerStatus, playerStatus.getLerpPrev().head, playerStatus.lastPartialTick);
        if (Float.isNaN(playerStatus.getLerpPrev().rightArm.yRot)) {
            playerStatus.getLerpPrev().rightArm.yRot = 0.0f;
        }
        if (Float.isNaN(playerStatus.getLerpPrev().rightArm.xRot)) {
            playerStatus.getLerpPrev().rightArm.xRot = 0.0f;
        }
        boolean pointing = PlayerStatus.PlayerGuiState.isPointingGui(playerStatus.getPlayerGuiState());
        boolean typing = playerStatus.getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_TYPING;
        boolean idle = playerStatus.isIdle();
        if (!ConfigClient.showPlayerAnimation_Gui || !ConfigServerControlledSyncedToClient.showPlayerAnimation_Gui) {
            pointing = false;
        }
        if (!ConfigClient.showPlayerAnimation_Typing || !ConfigServerControlledSyncedToClient.showPlayerAnimation_Typing) {
            typing = false;
        }
        if (!ConfigClient.showPlayerAnimation_Idle || !ConfigServerControlledSyncedToClient.showPlayerAnimation_Idle) {
            idle = false;
        }
        if (becauseMousePress) {
            playerStatus.setNewLerp((float)this.armMouseTickRate * 0.5f);
        } else {
            playerStatus.setNewLerp((float)this.armMouseTickRate * 1.0f);
        }
        if (pointing || typing) {
            playerStatus.getLerpTarget().head.xRot = (float)Math.toRadians(15.0);
            playerStatus.getLerpTarget().head.yRot = 0.0f;
        }
        if (pointing) {
            double xPercent = playerStatus.getScreenPosPercentX();
            double yPercent = playerStatus.getScreenPosPercentY();
            double x = Math.toRadians(90.0) - Math.toRadians(22.5) - yPercent;
            double y = -Math.toRadians(15.0) + xPercent;
            double xHead = Math.toRadians(22.5) + yPercent;
            double yHead = xPercent;
            playerStatus.getLerpTarget().rightArm.yRot = (float)y;
            playerStatus.getLerpTarget().rightArm.xRot = (float)(-x);
            playerStatus.getLerpTarget().head.yRot = (float)yHead * 0.5f;
            playerStatus.getLerpTarget().head.xRot = (float)xHead * 0.5f;
            if (playerStatus.isPressing()) {
                class_243 vec = this.calculateViewVector((float)Math.toDegrees(y), (float)Math.toDegrees(x));
                float press = 1.0f;
                playerStatus.getLerpTarget().rightArm.x = (float)((double)press * vec.field_1351);
                playerStatus.getLerpTarget().rightArm.y = (float)((double)press * vec.field_1350);
                playerStatus.getLerpTarget().rightArm.z = (float)((double)press * vec.field_1352);
            } else {
                playerStatus.getLerpTarget().rightArm.x = 0.0f;
                playerStatus.getLerpTarget().rightArm.z = 0.0f;
                playerStatus.getLerpTarget().rightArm.y = 0.0f;
            }
            playerStatus.getLerpTarget().leftArm.xRot = (float)(-Math.toRadians(70.0));
            playerStatus.getLerpTarget().leftArm.yRot = (float)Math.toRadians(25.0);
        } else if (typing) {
            double x = Math.toRadians(90.0) - Math.toRadians(22.5);
            playerStatus.getLerpTarget().rightArm.xRot = (float)(-x);
            playerStatus.getLerpTarget().leftArm.xRot = (float)(-x);
            double tiltIn = Math.toRadians(20.0);
            playerStatus.getLerpTarget().rightArm.yRot = (float)(-tiltIn);
            playerStatus.getLerpTarget().leftArm.yRot = (float)tiltIn;
        }
        if (!(pointing || typing || idle)) {
            playerStatus.setLerpTarget(new Lerpables());
            playerStatus.getLerpTarget().head.xRot = playerStatus.xRotHeadBeforeOverriding;
            playerStatus.getLerpTarget().head.yRot = playerStatus.yRotHeadBeforeOverriding;
        }
        if (idle) {
            playerStatus.getLerpTarget().head.xRot = (float)Math.toRadians(70.0);
            playerStatus.setNewLerp(40.0f);
        }
        if (this.getStatusPrev(uuid).getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE && this.getStatus(uuid).getPlayerGuiState() != PlayerStatus.PlayerGuiState.NONE) {
            playerStatus.getLerpPrev().head.xRot = playerStatus.xRotHeadBeforeOverriding;
            playerStatus.getLerpPrev().head.yRot = playerStatus.yRotHeadBeforeOverriding;
        }
    }

    public class_243 getParticlePosition(class_1657 player) {
        class_243 pos = player.method_19538();
        float distFromFace = 0.85f;
        class_243 lookVec = this.getBodyAngle(player).method_1021((double)distFromFace);
        return new class_243(pos.field_1352 + lookVec.field_1352, pos.field_1351 + 1.2, pos.field_1350 + lookVec.field_1350);
    }

    @Override
    public PlayerStatus getStatusLocal() {
        return this.selfPlayerStatus;
    }

    public PlayerStatus getStatusPrevLocal() {
        return this.selfPlayerStatusPrev;
    }

    public PlayerStatus getStatusPrev(class_1657 player) {
        return this.getStatusPrev(player.method_5667());
    }

    public PlayerStatus getStatusPrev(UUID uuid) {
        return this.getStatusPrev(uuid, false);
    }

    public PlayerStatus getStatusPrev(UUID uuid, boolean local) {
        if (local) {
            return this.getStatusPrevLocal();
        }
        this.checkPrev(uuid);
        return this.lookupPlayerToStatusPrev.get(uuid);
    }

    public void checkPrev(UUID uuid) {
        if (!this.lookupPlayerToStatusPrev.containsKey(uuid)) {
            this.lookupPlayerToStatusPrev.put(uuid, new PlayerStatus(PlayerStatus.PlayerGuiState.NONE));
        }
    }

    public void sendGuiStatus(PlayerStatus.PlayerGuiState playerStatus) {
        this.sendGuiStatus(playerStatus, false);
    }

    public void sendGuiStatus(PlayerStatus.PlayerGuiState playerStatus, boolean force) {
        if (this.getStatusLocal().getPlayerGuiState() != playerStatus || force) {
            class_2487 data = new class_2487();
            data.method_10569(WatutNetworking.NBTDataPlayerGuiStatus, playerStatus.ordinal());
            data.method_10556(WatutNetworking.NBTDataPlayerGuiDontSendDetailedGUIInfo, ConfigClient.dontSendDetailedGUIInfo);
            data.method_10556(WatutNetworking.NBTDataPlayerGuiDontSendItemInfo, ConfigClient.dontSendItemInfo);
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setPlayerGuiState(playerStatus);
    }

    public void sendChatStatus(PlayerStatus.PlayerChatState playerStatus) {
        this.sendChatStatus(playerStatus, false);
    }

    public void sendChatStatus(PlayerStatus.PlayerChatState playerStatus, boolean force) {
        if (this.getStatusLocal().getPlayerChatState() != playerStatus || force) {
            class_2487 data = new class_2487();
            data.method_10569(WatutNetworking.NBTDataPlayerChatStatus, playerStatus.ordinal());
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setPlayerChatState(playerStatus);
    }

    public void sendMouse(Pair<Float, Float> pos, boolean pressed) {
        class_310 mc = class_310.method_1551();
        float x = ((Float)pos.first).floatValue();
        float y = ((Float)pos.second).floatValue();
        if (mc.field_1687.method_8604(mc.field_1724.method_23317(), mc.field_1724.method_23318(), mc.field_1724.method_23321(), (double)ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, entity -> entity != mc.field_1724) != null && (this.getStatusLocal().getScreenPosPercentX() != x || this.getStatusLocal().getScreenPosPercentY() != y || this.getStatusLocal().isPressing() != pressed)) {
            class_2487 data = new class_2487();
            data.method_10548(WatutNetworking.NBTDataPlayerMouseX, x);
            data.method_10548(WatutNetworking.NBTDataPlayerMouseY, y);
            data.method_10556(WatutNetworking.NBTDataPlayerMousePressed, pressed);
            WatutNetworking.instance().clientSendToServer(data);
        }
        this.getStatusLocal().setScreenPosPercentX(x);
        this.getStatusLocal().setScreenPosPercentY(y);
        this.getStatusLocal().setPressing(pressed);
    }

    public void sendScreenRenderData(PlayerStatus status) {
        class_2487 data = new class_2487();
        int packetSizeLimit = 31000;
        int sizeByteCount = status.getScreenData().getTexturePixelData().remaining();
        int sizeByteCountLimit = status.getScreenData().getTexturePixelData().limit();
        if (status.getScreenData().getTexturePixelData() != null) {
            data.method_10569(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataSize, status.getScreenData().getTexturePixelData().capacity());
            data.method_10569(WatutNetworking.NBTDataPlayerScreenWidth, ScreenParticleRenderer.getInstance().widthScaledDown);
            data.method_10569(WatutNetworking.NBTDataPlayerScreenHeight, ScreenParticleRenderer.getInstance().heightScaledDown);
            byte[] inputBytes = new byte[sizeByteCount];
            status.getScreenData().getTexturePixelData().get(inputBytes);
            if (sizeByteCountLimit < packetSizeLimit) {
                data.method_10570(WatutNetworking.NBTDataPlayerScreenCompressedPixelData, inputBytes);
                data.method_10569(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketCount, 1);
                data.method_10569(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketIndex, 1);
                WatutNetworking.instance().clientSendToServer(data);
            } else {
                int packetCount = class_3532.method_15386((float)((float)sizeByteCount / (float)packetSizeLimit));
                int packetBytesIndex = 0;
                for (int i = 0; i < packetCount; ++i) {
                    byte[] inputBytesPartial = packetBytesIndex + packetSizeLimit < sizeByteCount ? Arrays.copyOfRange(inputBytes, packetBytesIndex, packetBytesIndex + packetSizeLimit) : Arrays.copyOfRange(inputBytes, packetBytesIndex, sizeByteCount);
                    packetBytesIndex += inputBytesPartial.length;
                    data.method_10570(WatutNetworking.NBTDataPlayerScreenCompressedPixelData, inputBytesPartial);
                    data.method_10569(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketCount, packetCount);
                    data.method_10569(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketIndex, i);
                    WatutNetworking.instance().clientSendToServer(data);
                }
            }
        }
    }

    public void sendTyping(PlayerStatus status) {
        class_2487 data = new class_2487();
        data.method_10548(WatutNetworking.NBTDataPlayerTypingAmp, status.getTypingAmplifier());
        WatutNetworking.instance().clientSendToServer(data);
    }

    public void sendIdle(PlayerStatus status) {
        class_2487 data = new class_2487();
        data.method_10569(WatutNetworking.NBTDataPlayerIdleTicks, status.getTicksSinceLastAction());
        WatutNetworking.instance().clientSendToServer(data);
    }

    public void receiveAny(UUID uuid, class_2487 data) {
        block28: {
            PlayerStatus status = this.getStatus(uuid);
            PlayerStatus statusPrev = this.getStatusPrev(uuid);
            if (data.method_10545(WatutNetworking.NBTDataPlayerTypingAmp)) {
                status.setTypingAmplifier(data.method_10583(WatutNetworking.NBTDataPlayerTypingAmp));
            }
            if (data.method_10545(WatutNetworking.NBTDataPlayerMouseX)) {
                class_1657 player;
                float x = data.method_10583(WatutNetworking.NBTDataPlayerMouseX);
                float y = data.method_10583(WatutNetworking.NBTDataPlayerMouseY);
                boolean pressed = data.method_10577(WatutNetworking.NBTDataPlayerMousePressed);
                boolean differentPress = status.isPressing() != pressed;
                this.setMouse(uuid, x, y, pressed);
                this.setPoseTarget(uuid, differentPress);
                if (pressed && differentPress && (player = class_310.method_1551().field_1687.method_18470(uuid)) != null && ConfigClient.playMouseClickSounds && ConfigServerControlledSyncedToClient.playMouseClickSounds && player != class_310.method_1551().field_1724) {
                    WatutMod.dbg("play sound for " + uuid + " name " + player.method_5476().getString());
                    player.method_37908().method_45446(player.method_23312(), class_3417.field_15219, class_3419.field_15248, 0.05f, 0.1f, false);
                }
            }
            if (data.method_10545(WatutNetworking.NBTDataPlayerGuiStatus)) {
                PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.method_10550(WatutNetworking.NBTDataPlayerGuiStatus));
                status.setPlayerGuiState(playerGuiState);
                if (data.method_10545(WatutNetworking.NBTDataPlayerGuiDontSendDetailedGUIInfo)) {
                    status.setPlayerGuiDontSendDetailedGUIInfo(data.method_10577(WatutNetworking.NBTDataPlayerGuiDontSendDetailedGUIInfo));
                }
                if (data.method_10545(WatutNetworking.NBTDataPlayerGuiDontSendItemInfo)) {
                    status.setPlayerGuiDontSendItemInfo(data.method_10577(WatutNetworking.NBTDataPlayerGuiDontSendItemInfo));
                }
                if (status.getPlayerGuiState() != statusPrev.getPlayerGuiState()) {
                    WatutMod.dbg("New gui player state and new pose target set relating to: " + status.getPlayerGuiState() + " for " + uuid);
                    if (statusPrev.getPlayerGuiState() == PlayerStatus.PlayerGuiState.NONE) {
                        status.setLerpTarget(new Lerpables());
                    }
                    this.setPoseTarget(uuid, false);
                    class_1657 player = class_310.method_1551().field_1687.method_18470(uuid);
                    if (player != null && ConfigClient.playScreenOpenSounds && ConfigServerControlledSyncedToClient.playScreenOpenSounds && player != class_310.method_1551().field_1724) {
                        PlayerStatus.PlayerGuiState playerGuiStatePrev = statusPrev.getPlayerGuiState();
                        if (PlayerStatus.PlayerGuiState.isSoundMakerGui(playerGuiState) || PlayerStatus.PlayerGuiState.isSoundMakerGui(playerGuiStatePrev) || playerGuiState == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiState == PlayerStatus.PlayerGuiState.CRAFTING || playerGuiState == PlayerStatus.PlayerGuiState.MISC || playerGuiStatePrev == PlayerStatus.PlayerGuiState.INVENTORY || playerGuiStatePrev == PlayerStatus.PlayerGuiState.CRAFTING || playerGuiStatePrev == PlayerStatus.PlayerGuiState.MISC) {
                            player.method_37908().method_45446(player.method_23312(), class_3417.field_15191, class_3419.field_15248, 0.9f, 1.0f, false);
                        }
                    }
                }
            }
            if (data.method_10545(WatutNetworking.NBTDataPlayerChatStatus)) {
                PlayerStatus.PlayerChatState state = PlayerStatus.PlayerChatState.get(data.method_10550(WatutNetworking.NBTDataPlayerChatStatus));
                status.setPlayerChatState(state);
                if (status.getPlayerChatState() != statusPrev.getPlayerChatState()) {
                    WatutMod.dbg("New chat player state and new pose target set relating to: " + status.getPlayerChatState() + " for " + uuid);
                    if (statusPrev.getPlayerChatState() == PlayerStatus.PlayerChatState.NONE) {
                        status.setLerpTarget(new Lerpables());
                    }
                    if (status.getPlayerChatState() == PlayerStatus.PlayerChatState.CHAT_FOCUSED) {
                        status.setTypingAmplifier(1.0f);
                        status.setTypingAmplifierSmooth(1.0f);
                    }
                    this.setPoseTarget(uuid, false);
                }
            }
            if (data.method_10545(WatutNetworking.NBTDataPlayerIdleTicks)) {
                status.setTicksSinceLastAction(data.method_10550(WatutNetworking.NBTDataPlayerIdleTicks));
                status.setTicksToMarkPlayerIdleSyncedForClient(data.method_10550(WatutNetworking.NBTDataPlayerTicksToGoIdle));
                statusPrev.setTicksToMarkPlayerIdleSyncedForClient(data.method_10550(WatutNetworking.NBTDataPlayerTicksToGoIdle));
                this.getStatusLocal().setTicksToMarkPlayerIdleSyncedForClient(data.method_10550(WatutNetworking.NBTDataPlayerTicksToGoIdle));
                this.getStatusPrevLocal().setTicksToMarkPlayerIdleSyncedForClient(data.method_10550(WatutNetworking.NBTDataPlayerTicksToGoIdle));
                if (statusPrev.isIdle() != status.isIdle()) {
                    WatutMod.dbg("New idle player state and new pose target set relating to idle state: " + status.isIdle() + " for " + uuid);
                    this.setPoseTarget(uuid, false);
                }
            }
            if (data.method_10545(WatutNetworking.NBTDataPlayerScreenCompressedPixelData)) {
                byte[] pixelData = data.method_10547(WatutNetworking.NBTDataPlayerScreenCompressedPixelData);
                int decompressedSize = data.method_10550(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataSize);
                int packetCount = data.method_10550(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketCount);
                int packetIndex = data.method_10550(WatutNetworking.NBTDataPlayerScreenCompressedPixelDataPacketIndex);
                status.getScreenData().setWidth(data.method_10550(WatutNetworking.NBTDataPlayerScreenWidth));
                status.getScreenData().setHeight(data.method_10550(WatutNetworking.NBTDataPlayerScreenHeight));
                long gameTime = class_310.method_1551().field_1687 != null ? class_310.method_1551().field_1687.method_8510() : 0L;
                int timeout = 10;
                if (packetCount > 1) {
                    if (packetIndex == 0) {
                        status.getScreenData().setGameTicksSinceFirstPacket(gameTime);
                        status.getScreenData().setTexturePixelDataPartial(pixelData);
                    } else if (gameTime <= status.getScreenData().getGameTicksSinceFirstPacket() + (long)timeout && pixelData.length > 0) {
                        byte[] dataBytes = status.getScreenData().getTexturePixelDataPartial();
                        byte[] combined = new byte[dataBytes.length + pixelData.length];
                        System.arraycopy(dataBytes, 0, combined, 0, dataBytes.length);
                        System.arraycopy(pixelData, 0, combined, dataBytes.length, pixelData.length);
                        status.getScreenData().setTexturePixelDataPartial(combined);
                        if (packetIndex == packetCount - 1) {
                            try {
                                if (status.getScreenData().getTexturePixelDataPartial() != null) {
                                    status.getScreenData().setTexturePixelData(RenderHelper.decompress(status.getScreenData(), ByteBuffer.wrap(status.getScreenData().getTexturePixelDataPartial()), decompressedSize));
                                    status.getScreenData().markNeedsNewRenderFromPixelData(true);
                                    status.getScreenData().getIsBufferReady().set(true);
                                    break block28;
                                }
                                CULog.dbg((String)"getTexturePixelDataPartial() null!");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else {
                    try {
                        status.getScreenData().setTexturePixelData(RenderHelper.decompress(status.getScreenData(), ByteBuffer.wrap(pixelData), decompressedSize));
                        status.getScreenData().markNeedsNewRenderFromPixelData(true);
                        status.getScreenData().getIsBufferReady().set(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void receiveItemMove(class_2487 data) {
        if (data.method_10545(WatutNetworking.NBTDataItemTransferItemStack)) {
            class_1799 itemStack = class_1799.method_7915((class_2487)data.method_10562(WatutNetworking.NBTDataItemTransferItemStack));
            ParticleItem particleItem = new ParticleItem(class_310.method_1551().field_1687, 1.0f, itemStack, class_310.method_1551().method_22940(), class_310.method_1551().method_1561(), data.method_10583(WatutNetworking.NBTDataItemTransferFromX), data.method_10583(WatutNetworking.NBTDataItemTransferFromY), data.method_10583(WatutNetworking.NBTDataItemTransferFromZ), data.method_10583(WatutNetworking.NBTDataItemTransferToX), data.method_10583(WatutNetworking.NBTDataItemTransferToY), data.method_10583(WatutNetworking.NBTDataItemTransferToZ));
            PlayerStatusManagerClient.getParticleEngine().add((class_703)particleItem);
        }
    }

    public void receiveServerConfig(class_2487 nbt) {
        CULog.dbg((String)"receiving server config sync");
        ConfigServerSyncHelper.getInstance().updateSyncableConfigOnClient(nbt);
        ScreenParticleRenderer.getInstance().resizeScaledDown(ScreenParticleRenderer.getInstance().width, ScreenParticleRenderer.getInstance().height);
    }
}

