/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.client;

import com.corosus.watut.particle.ParticleRotating;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_2394;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4089;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5819;
import net.minecraft.class_5878;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_733;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_7654;
import net.minecraft.class_7766;
import org.slf4j.Logger;

public class CustomParticleEngine
implements class_3302 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_7654 PARTICLE_LISTER = class_7654.method_45114((String)"particles");
    private static final class_2960 PARTICLES_ATLAS_INFO = new class_2960("particles");
    private static final int MAX_PARTICLES_PER_LAYER = 16384;
    private static final List<class_3999> RENDER_ORDER = ImmutableList.of((Object)class_3999.field_17827, (Object)class_3999.field_17828, (Object)class_3999.field_17830, (Object)class_3999.field_17829, (Object)class_3999.field_17831);
    protected class_638 level;
    private final Map<class_3999, Queue<class_703>> particles = Maps.newTreeMap(CustomParticleEngine.makeParticleRenderTypeComparator(RENDER_ORDER));
    private final Queue<class_733> trackingEmitters = Queues.newArrayDeque();
    private final class_1060 textureManager;
    private final class_5819 random = class_5819.method_43047();
    private final Map<class_2960, class_707<?>> providers = new HashMap();
    private final Queue<class_703> particlesToAdd = Queues.newArrayDeque();
    private final Map<class_2960, MutableSpriteSet> spriteSets = Maps.newHashMap();
    public final class_1059 textureAtlas;
    private final Object2IntOpenHashMap<class_5878> trackedParticleCounts = new Object2IntOpenHashMap();

    public CustomParticleEngine(class_638 p_107299_, class_1060 p_107300_) {
        this.textureAtlas = new class_1059(class_1059.field_17898);
        this.level = p_107299_;
        this.textureManager = p_107300_;
    }

    public static Comparator<class_3999> makeParticleRenderTypeComparator(List<class_3999> renderOrder) {
        Comparator<class_3999> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((class_3999)typeOne, (class_3999)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            return vanillaOne ? -1 : 1;
        };
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 p_107305_, class_3300 p_107306_, class_3695 p_107307_, class_3695 p_107308_, Executor p_107309_, Executor p_107310_) {
        CompletionStage completablefuture = CompletableFuture.supplyAsync(() -> PARTICLE_LISTER.method_45113(p_107306_), p_107309_).thenCompose(p_247914_ -> {
            ArrayList list = new ArrayList(p_247914_.size());
            p_247914_.forEach((p_247903_, p_247904_) -> {
                class_2960 resourcelocation = PARTICLE_LISTER.method_45115(p_247903_);
                list.add(CompletableFuture.supplyAsync(() -> {
                    record ParticleDefinition(class_2960 id, Optional<List<class_2960>> sprites) {
                    }
                    return new ParticleDefinition(resourcelocation, this.loadParticleDescription(resourcelocation, (class_3298)p_247904_));
                }, p_107309_));
            });
            return class_156.method_33791(list);
        });
        CompletionStage completablefuture1 = class_7766.method_45837((class_1059)this.textureAtlas).method_47661(p_107306_, PARTICLES_ATLAS_INFO, 0, p_107309_).thenCompose(class_7766.class_7767::method_45845);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{completablefuture1, completablefuture}).thenCompose(arg_0 -> ((class_3302.class_4045)p_107305_).method_18352(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$6(p_107308_, (CompletableFuture)completablefuture1, (CompletableFuture)completablefuture, arg_0), p_107310_);
    }

    public void close() {
        this.textureAtlas.method_4601();
    }

    private Optional<List<class_2960>> loadParticleDescription(class_2960 p_250648_, class_3298 p_248793_) {
        Optional<List<class_2960>> optional;
        block9: {
            if (!this.spriteSets.containsKey(p_250648_)) {
                LOGGER.debug("Redundant texture list for particle: {}", (Object)p_250648_);
                return Optional.empty();
            }
            BufferedReader reader = p_248793_.method_43039();
            try {
                class_4089 particledescription = class_4089.method_18828((JsonObject)class_3518.method_15255((Reader)reader));
                optional = Optional.of(particledescription.method_18826());
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioexception) {
                    throw new IllegalStateException("Failed to load description for particle " + p_250648_, ioexception);
                }
            }
            ((Reader)reader).close();
        }
        return optional;
    }

    public void add(class_703 p_107345_) {
        Optional optional = p_107345_.method_34019();
        if (optional.isPresent()) {
            if (this.hasSpaceInParticleLimit((class_5878)optional.get())) {
                this.particlesToAdd.add(p_107345_);
                this.updateCount((class_5878)optional.get(), 1);
            }
        } else {
            this.particlesToAdd.add(p_107345_);
        }
    }

    public void tick() {
        this.particles.forEach((p_288249_, p_288250_) -> {
            this.level.method_16107().method_15396(p_288249_.toString());
            this.tickParticleList((Collection<class_703>)p_288250_);
            this.level.method_16107().method_15407();
        });
        if (!this.trackingEmitters.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (class_733 trackingemitter : this.trackingEmitters) {
                trackingemitter.method_3070();
                if (trackingemitter.method_3086()) continue;
                list.add(trackingemitter);
            }
            this.trackingEmitters.removeAll(list);
        }
        if (!this.particlesToAdd.isEmpty()) {
            class_703 particle;
            while ((particle = this.particlesToAdd.poll()) != null) {
                this.particles.computeIfAbsent(particle.method_18122(), p_107347_ -> EvictingQueue.create((int)16384)).add(particle);
            }
        }
    }

    private void tickParticleList(Collection<class_703> p_107385_) {
        if (!p_107385_.isEmpty()) {
            Iterator<class_703> iterator = p_107385_.iterator();
            while (iterator.hasNext()) {
                class_703 particle = iterator.next();
                this.tickParticle(particle);
                if (particle.method_3086()) continue;
                particle.method_34019().ifPresent(p_172289_ -> this.updateCount((class_5878)p_172289_, -1));
                iterator.remove();
            }
        }
    }

    private void updateCount(class_5878 p_172282_, int p_172283_) {
        this.trackedParticleCounts.addTo((Object)p_172282_, p_172283_);
    }

    private void tickParticle(class_703 p_107394_) {
        try {
            p_107394_.method_3070();
        }
        catch (Throwable throwable) {
            class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Ticking Particle");
            class_129 crashreportcategory = crashreport.method_562("Particle being ticked");
            crashreportcategory.method_577("Particle", () -> ((class_703)p_107394_).toString());
            crashreportcategory.method_577("Particle Type", p_107394_.method_18122()::toString);
            throw new class_148(crashreport);
        }
    }

    @Deprecated
    public void render(class_4587 p_107337_, class_4597.class_4598 p_107338_, class_765 p_107339_, class_4184 p_107340_, float p_107341_) {
        this.render(p_107337_, p_107338_, p_107339_, p_107340_, p_107341_, null);
    }

    public void render(class_4587 p_107337_, class_4597.class_4598 p_107338_, class_765 p_107339_, class_4184 p_107340_, float p_107341_, class_4604 clippingHelper) {
        p_107339_.method_3316();
        RenderSystem.enableDepthTest();
        RenderSystem.activeTexture((int)33986);
        RenderSystem.activeTexture((int)33984);
        class_4587 posestack = RenderSystem.getModelViewStack();
        posestack.method_22903();
        posestack.method_34425(p_107337_.method_23760().method_23761());
        RenderSystem.applyModelViewMatrix();
        this.render(p_107337_, p_107338_, p_107339_, p_107340_, p_107341_, clippingHelper, false);
        this.render(p_107337_, p_107338_, p_107339_, p_107340_, p_107341_, clippingHelper, true);
        posestack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        p_107339_.method_3315();
    }

    public void render(class_4587 p_107337_, class_4597.class_4598 p_107338_, class_765 p_107339_, class_4184 p_107340_, float p_107341_, class_4604 clippingHelper, boolean pickupParticleMode) {
        for (class_3999 particlerendertype : this.particles.keySet()) {
            Iterable iterable;
            if (!pickupParticleMode ? particlerendertype == ParticleRotating.TERRAIN_SHEET_TRANSLUCENT_NO_FACE_CULL : particlerendertype != ParticleRotating.TERRAIN_SHEET_TRANSLUCENT_NO_FACE_CULL) continue;
            if (particlerendertype == class_3999.field_17832 || (iterable = (Iterable)this.particles.get(particlerendertype)) == null) continue;
            RenderSystem.setShader(class_757::method_34546);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferbuilder = tesselator.method_1349();
            particlerendertype.method_18130(bufferbuilder, this.textureManager);
            for (class_703 particle : iterable) {
                try {
                    particle.method_3074((class_4588)bufferbuilder, p_107340_, p_107341_);
                }
                catch (Throwable throwable) {
                    class_128 crashreport = class_128.method_560((Throwable)throwable, (String)"Rendering Particle");
                    class_129 crashreportcategory = crashreport.method_562("Particle being rendered");
                    crashreportcategory.method_577("Particle", () -> ((class_703)particle).toString());
                    crashreportcategory.method_577("Particle Type", particlerendertype::toString);
                    throw new class_148(crashreport);
                }
            }
            particlerendertype.method_18131(tesselator);
        }
    }

    public void setLevel(class_638 p_107343_) {
        this.level = p_107343_;
        this.clearParticles();
        this.trackingEmitters.clear();
    }

    public String countParticles() {
        return String.valueOf(this.particles.values().stream().mapToInt(Collection::size).sum());
    }

    private boolean hasSpaceInParticleLimit(class_5878 p_172280_) {
        return this.trackedParticleCounts.getInt((Object)p_172280_) < p_172280_.method_34045();
    }

    private void clearParticles() {
        this.particles.clear();
        this.particlesToAdd.clear();
        this.trackingEmitters.clear();
        this.trackedParticleCounts.clear();
    }

    private /* synthetic */ void lambda$reload$6(class_3695 p_107308_, CompletableFuture completablefuture1, CompletableFuture completablefuture, Void p_247900_) {
        this.clearParticles();
        p_107308_.method_16065();
        p_107308_.method_15396("upload");
        class_7766.class_7767 spriteloader$preparations = (class_7766.class_7767)completablefuture1.join();
        this.textureAtlas.method_45848(spriteloader$preparations);
        p_107308_.method_15405("bindSpriteSets");
        HashSet set = new HashSet();
        class_1058 textureatlassprite = spriteloader$preparations.comp_1043();
        ((List)completablefuture.join()).forEach(p_247911_ -> {
            Optional<List<class_2960>> optional = p_247911_.sprites();
            if (!optional.isEmpty()) {
                ArrayList<class_1058> list = new ArrayList<class_1058>();
                for (class_2960 resourcelocation : optional.get()) {
                    class_1058 textureatlassprite1 = (class_1058)spriteloader$preparations.comp_1044().get(resourcelocation);
                    if (textureatlassprite1 == null) {
                        set.add(resourcelocation);
                        list.add(textureatlassprite);
                        continue;
                    }
                    list.add(textureatlassprite1);
                }
                if (list.isEmpty()) {
                    list.add(textureatlassprite);
                }
                this.spriteSets.get(p_247911_.id()).rebind(list);
            }
        });
        if (!set.isEmpty()) {
            LOGGER.warn("Missing particle sprites: {}", (Object)set.stream().sorted().map(class_2960::toString).collect(Collectors.joining(",")));
        }
        p_107308_.method_15407();
        p_107308_.method_16066();
    }

    static class MutableSpriteSet
    implements class_4002 {
        private List<class_1058> sprites;

        MutableSpriteSet() {
        }

        public class_1058 method_18138(int p_107413_, int p_107414_) {
            return this.sprites.get(p_107413_ * (this.sprites.size() - 1) / p_107414_);
        }

        public class_1058 method_18139(class_5819 p_233889_) {
            return this.sprites.get(p_233889_.method_43048(this.sprites.size()));
        }

        public void rebind(List<class_1058> p_107416_) {
            this.sprites = ImmutableList.copyOf(p_107416_);
        }
    }

    @FunctionalInterface
    public static interface SpriteParticleRegistration<T extends class_2394> {
        public class_707<T> create(class_4002 var1);
    }
}

