/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat;

import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;

public class CopycatTransformableState<T> {
    public List<Part<T>> parts = new LinkedList<Part<T>>();

    public static <T> CopycatTransformableState<T> create(Consumer<CopycatTransformableState<T>> consumer) {
        CopycatTransformableState<T> state = new CopycatTransformableState<T>();
        consumer.accept(state);
        return state;
    }

    public Part<T> addPart(int x, int y, int z) {
        Part part = new Part(x, y, z);
        this.parts.add(part);
        return part;
    }

    public CopycatTransformableState<T> transform(StructureTransform transform) {
        this.parts.forEach(part -> part.transform(transform));
        return this;
    }

    public CopycatTransformableState<T> untransform(StructureTransform transform) {
        this.parts.forEach(part -> part.untransform(transform));
        return this;
    }

    public static class Part<T> {
        public class_2382 vector;
        public T data = null;

        public Part(int x, int y, int z) {
            this.vector = new class_2382(x, y, z);
        }

        public Part<T> setData(T data) {
            this.data = data;
            return this;
        }

        public T getData() {
            return this.data;
        }

        public Part<T> rotateY(class_2350 facing, class_2350 origin) {
            StructureTransform transform = new StructureTransform(class_2338.field_10980, 0.0f, origin.method_10144() - facing.method_10144(), 0.0f);
            return this.transform(transform);
        }

        public Part<T> rotateY(class_2350 facing) {
            return this.rotateY(facing, class_2350.field_11035);
        }

        public Part<T> transform(StructureTransform transform) {
            class_243 transformed = transform.applyWithoutOffset(new class_243((double)this.vector.method_10263() / 16.0, (double)this.vector.method_10264() / 16.0, (double)this.vector.method_10260() / 16.0));
            this.vector = new class_2382((int)Math.round(transformed.field_1352 * 16.0), (int)Math.round(transformed.field_1351 * 16.0), (int)Math.round(transformed.field_1350 * 16.0));
            return this;
        }

        private static class_243 unapplyWithoutOffset(StructureTransform transform, class_243 globalVec) {
            class_243 vec = globalVec;
            if (transform.rotationAxis != null) {
                vec = VecHelper.rotateCentered((class_243)vec, (double)(-transform.angle), (class_2350.class_2351)transform.rotationAxis);
            }
            if (transform.mirror != null) {
                vec = VecHelper.mirrorCentered((class_243)vec, (class_2415)transform.mirror);
            }
            return vec;
        }

        public Part<T> untransform(StructureTransform transform) {
            class_243 transformed = Part.unapplyWithoutOffset(transform, new class_243((double)this.vector.method_10263() / 16.0, (double)this.vector.method_10264() / 16.0, (double)this.vector.method_10260() / 16.0));
            this.vector = new class_2382((int)Math.round(transformed.field_1352 * 16.0), (int)Math.round(transformed.field_1351 * 16.0), (int)Math.round(transformed.field_1350 * 16.0));
            return this;
        }

        public class_2350 getFacing() {
            int dx = Math.abs(this.vector.method_10263() - 8);
            int dy = Math.abs(this.vector.method_10264() - 8);
            int dz = Math.abs(this.vector.method_10260() - 8);
            if (dz > dx && dz > dy) {
                return this.vector.method_10260() > 8 ? class_2350.field_11035 : class_2350.field_11043;
            }
            if (dx > dy && dx > dz) {
                return this.vector.method_10263() > 8 ? class_2350.field_11034 : class_2350.field_11039;
            }
            return this.vector.method_10264() > 8 ? class_2350.field_11036 : class_2350.field_11033;
        }

        public class_2350 getHorizontalFacing() {
            int dx = Math.abs(this.vector.method_10263() - 8);
            int dz = Math.abs(this.vector.method_10260() - 8);
            if (dz > dx) {
                return this.vector.method_10260() > 8 ? class_2350.field_11035 : class_2350.field_11043;
            }
            return this.vector.method_10263() > 8 ? class_2350.field_11034 : class_2350.field_11039;
        }

        public boolean isTop() {
            return this.vector.method_10264() > 8;
        }

        public boolean isRight(class_2350 facing) {
            return switch (facing) {
                case class_2350.field_11035 -> {
                    if (this.vector.method_10263() < 8) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11043 -> {
                    if (this.vector.method_10263() > 8) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11034 -> {
                    if (this.vector.method_10260() > 8) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11039 -> {
                    if (this.vector.method_10260() < 8) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
    }
}

