/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.compat.computercraft;

import com.mrh0.createaddition.blocks.digital_adapter.DigitalAdapterBlockEntity;
import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlockEntity;
import com.mrh0.createaddition.compat.computercraft.Helpers;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlock;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.elevator.ElevatorPulleyBlockEntity;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlockEntity;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.content.fluids.hosePulley.HosePulleyBlockEntity;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DigitalAdapterPeripheral
implements IPeripheral {
    private final String type;
    private final DigitalAdapterBlockEntity tileEntity;

    public DigitalAdapterPeripheral(String type, DigitalAdapterBlockEntity tileEntity) {
        this.type = type;
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return iPeripheral == this;
    }

    @Nullable
    public Object getTarget() {
        return this.tileEntity;
    }

    @LuaFunction(mainThread=true)
    public final void clearLine() {
        this.tileEntity.clearLine(this.tileEntity.getLine());
    }

    @LuaFunction(mainThread=true)
    public final void clear() {
        this.tileEntity.clearAll();
    }

    @LuaFunction(mainThread=true)
    public final void print(String text) {
        this.tileEntity.setTextLine(this.tileEntity.getLine(), class_2561.method_43470((String)text.substring(0, Math.min(text.length(), 128))));
        this.tileEntity.incrementLine();
    }

    @LuaFunction(mainThread=true)
    public final int getLine() {
        return this.tileEntity.getLine();
    }

    @LuaFunction(mainThread=true)
    public final int setLine(int ln) {
        return this.tileEntity.setLine(ln);
    }

    @LuaFunction(mainThread=true)
    public final int getMaxLines() {
        return 16;
    }

    @LuaFunction(mainThread=true)
    public final void setTargetSpeed(String direction, int speed) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return;
        }
        this.tileEntity.setTargetSpeed(dir, speed);
    }

    @LuaFunction(mainThread=true)
    public final int getTargetSpeed(String direction) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        return this.tileEntity.getTargetSpeed(dir);
    }

    @LuaFunction(mainThread=true)
    public final int getKineticStress(String direction) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        StressGaugeBlockEntity sg = this.tileEntity.getStressGauge(dir);
        if (sg == null) {
            return 0;
        }
        return (int)sg.getNetworkStress();
    }

    @LuaFunction(mainThread=true)
    public final int getKineticCapacity(String direction) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        StressGaugeBlockEntity sg = this.tileEntity.getStressGauge(dir);
        if (sg == null) {
            return 0;
        }
        return (int)sg.getNetworkCapacity();
    }

    @LuaFunction(mainThread=true)
    public final int getKineticSpeed(String direction) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        SpeedGaugeBlockEntity sg = this.tileEntity.getSpeedGauge(dir);
        if (sg == null) {
            return 0;
        }
        return (int)sg.getSpeed();
    }

    @LuaFunction(mainThread=true)
    public final int getKineticTopSpeed() {
        return (Integer)AllConfigs.server().kinetics.maxRotationSpeed.get();
    }

    @LuaFunction(mainThread=true)
    public final int getPulleyDistance(String direction) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        PulleyBlockEntity rp = this.tileEntity.getRopePulley(dir);
        HosePulleyBlockEntity hp = this.tileEntity.getHosePulley(dir);
        ElevatorPulleyBlockEntity ep = this.tileEntity.getElevatorPulley(dir);
        if (rp != null) {
            return (int)rp.getInterpolatedOffset(0.5f);
        }
        if (hp != null) {
            return (int)hp.getInterpolatedOffset(0.5f);
        }
        if (ep != null) {
            return (int)ep.getInterpolatedOffset(0.5f);
        }
        return 0;
    }

    @LuaFunction(mainThread=true)
    public final int getPistonDistance(String direction) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        MechanicalPistonBlockEntity mp = this.tileEntity.getMechanicalPiston(dir);
        if (mp == null) {
            return 0;
        }
        return (int)mp.getInterpolatedOffset(0.5f);
    }

    @LuaFunction(mainThread=true)
    public final int getBearingAngle(String direction) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        MechanicalBearingBlockEntity mp = this.tileEntity.getMechanicalBearing(dir);
        if (mp == null) {
            return 0;
        }
        return (int)mp.getInterpolatedAngle(0.5f);
    }

    @Nullable
    public final ElevatorContraption getElevatorContraption(ElevatorPulleyBlockEntity ep) {
        if (ep == null) {
            return null;
        }
        if (ep.movedContraption == null) {
            return null;
        }
        if (ep.movedContraption.getContraption() == null) {
            return null;
        }
        Contraption contraption = ep.movedContraption.getContraption();
        if (!(contraption instanceof ElevatorContraption)) {
            return null;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        return ec;
    }

    @LuaFunction(mainThread=true)
    public final int getElevatorFloor(String direction) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        ElevatorPulleyBlockEntity ep = this.tileEntity.getElevatorPulley(dir);
        if (ep == null) {
            return 0;
        }
        ElevatorContraption ec = this.getElevatorContraption(ep);
        if (ec == null) {
            return 0;
        }
        for (int i = 0; i < ec.namesList.size(); ++i) {
            if (((Integer)((IntAttached)ec.namesList.get(i)).getFirst()).intValue() != ec.getCurrentTargetY(ep.method_10997()).intValue()) continue;
            return i;
        }
        return 0;
    }

    @LuaFunction(mainThread=true)
    public final boolean hasElevatorArrived(String direction) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return false;
        }
        ElevatorPulleyBlockEntity ep = this.tileEntity.getElevatorPulley(dir);
        if (ep == null) {
            return false;
        }
        ElevatorContraption ec = this.getElevatorContraption(ep);
        if (ec == null) {
            return false;
        }
        return ec.arrived;
    }

    @LuaFunction(mainThread=true)
    public final int getElevatorFloors(String direction) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        ElevatorPulleyBlockEntity ep = this.tileEntity.getElevatorPulley(dir);
        if (ep == null) {
            return 0;
        }
        ElevatorContraption ec = this.getElevatorContraption(ep);
        if (ec == null) {
            return 0;
        }
        return ec.namesList.size();
    }

    @LuaFunction(mainThread=true)
    public final String getElevatorFloorName(String direction, int index) {
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return String.valueOf(index);
        }
        ElevatorPulleyBlockEntity ep = this.tileEntity.getElevatorPulley(dir);
        if (ep == null) {
            return String.valueOf(index);
        }
        ElevatorContraption ec = this.getElevatorContraption(ep);
        if (ec == null) {
            return String.valueOf(index);
        }
        if (index >= ec.namesList.size()) {
            return String.valueOf(index);
        }
        if (index < 0) {
            return String.valueOf(index);
        }
        return (String)((Couple)((IntAttached)ec.namesList.get(index)).getSecond()).getFirst();
    }

    @LuaFunction(mainThread=true)
    public final int gotoElevatorFloor(String direction, int index) {
        class_2338 pos;
        class_2680 blockState;
        class_2248 block;
        class_2350 dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        ElevatorPulleyBlockEntity ep = this.tileEntity.getElevatorPulley(dir);
        if (ep == null) {
            return 0;
        }
        ElevatorContraption ec = this.getElevatorContraption(ep);
        if (ec == null) {
            return 0;
        }
        if (index >= ec.namesList.size()) {
            return 0;
        }
        if (index < 0) {
            return 0;
        }
        class_1937 level = this.tileEntity.method_10997();
        int oldTargetY = ec.getCurrentTargetY(level);
        int targetY = (Integer)((IntAttached)ec.namesList.get(index)).getFirst();
        ElevatorColumn elevatorColumn = ElevatorColumn.get((class_1936)level, (ElevatorColumn.ColumnCoords)ec.getGlobalColumn());
        if (!ec.isTargetUnreachable(targetY) && (block = (blockState = level.method_8320(pos = elevatorColumn.contactAt(targetY))).method_26204()) instanceof ElevatorContactBlock) {
            ElevatorContactBlock ecb = (ElevatorContactBlock)block;
            ecb.callToContactAndUpdate(elevatorColumn, blockState, level, pos, false);
        }
        return targetY - oldTargetY;
    }

    @LuaFunction(mainThread=true)
    public final float getDurationAngle(int deg, int rpm) throws LuaException {
        return (float)ElectricMotorBlockEntity.getDurationAngle(deg, 0.0f, rpm) / 20.0f;
    }

    @LuaFunction(mainThread=true)
    public final float getDurationDistance(int blocks, int rpm) throws LuaException {
        return (float)ElectricMotorBlockEntity.getDurationDistance(blocks, 0.0f, rpm) / 20.0f;
    }
}

