/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.block.custom;

import java.util.HashMap;
import java.util.Map;
import net.emilsg.clutter.block.custom.WaterloggableLitBlock;
import net.emilsg.clutter.util.ModProperties;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5544;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ReworkedCandleHolderBlock
extends class_2248
implements class_3737 {
    public static final class_2754<Type> TYPE = class_2754.method_11850((String)"type", Type.class);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2746 CANDLES = ModProperties.CANDLES;
    public static final class_2754<CandleColor> CANDLE_COLOR = class_2754.method_11850((String)"candle_color", CandleColor.class);
    private static final class_265 NORTH_FLOOR_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), (class_265[])new class_265[]{class_2248.method_9541((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), class_2248.method_9541((double)0.0, (double)9.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0), class_2248.method_9541((double)12.0, (double)9.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), class_2248.method_9541((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), class_2248.method_9541((double)1.0, (double)10.0, (double)7.0, (double)3.0, (double)13.0, (double)9.0), class_2248.method_9541((double)13.0, (double)10.0, (double)7.0, (double)15.0, (double)14.0, (double)9.0), class_2248.method_9541((double)1.0, (double)8.0, (double)7.5, (double)4.0, (double)9.0, (double)8.5), class_2248.method_9541((double)3.0, (double)6.0, (double)7.5, (double)6.0, (double)8.0, (double)8.5), class_2248.method_9541((double)10.0, (double)6.0, (double)7.5, (double)13.0, (double)8.0, (double)8.5), class_2248.method_9541((double)6.0, (double)5.0, (double)7.5, (double)10.0, (double)8.0, (double)8.5), class_2248.method_9541((double)12.0, (double)8.0, (double)7.5, (double)15.0, (double)9.0, (double)8.5)});
    private static final class_265 EAST_FLOOR_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0), (class_265[])new class_265[]{class_2248.method_9541((double)6.0, (double)9.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0), class_2248.method_9541((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), class_2248.method_9541((double)7.5, (double)8.0, (double)1.0, (double)8.5, (double)9.0, (double)4.0), class_2248.method_9541((double)7.5, (double)6.0, (double)3.0, (double)8.5, (double)8.0, (double)6.0), class_2248.method_9541((double)7.5, (double)6.0, (double)10.0, (double)8.5, (double)8.0, (double)13.0), class_2248.method_9541((double)7.5, (double)5.0, (double)6.0, (double)8.5, (double)8.0, (double)10.0), class_2248.method_9541((double)7.5, (double)8.0, (double)12.0, (double)8.5, (double)9.0, (double)15.0), class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), class_2248.method_9541((double)7.0, (double)10.0, (double)1.0, (double)9.0, (double)13.0, (double)3.0), class_2248.method_9541((double)7.0, (double)10.0, (double)13.0, (double)9.0, (double)14.0, (double)15.0)});
    private static final class_265 SOUTH_FLOOR_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0), (class_265[])new class_265[]{class_2248.method_9541((double)6.0, (double)9.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0), class_2248.method_9541((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), class_2248.method_9541((double)7.5, (double)8.0, (double)1.0, (double)8.5, (double)9.0, (double)4.0), class_2248.method_9541((double)7.5, (double)6.0, (double)3.0, (double)8.5, (double)8.0, (double)6.0), class_2248.method_9541((double)7.5, (double)6.0, (double)10.0, (double)8.5, (double)8.0, (double)13.0), class_2248.method_9541((double)7.5, (double)5.0, (double)6.0, (double)8.5, (double)8.0, (double)10.0), class_2248.method_9541((double)7.5, (double)8.0, (double)12.0, (double)8.5, (double)9.0, (double)15.0), class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), class_2248.method_9541((double)7.0, (double)10.0, (double)1.0, (double)9.0, (double)14.0, (double)3.0), class_2248.method_9541((double)7.0, (double)10.0, (double)13.0, (double)9.0, (double)13.0, (double)15.0)});
    private static final class_265 WEST_FLOOR_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0), (class_265[])new class_265[]{class_2248.method_9541((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), class_2248.method_9541((double)0.0, (double)9.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0), class_2248.method_9541((double)12.0, (double)9.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), class_2248.method_9541((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), class_2248.method_9541((double)1.0, (double)10.0, (double)7.0, (double)3.0, (double)14.0, (double)9.0), class_2248.method_9541((double)13.0, (double)10.0, (double)7.0, (double)15.0, (double)13.0, (double)9.0), class_2248.method_9541((double)1.0, (double)8.0, (double)7.5, (double)4.0, (double)9.0, (double)8.5), class_2248.method_9541((double)3.0, (double)6.0, (double)7.5, (double)6.0, (double)8.0, (double)8.5), class_2248.method_9541((double)10.0, (double)6.0, (double)7.5, (double)13.0, (double)8.0, (double)8.5), class_2248.method_9541((double)6.0, (double)5.0, (double)7.5, (double)10.0, (double)8.0, (double)8.5), class_2248.method_9541((double)12.0, (double)8.0, (double)7.5, (double)15.0, (double)9.0, (double)8.5)});
    private static final class_265 NORTH_WALL_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)7.0, (double)3.0, (double)11.0, (double)9.0, (double)5.0, (double)15.0), (class_265[])new class_265[]{class_2248.method_9541((double)6.0, (double)2.0, (double)15.0, (double)10.0, (double)6.0, (double)16.0), class_2248.method_9541((double)7.0, (double)5.0, (double)11.0, (double)9.0, (double)6.0, (double)13.0), class_2248.method_9541((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)7.0, (double)14.0), class_2248.method_9541((double)7.0, (double)7.0, (double)11.0, (double)9.0, (double)13.0, (double)13.0)});
    private static final class_265 EAST_WALL_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)1.0, (double)3.0, (double)7.0, (double)5.0, (double)5.0, (double)9.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)2.0, (double)6.0, (double)1.0, (double)6.0, (double)10.0), class_2248.method_9541((double)3.0, (double)5.0, (double)7.0, (double)5.0, (double)6.0, (double)9.0), class_2248.method_9541((double)2.0, (double)6.0, (double)6.0, (double)6.0, (double)7.0, (double)10.0), class_2248.method_9541((double)3.0, (double)7.0, (double)7.0, (double)5.0, (double)13.0, (double)9.0)});
    private static final class_265 SOUTH_WALL_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)11.0, (double)3.0, (double)7.0, (double)15.0, (double)5.0, (double)9.0), (class_265[])new class_265[]{class_2248.method_9541((double)15.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0), class_2248.method_9541((double)11.0, (double)5.0, (double)7.0, (double)13.0, (double)6.0, (double)9.0), class_2248.method_9541((double)10.0, (double)6.0, (double)6.0, (double)14.0, (double)7.0, (double)10.0), class_2248.method_9541((double)11.0, (double)7.0, (double)7.0, (double)13.0, (double)13.0, (double)9.0)});
    private static final class_265 WEST_WALL_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)7.0, (double)3.0, (double)1.0, (double)9.0, (double)5.0, (double)5.0), (class_265[])new class_265[]{class_2248.method_9541((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)1.0), class_2248.method_9541((double)7.0, (double)5.0, (double)3.0, (double)9.0, (double)6.0, (double)5.0), class_2248.method_9541((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)7.0, (double)6.0), class_2248.method_9541((double)7.0, (double)7.0, (double)3.0, (double)9.0, (double)13.0, (double)5.0)});
    private static final class_265 CEILING_SHAPE = class_259.method_1084((class_265)class_2248.method_9541((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), (class_265)class_2248.method_9541((double)1.5, (double)1.0, (double)1.0, (double)14.5, (double)8.0, (double)15.0));
    private static final class_243[] CANDLE_POSITIONS_NORTH_FLOOR = new class_243[]{new class_243(0.125, 0.90625, 0.5), new class_243(0.5, 1.09375, 0.5), new class_243(0.875, 0.96875, 0.5)};
    private static final class_243[] CANDLE_POSITIONS_SOUTH_FLOOR = new class_243[]{new class_243(0.125, 0.96875, 0.5), new class_243(0.5, 1.09375, 0.5), new class_243(0.875, 0.90625, 0.5)};
    private static final class_243[] CANDLE_POSITIONS_EAST_FLOOR = new class_243[]{new class_243(0.5, 0.90625, 0.125), new class_243(0.5, 1.09375, 0.5), new class_243(0.5, 0.96875, 0.875)};
    private static final class_243[] CANDLE_POSITIONS_WEST_FLOOR = new class_243[]{new class_243(0.5, 0.96875, 0.125), new class_243(0.5, 1.09375, 0.5), new class_243(0.5, 0.90625, 0.875)};
    private static final class_243 CANDLE_POSITION_NORTH_WALL = new class_243(0.5, 0.90625, 0.75);
    private static final class_243 CANDLE_POSITION_EAST_WALL = new class_243(0.25, 0.90625, 0.5);
    private static final class_243 CANDLE_POSITION_SOUTH_WALL = new class_243(0.5, 0.90625, 0.25);
    private static final class_243 CANDLE_POSITION_WEST_WALL = new class_243(0.75, 0.90625, 0.5);
    private static final class_243[] CANDLE_POSITIONS_CEILING = new class_243[]{new class_243(0.1875, 0.59375, 0.5), new class_243(0.5, 0.59375, 0.8125), new class_243(0.5, 0.59375, 0.1875), new class_243(0.8125, 0.59375, 0.5)};
    private static final Map<class_1792, CandleColor> CANDLE_TO_COLOR = new HashMap<class_1792, CandleColor>();

    public ReworkedCandleHolderBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)((Object)Type.FLOOR))).method_11657((class_2769)CANDLES, (Comparable)Boolean.valueOf(false))).method_11657(CANDLE_COLOR, (Comparable)((Object)CandleColor.NULL)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TYPE, FACING, WATERLOGGED, LIT, CANDLES, CANDLE_COLOR});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = this.method_9564();
        class_2350 direction = ctx.method_8038();
        class_1937 worldView = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_3610 fluidState = worldView.method_8316(blockPos);
        state = this.setTypeBasedOnDirection(state, direction, ctx.method_8042().method_10153());
        if (this.isVertical(direction)) {
            return (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return this.findWallState(state, worldView, blockPos, ctx, fluidState);
    }

    private class_2680 setTypeBasedOnDirection(class_2680 state, class_2350 direction, class_2350 horizontalFacing) {
        Type type = switch (direction) {
            case class_2350.field_11036 -> Type.FLOOR;
            case class_2350.field_11033 -> Type.CEILING;
            default -> Type.WALL;
        };
        return (class_2680)((class_2680)state.method_11657(TYPE, (Comparable)((Object)type))).method_11657((class_2769)FACING, (Comparable)(this.isVertical(direction) ? horizontalFacing : class_2350.field_11043));
    }

    private boolean isVertical(class_2350 direction) {
        return direction == class_2350.field_11033 || direction == class_2350.field_11036;
    }

    private class_2680 findWallState(class_2680 state, class_1937 world, class_2338 pos, class_1750 ctx, class_3610 fluidState) {
        for (class_2350 wallDirection : ctx.method_7718()) {
            class_2680 newState;
            if (!wallDirection.method_10166().method_10179() || !(newState = (class_2680)state.method_11657((class_2769)FACING, (Comparable)wallDirection.method_10153())).method_26184((class_4538)world, pos)) continue;
            return (class_2680)newState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return state;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        Type type = (Type)((Object)state.method_11654(TYPE));
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        if (type == Type.CEILING) {
            return CEILING_SHAPE;
        }
        return type == Type.WALL ? this.getWallShape(direction) : this.getFloorShape(direction);
    }

    private class_265 getWallShape(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> NORTH_WALL_SHAPE;
            case class_2350.field_11034 -> EAST_WALL_SHAPE;
            case class_2350.field_11039 -> SOUTH_WALL_SHAPE;
            default -> WEST_WALL_SHAPE;
        };
    }

    private class_265 getFloorShape(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> NORTH_FLOOR_SHAPE;
            case class_2350.field_11034 -> EAST_FLOOR_SHAPE;
            case class_2350.field_11039 -> SOUTH_FLOOR_SHAPE;
            default -> WEST_FLOOR_SHAPE;
        };
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        int requiredCount;
        if (!player.method_31549().field_7476 || ((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return super.method_9534(state, world, pos, player, hand, hit);
        }
        class_1799 stackInHand = player.method_5998(hand);
        boolean isLit = (Boolean)state.method_11654((class_2769)LIT);
        CandleColor currentColor = (CandleColor)((Object)state.method_11654(CANDLE_COLOR));
        boolean candles = (Boolean)state.method_11654((class_2769)CANDLES);
        Type type = (Type)((Object)state.method_11654(TYPE));
        int n = type == Type.CEILING ? 4 : (requiredCount = type == Type.FLOOR ? 3 : 1);
        if (class_2248.method_9503((class_1792)stackInHand.method_7909()) instanceof class_5544) {
            CandleColor color = CANDLE_TO_COLOR.get(stackInHand.method_7909());
            if (stackInHand.method_7947() >= requiredCount && state.method_11654(CANDLE_COLOR) != color) {
                this.handleCandlePlacement(state, world, pos, player, hand, requiredCount, currentColor, candles);
                return class_1269.field_5812;
            }
        }
        if (stackInHand.method_31574(class_1802.field_8884) && !isLit && candles) {
            this.playSound(world, pos, class_3417.field_15145);
            this.setLit((class_1936)world, state, pos, true, player);
            this.damageItemIfNotCreative(player, hand);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (stackInHand.method_31574(class_1802.field_8814) && !isLit && candles) {
            this.playSound(world, pos, class_3417.field_15013);
            this.setLit((class_1936)world, state, pos, true, player);
            this.decrementItemIfNotCreative(player, hand, 1);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (stackInHand.method_7960() && isLit) {
            this.extinguish(player, state, (class_1936)world, pos);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (stackInHand.method_7960() && candles && !isLit) {
            this.setCandleAndColor((class_1936)world, state, pos, CandleColor.NULL, false, player);
            CANDLE_TO_COLOR.entrySet().stream().filter(entry -> entry.getValue() == currentColor).map(Map.Entry::getKey).findFirst().ifPresent(oldCandles -> {
                class_1799 oldCandlesStack = new class_1799((class_1935)oldCandles, requiredCount);
                ReworkedCandleHolderBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)oldCandlesStack);
            });
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    private void handleCandlePlacement(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, int requiredCount, CandleColor currentColor, boolean candles) {
        class_1799 stackInHand = player.method_5998(hand);
        CandleColor newColor = CANDLE_TO_COLOR.get(stackInHand.method_7909());
        if (state.method_11654(CANDLE_COLOR) != newColor) {
            this.setCandleAndColor((class_1936)world, state, pos, newColor, true, player);
            this.playSound(world, pos, class_3417.field_26958);
            this.decrementItemIfNotCreative(player, hand, requiredCount);
            if (candles) {
                CANDLE_TO_COLOR.entrySet().stream().filter(entry -> entry.getValue() == currentColor).map(Map.Entry::getKey).findFirst().ifPresent(oldCandles -> {
                    class_1799 oldCandlesStack = new class_1799((class_1935)oldCandles, requiredCount);
                    ReworkedCandleHolderBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)oldCandlesStack);
                });
            }
        }
    }

    public void setCandleAndColor(class_1936 world, class_2680 state, class_2338 pos, CandleColor color, boolean candle, @Nullable class_1657 player) {
        world.method_8652(pos, (class_2680)((class_2680)state.method_11657(CANDLE_COLOR, (Comparable)((Object)color))).method_11657((class_2769)CANDLES, (Comparable)Boolean.valueOf(candle)), 11);
        world.method_33596((class_1297)player, class_5712.field_28733, pos);
    }

    private void playSound(class_1937 world, class_2338 pos, class_3414 soundEvent) {
        world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.4f + 0.8f);
    }

    private void damageItemIfNotCreative(class_1657 player, class_1268 hand) {
        if (!player.method_31549().field_7477) {
            player.method_5998(hand).method_7956(1, (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
        }
    }

    private void decrementItemIfNotCreative(class_1657 player, class_1268 hand, int count) {
        if (!player.method_31549().field_7477) {
            player.method_5998(hand).method_7934(count);
        }
    }

    public void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        if (!world.field_9236 && projectile.method_5809() && this.isNotLit(state)) {
            this.setLit((class_1936)world, state, hit.method_17777(), true, null);
        }
    }

    protected boolean isNotLit(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)LIT) == false;
    }

    public void extinguish(@Nullable class_1657 player, class_2680 state, class_1936 world, class_2338 pos) {
        WaterloggableLitBlock.setLit(world, state, pos, false, player);
        world.method_8396(null, pos, class_3417.field_26955, class_3419.field_15245, 1.0f, 1.0f);
    }

    public void setLit(class_1936 world, class_2680 state, class_2338 pos, boolean lit, @Nullable class_1657 player) {
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(lit)), 11);
        world.method_33596((class_1297)player, class_5712.field_28733, pos);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10153() == state.method_11654((class_2769)FACING) && !state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (!((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && fluidState.method_15772() == class_3612.field_15910) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            world.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)world));
            return true;
        }
        return false;
    }

    public class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() || !((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            return;
        }
        Type type = (Type)((Object)state.method_11654(TYPE));
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_243 offset = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        switch (type.ordinal()) {
            case 0: {
                class_243[] floorPositions;
                for (class_243 posFloor : floorPositions = this.getCandlePositionsFloor(direction)) {
                    this.spawnCandleParticles(world, offset.method_1019(posFloor), random);
                }
                break;
            }
            case 2: {
                class_243 wallPosition = this.getCandlePositionWall(direction);
                this.spawnCandleParticles(world, offset.method_1019(wallPosition), random);
                break;
            }
            case 1: {
                for (class_243 posCeiling : CANDLE_POSITIONS_CEILING) {
                    this.spawnCandleParticles(world, offset.method_1019(posCeiling), random);
                }
                break;
            }
        }
    }

    private class_243[] getCandlePositionsFloor(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> CANDLE_POSITIONS_NORTH_FLOOR;
            case class_2350.field_11034 -> CANDLE_POSITIONS_EAST_FLOOR;
            case class_2350.field_11035 -> CANDLE_POSITIONS_SOUTH_FLOOR;
            default -> CANDLE_POSITIONS_WEST_FLOOR;
        };
    }

    private class_243 getCandlePositionWall(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11043 -> CANDLE_POSITION_NORTH_WALL;
            case class_2350.field_11034 -> CANDLE_POSITION_EAST_WALL;
            case class_2350.field_11035 -> CANDLE_POSITION_SOUTH_WALL;
            default -> CANDLE_POSITION_WEST_WALL;
        };
    }

    private void spawnCandleParticles(class_1937 world, class_243 vec3d, class_5819 random) {
        float f = random.method_43057();
        if (f < 0.3f) {
            world.method_8406((class_2394)class_2398.field_11251, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                world.method_8486(vec3d.field_1352 + 0.5, vec3d.field_1351 + 0.5, vec3d.field_1350 + 0.5, class_3417.field_26953, class_3419.field_15245, 1.0f + random.method_43057(), random.method_43057() * 0.7f + 0.3f, false);
            }
        }
        world.method_8406((class_2394)class_2398.field_27783, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 0.0, 0.0, 0.0);
    }

    static {
        CANDLE_TO_COLOR.put(class_1802.field_27025, CandleColor.WHITE);
        CANDLE_TO_COLOR.put(class_1802.field_27055, CandleColor.LIGHT_GRAY);
        CANDLE_TO_COLOR.put(class_1802.field_27054, CandleColor.GRAY);
        CANDLE_TO_COLOR.put(class_1802.field_27062, CandleColor.BLACK);
        CANDLE_TO_COLOR.put(class_1802.field_27059, CandleColor.BROWN);
        CANDLE_TO_COLOR.put(class_1802.field_27061, CandleColor.RED);
        CANDLE_TO_COLOR.put(class_1802.field_27026, CandleColor.ORANGE);
        CANDLE_TO_COLOR.put(class_1802.field_27029, CandleColor.YELLOW);
        CANDLE_TO_COLOR.put(class_1802.field_27052, CandleColor.LIME);
        CANDLE_TO_COLOR.put(class_1802.field_27060, CandleColor.GREEN);
        CANDLE_TO_COLOR.put(class_1802.field_27056, CandleColor.CYAN);
        CANDLE_TO_COLOR.put(class_1802.field_27028, CandleColor.LIGHT_BLUE);
        CANDLE_TO_COLOR.put(class_1802.field_27058, CandleColor.BLUE);
        CANDLE_TO_COLOR.put(class_1802.field_27057, CandleColor.PURPLE);
        CANDLE_TO_COLOR.put(class_1802.field_27027, CandleColor.MAGENTA);
        CANDLE_TO_COLOR.put(class_1802.field_27053, CandleColor.PINK);
        CANDLE_TO_COLOR.put(class_1802.field_27024, CandleColor.NONE);
    }

    public static enum Type implements class_3542
    {
        FLOOR("floor"),
        CEILING("ceiling"),
        WALL("wall");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum CandleColor implements class_3542
    {
        WHITE("white"),
        LIGHT_GRAY("light_gray"),
        GRAY("gray"),
        BLACK("black"),
        BROWN("brown"),
        RED("red"),
        ORANGE("orange"),
        YELLOW("yellow"),
        LIME("lime"),
        GREEN("green"),
        CYAN("cyan"),
        LIGHT_BLUE("light_blue"),
        BLUE("blue"),
        PURPLE("purple"),
        MAGENTA("magenta"),
        PINK("pink"),
        NONE("none"),
        NULL("null");

        private final String name;

        private CandleColor(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

