/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.breeches.quickfiring_breech.QuickfiringBreechBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class QuickfiringBreechInstance
extends BlockEntityInstance<QuickfiringBreechBlockEntity>
implements DynamicInstance {
    private OrientedData breechblock;
    private OrientedData shaft;
    private OrientedData lever;
    private class_2350 direction;
    private class_2350 blockRotation;

    public QuickfiringBreechInstance(MaterialManager materialManager, QuickfiringBreechBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
    }

    public void init() {
        super.init();
        class_2350.class_2351 axis = QuickfiringBreechInstance.getRotationAxis(this.blockState);
        class_2350 facing = (class_2350)this.blockState.method_11654((class_2769)class_2741.field_12525);
        this.blockRotation = facing.method_35834(axis);
        if (this.blockRotation == class_2350.field_11033) {
            this.blockRotation = class_2350.field_11036;
        }
        this.breechblock = (OrientedData)this.materialManager.defaultSolid().material(Materials.ORIENTED).getModel(QuickfiringBreechInstance.getPartialModelForState(this.blockState), this.blockState, this.blockRotation).createInstance();
        this.shaft = (OrientedData)this.materialManager.defaultSolid().material(Materials.ORIENTED).getModel((class_2680)AllBlocks.SHAFT.getDefaultState().method_11657((class_2769)class_2741.field_12496, (Comparable)axis)).createInstance();
        this.direction = facing.method_35834(this.blockRotation.method_10166());
        this.lever = (OrientedData)this.materialManager.defaultSolid().material(Materials.ORIENTED).getModel(CBCBlockPartials.QUICKFIRING_BREECH_LEVER, this.blockState, this.direction).createInstance();
        boolean alongFirst = (Boolean)this.blockState.method_11654((class_2769)QuickfiringBreechBlock.AXIS);
        if (facing.method_10166().method_10179() && !alongFirst) {
            class_2350 rotDir = facing.method_10166() == class_2350.class_2351.field_11048 ? class_2350.field_11036 : class_2350.field_11034;
            Quaternionf q = class_7833.method_46356((Vector3f)rotDir.method_23955()).rotationDegrees(90.0f);
            this.breechblock.setRotation(q);
        }
        if (facing.method_10166() == class_2350.class_2351.field_11048 && alongFirst) {
            this.breechblock.setRotation(class_7833.method_46356((Vector3f)this.blockRotation.method_23955()).rotationDegrees(90.0f));
        }
        this.transformModels();
    }

    public void beginFrame() {
        this.transformModels();
    }

    private void transformModels() {
        float progress = ((QuickfiringBreechBlockEntity)this.blockEntity).getOpenProgress(AnimationTickHolder.getPartialTicks());
        class_2338 instancePos = this.getInstancePosition();
        float renderedBreechblockOffset = progress / 16.0f * 13.0f;
        Vector3f normal = this.blockRotation.method_23955();
        normal.mul(renderedBreechblockOffset);
        this.breechblock.setPosition(instancePos).nudge(normal.x(), normal.y(), normal.z());
        float angle = progress * 90.0f;
        Quaternionf qrot = class_7833.method_46356((Vector3f)this.direction.method_23955()).rotationDegrees(angle);
        this.shaft.setPosition(instancePos).setRotation(qrot);
        this.lever.setPosition(instancePos.method_10093(this.direction)).setRotation(qrot);
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.breechblock});
        this.relight(this.pos, new FlatLit[]{this.shaft});
        this.relight(this.pos, new FlatLit[]{this.lever});
    }

    public void remove() {
        this.breechblock.delete();
        this.shaft.delete();
        this.lever.delete();
    }

    private static PartialModel getPartialModelForState(class_2680 state) {
        PartialModel partialModel;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)class_22482;
            partialModel = CBCBlockPartials.breechblockFor(cBlock.getCannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_SLIDING_BREECHBLOCK;
        }
        return partialModel;
    }

    private static class_2350.class_2351 getRotationAxis(class_2680 state) {
        boolean flag = (Boolean)state.method_11654((class_2769)QuickfiringBreechBlock.AXIS);
        return switch (((class_2350)state.method_11654((class_2769)QuickfiringBreechBlock.field_10927)).method_10166()) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> {
                if (flag) {
                    yield class_2350.class_2351.field_11052;
                }
                yield class_2350.class_2351.field_11051;
            }
            case class_2350.class_2351.field_11052 -> {
                if (flag) {
                    yield class_2350.class_2351.field_11048;
                }
                yield class_2350.class_2351.field_11051;
            }
            case class_2350.class_2351.field_11051 -> flag ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11052;
        };
    }
}

