/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.boring;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import net.minecraft.class_8567;
import rbasamoyai.createbigcannons.CBCTags;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.base.PoleContraption;
import rbasamoyai.createbigcannons.base.PoleMoverBlockEntity;
import rbasamoyai.createbigcannons.cannons.CannonBehavior;
import rbasamoyai.createbigcannons.cannons.ICannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.crafting.BlockRecipeType;
import rbasamoyai.createbigcannons.crafting.BlockRecipesManager;
import rbasamoyai.createbigcannons.crafting.boring.CannonDrillBlock;
import rbasamoyai.createbigcannons.crafting.boring.CannonDrillingContraption;
import rbasamoyai.createbigcannons.crafting.boring.DrillBoringBlockRecipe;
import rbasamoyai.createbigcannons.crafting.builtup.LayeredBigCannonBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.ClientboundUpdateContraptionPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class AbstractCannonDrillBlockEntity
extends PoleMoverBlockEntity {
    protected AbstractContraptionEntity latheEntity;
    protected class_2338 boringPos;
    protected float boreSpeed;
    protected float addedStressImpact;
    protected FailureReason failureReason = FailureReason.NONE;
    private DrillBoringBlockRecipe currentRecipe;

    protected AbstractCannonDrillBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        class_2338 class_23382 = this.boringPos = compound.method_10545("BoringPos") ? class_2512.method_10691((class_2487)compound.method_10562("BoringPos")) : null;
        if (!clientPacket) {
            return;
        }
        this.boreSpeed = compound.method_10583("BoreSpeed");
        this.addedStressImpact = compound.method_10583("AddedStress");
        this.failureReason = compound.method_10545("FailureReason") ? FailureReason.fromId(compound.method_10558("FailureReason")) : FailureReason.NONE;
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.boringPos != null) {
            compound.method_10566("BoringPos", (class_2520)class_2512.method_10692((class_2338)this.boringPos));
        }
        if (!clientPacket) {
            return;
        }
        if (this.addedStressImpact > 0.0f) {
            compound.method_10548("AddedStress", this.addedStressImpact);
        }
        if (this.boreSpeed != 0.0f) {
            compound.method_10548("BoreSpeed", this.boreSpeed);
        }
        if (this.failureReason != FailureReason.NONE) {
            compound.method_10582("FailureReason", this.failureReason.method_15434());
        }
    }

    @Override
    protected PoleContraption innerAssemble() throws AssemblyException {
        if (!(this.method_10997().method_8320(this.field_11867).method_26204() instanceof CannonDrillBlock)) {
            return null;
        }
        this.failureReason = FailureReason.NONE;
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)CannonDrillBlock.FACING);
        CannonDrillingContraption contraption = new CannonDrillingContraption(facing, this.getMovementSpeed() < 0.0f);
        if (!contraption.assemble(this.method_10997(), this.field_11867)) {
            return null;
        }
        class_2350 positive = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)facing.method_10166());
        class_2350 movementDirection = this.getSpeed() > 0.0f ^ facing.method_10166() != class_2350.class_2351.field_11051 ? positive : positive.method_10153();
        class_2338 anchor = contraption.anchor.method_10079(facing, contraption.initialExtensionProgress());
        return this.initialCollide(contraption, anchor, movementDirection) ? null : contraption;
    }

    private boolean initialCollide(CannonDrillingContraption contraption, class_2338 anchor, class_2350 movementDirection) {
        if (ContraptionCollider.isCollidingWithWorld((class_1937)this.method_10997(), (TranslatingContraption)contraption, (class_2338)anchor.method_10093(movementDirection), (class_2350)movementDirection)) {
            return true;
        }
        class_243 pos = class_243.method_24954((class_2382)anchor.method_10093(movementDirection));
        class_2338 gridPos = class_2338.method_49638((class_2374)pos);
        class_238 bounds = contraption.bounds.method_997(pos);
        if (movementDirection.method_10171() == class_2350.class_2352.field_11056) {
            gridPos = gridPos.method_10093(movementDirection);
        }
        gridPos = gridPos.method_10093(movementDirection.method_10153());
        class_2350 facing = contraption.orientation();
        class_2350 positive = class_2350.method_10169((class_2350.class_2351)facing.method_10166(), (class_2350.class_2352)class_2350.class_2352.field_11056);
        class_243 mask = new class_243(1.0, 1.0, 1.0).method_1023((double)positive.method_10148(), (double)positive.method_10164(), (double)positive.method_10165());
        class_2338 maskedPos = class_2338.method_49638((class_2374)pos.method_18806(mask));
        class_238 newBounds = bounds.method_18804(new class_243(facing.method_23955()).method_1021(128.0)).method_1014(2.0);
        for (ControlledContraptionEntity other : this.method_10997().method_8390(ControlledContraptionEntity.class, newBounds, e -> !e.equals((Object)this.movedContraption))) {
            class_2338 otherMaskedPos;
            Contraption contraption2 = other.getContraption();
            if (!(contraption2 instanceof BearingContraption)) continue;
            BearingContraption lathe = (BearingContraption)contraption2;
            class_238 otherBounds = other.method_5829();
            class_2350 otherFacing = lathe.getFacing();
            class_243 otherPosition = other.method_19538();
            if (other.method_5765() || otherBounds == null || !bounds.method_994(otherBounds) || !maskedPos.equals((Object)(otherMaskedPos = class_2338.method_49638((class_2374)other.getAnchorVec().method_18806(mask)))) || otherFacing != facing.method_10153() || movementDirection == otherFacing) continue;
            class_2338 bearingPos = class_2338.method_49638((class_2374)other.getAnchorVec()).method_10093(facing);
            class_2586 class_25862 = this.method_10997().method_8321(bearingPos);
            if (!(class_25862 instanceof MechanicalBearingBlockEntity)) continue;
            MechanicalBearingBlockEntity bearing = (MechanicalBearingBlockEntity)class_25862;
            for (class_2338 colliderPos : contraption.getOrCreateColliders(this.method_10997(), movementDirection)) {
                class_3499.class_3501 drillBlockInfo = (class_3499.class_3501)contraption.getBlocks().get(colliderPos);
                class_2338 globalPos = colliderPos.method_10081((class_2382)gridPos);
                class_2338 otherColliderPos = globalPos.method_10059((class_2382)class_2338.method_49638((class_2374)otherPosition));
                if (facing.method_10171() == class_2350.class_2352.field_11060) {
                    otherColliderPos = otherColliderPos.method_10093(facing);
                }
                if (!lathe.getBlocks().containsKey(otherColliderPos) || !CBCBlocks.CANNON_DRILL_BIT.has(drillBlockInfo.comp_1342())) continue;
                class_3499.class_3501 latheBlockInfo = (class_3499.class_3501)lathe.getBlocks().get(otherColliderPos);
                DrillBoringBlockRecipe recipe = AbstractCannonDrillBlockEntity.getBlockRecipe(latheBlockInfo.comp_1342(), facing);
                if (recipe != null) {
                    this.currentRecipe = recipe;
                    return false;
                }
                if (latheBlockInfo.comp_1342().method_26164(CBCTags.CBCBlockTags.DRILL_CAN_PASS_THROUGH)) continue;
                return true;
            }
        }
        return false;
    }

    public static DrillBoringBlockRecipe getBlockRecipe(class_2680 block, class_2350 dir) {
        return BlockRecipesManager.getRecipesOfType(BlockRecipeType.DRILL_BORING).stream().map(DrillBoringBlockRecipe.class::cast).filter(r -> r.matches(block, dir)).findAny().orElse(null);
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        if (!this.field_11865) {
            this.method_10997().method_8652(this.field_11867, (class_2680)this.method_11010().method_11657(CannonDrillBlock.STATE, (Comparable)MechanicalPistonBlock.PistonState.EXTENDED), 19);
        }
        super.disassemble();
        if (this.field_11865) {
            this.field_11863.method_20290(2001, this.field_11867, class_2248.method_9507((class_2680)this.method_11010()));
            this.field_11863.method_33596(null, class_5712.field_28165, this.field_11867);
            CannonDrillBlock.destroyExtensionPoles(this.field_11863, this.field_11867, this.method_11010(), true);
        }
    }

    public void tick() {
        if (!this.method_10997().field_9236 && this.running && this.movedContraption != null && this.offset + this.getMovementSpeed() >= (float)this.getExtensionRange()) {
            this.collideWithContraptionToBore(null, false);
        }
        super.tick();
    }

    public void lazyTick() {
        if (!this.field_11863.field_9236) {
            this.sendData();
        }
    }

    protected boolean moveAndCollideContraption() {
        if (super.moveAndCollideContraption()) {
            this.collideWithContraptionToBore(null, true);
            this.boreSpeed = 0.0f;
            this.addedStressImpact = 0.0f;
            this.latheEntity = null;
            return true;
        }
        return false;
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.boreSpeed = 0.0f;
        this.addedStressImpact = 0.0f;
        this.latheEntity = null;
        this.failureReason = FailureReason.NONE;
    }

    public boolean collideWithContraptionToBore(ControlledContraptionEntity other, boolean collide) {
        Contraption contraption;
        class_2350 movementDirection;
        if (this.method_10997().field_9236) {
            return false;
        }
        if (other == null && this.latheEntity == null) {
            return false;
        }
        CannonDrillingContraption drill = (CannonDrillingContraption)this.movedContraption.getContraption();
        class_238 bounds = this.movedContraption.method_5829();
        class_243 pos = this.movedContraption.method_19538();
        class_2338 gridPos = class_2338.method_49638((class_2374)pos);
        class_243 motion = this.movedContraption.method_18798();
        if (drill == null || bounds == null) {
            return false;
        }
        class_2350 facing = drill.orientation();
        class_2350 positive = class_2350.method_10169((class_2350.class_2351)facing.method_10166(), (class_2350.class_2352)class_2350.class_2352.field_11056);
        class_243 mask = new class_243(1.0, 1.0, 1.0).method_1023((double)positive.method_10148(), (double)positive.method_10164(), (double)positive.method_10165());
        class_2338 maskedPos = class_2338.method_49638((class_2374)pos.method_18806(mask));
        class_2350 class_23502 = movementDirection = collide ? drill.orientation() : class_2350.method_10142((double)motion.field_1352, (double)motion.field_1351, (double)motion.field_1350);
        if (!collide && movementDirection.method_10171() == class_2350.class_2352.field_11056) {
            gridPos = gridPos.method_10093(movementDirection);
        }
        if (collide && movementDirection.method_10171() == class_2350.class_2352.field_11060) {
            gridPos = gridPos.method_10093(movementDirection.method_10153());
        }
        boolean isBoringBlock = false;
        if (this.latheEntity == null) {
            this.latheEntity = other;
        }
        if (!((contraption = this.latheEntity.getContraption()) instanceof BearingContraption)) {
            this.stopBoringState();
            return false;
        }
        BearingContraption lathe = (BearingContraption)contraption;
        class_238 otherBounds = this.latheEntity.method_5829();
        class_2350 otherFacing = lathe.getFacing();
        class_243 otherPosition = this.latheEntity.method_19538();
        if (this.latheEntity.method_5765() || otherBounds == null || !bounds.method_997(motion).method_994(otherBounds)) {
            this.stopBoringState();
            return false;
        }
        class_2338 otherMaskedPos = class_2338.method_49638((class_2374)this.latheEntity.getAnchorVec().method_18806(mask));
        if (!maskedPos.equals((Object)otherMaskedPos) || otherFacing != facing.method_10153() || movementDirection == otherFacing) {
            this.stopBoringState();
            return false;
        }
        class_2338 bearingPos = class_2338.method_49638((class_2374)this.latheEntity.getAnchorVec()).method_10093(facing);
        class_2586 class_25862 = this.method_10997().method_8321(bearingPos);
        if (!(class_25862 instanceof MechanicalBearingBlockEntity)) {
            this.stopBoringState();
            return false;
        }
        MechanicalBearingBlockEntity bearing = (MechanicalBearingBlockEntity)class_25862;
        for (class_2338 colliderPos : drill.getOrCreateColliders(this.method_10997(), movementDirection)) {
            float f;
            class_2248 class_22482;
            class_2338 currentPos;
            class_3499.class_3501 drillBlockInfo = (class_3499.class_3501)drill.getBlocks().get(colliderPos);
            class_2338 globalPos = colliderPos.method_10081((class_2382)gridPos);
            class_2338 otherColliderPos = globalPos.method_10059((class_2382)class_2338.method_49638((class_2374)otherPosition));
            if (!lathe.getBlocks().containsKey(otherColliderPos) || !CBCBlocks.CANNON_DRILL_BIT.has(drillBlockInfo.comp_1342())) continue;
            class_3499.class_3501 latheBlockInfo = (class_3499.class_3501)lathe.getBlocks().get(otherColliderPos);
            class_2338 class_23382 = currentPos = collide || this.offset + this.getMovementSpeed() >= (float)this.getExtensionRange() ? globalPos.method_10093(movementDirection) : globalPos;
            if (this.boringPos == null) {
                this.boringPos = currentPos;
            } else if (!this.boringPos.equals((Object)currentPos)) {
                this.tryFinishingBoring();
                this.boringPos = currentPos;
            }
            DrillBoringBlockRecipe candidate = AbstractCannonDrillBlockEntity.getBlockRecipe(latheBlockInfo.comp_1342(), facing);
            if (candidate == null) {
                if (latheBlockInfo.comp_1342().method_26164(CBCTags.CBCBlockTags.DRILL_CAN_PASS_THROUGH)) continue;
                this.stopBoringState();
                this.simulateStop();
                return true;
            }
            this.currentRecipe = candidate;
            int drainSpeed = (int)class_3532.method_15379((float)(bearing.getSpeed() * 0.5f));
            if (Math.abs(bearing.getSpeed()) > Math.abs(this.getSpeed())) {
                this.failureReason = FailureReason.TOO_WEAK;
            } else if (this.drainLubricant(drainSpeed)) {
                boolean start;
                boolean bl = start = this.failureReason == FailureReason.NONE;
                if (start) {
                    this.method_10997().method_8396(null, globalPos, class_3417.field_15102, class_3419.field_15245, 1.0f, 2.0f);
                }
                if ((start || this.method_10997().method_8510() % 3L == 0L) && (class_22482 = this.method_10997()) instanceof class_3218) {
                    class_3218 slevel = (class_3218)class_22482;
                    class_243 particlePos = class_243.method_24953((class_2382)globalPos).method_1023((double)facing.method_10148() * 0.5, (double)facing.method_10164() * 0.5, (double)facing.method_10165() * 0.5);
                    slevel.method_14199((class_2394)class_2398.field_11251, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 10, 0.0, 0.0, 0.0, 0.02);
                }
                this.failureReason = FailureReason.DRY_BORE;
            }
            if (this.failureReason != FailureReason.NONE) {
                if (this.boreSpeed != 0.0f) {
                    this.offset = (int)this.offset;
                    if (!this.boringPos.equals((Object)globalPos)) {
                        this.offset -= 1.0f;
                    }
                }
                this.stopBoringState();
                return true;
            }
            this.failureReason = FailureReason.NONE;
            isBoringBlock = true;
            class_22482 = latheBlockInfo.comp_1342().method_26204();
            if (class_22482 instanceof BigCannonBlock) {
                BigCannonBlock cBlock = (BigCannonBlock)class_22482;
                f = cBlock.getCannonMaterial().properties().weight();
            } else {
                f = 1.0f;
            }
            float weight = f;
            this.boreSpeed = bearing.getAngularSpeed() / 512.0f / (weight == 0.0f ? 1.0f : weight);
            float fSpeed = Math.abs(this.boreSpeed);
            this.boreSpeed = fSpeed * Math.signum(this.getSpeed());
            this.addedStressImpact = weight;
            if (this.method_10997().method_8510() % 4L == 0L) {
                this.method_10997().method_8396(null, globalPos, class_3417.field_16865, class_3419.field_15245, 1.0f, Math.min(Math.abs(bearing.getSpeed()) / 128.0f, 2.0f));
            }
            this.notifyUpdate();
            break;
        }
        if (!isBoringBlock) {
            this.stopBoringState();
        }
        return true;
    }

    protected abstract boolean drainLubricant(int var1);

    protected void stopBoringState() {
        this.boringPos = null;
        this.boreSpeed = 0.0f;
        this.addedStressImpact = 0.0f;
        this.latheEntity = null;
    }

    protected void simulateStop() {
        this.movedContraption.setContraptionMotion(class_243.field_1353);
        this.offset = this.getGridOffset(this.offset);
        this.resetContraptionToOffset();
        this.collided();
    }

    protected void tryFinishingBoring() {
        Object cBlock;
        class_2248 class_22482;
        BearingContraption lathe;
        class_3218 slevel;
        block16: {
            block15: {
                block14: {
                    block13: {
                        class_1937 class_19372 = this.method_10997();
                        if (!(class_19372 instanceof class_3218)) break block13;
                        slevel = (class_3218)class_19372;
                        if (this.latheEntity != null && this.movedContraption != null && this.boringPos != null && this.currentRecipe != null) break block14;
                    }
                    return;
                }
                Contraption contraption = this.latheEntity.getContraption();
                if (!(contraption instanceof BearingContraption)) break block15;
                lathe = (BearingContraption)contraption;
                if (!lathe.stalled) break block16;
            }
            return;
        }
        class_2338 boringOffset = this.boringPos.method_10059((class_2382)class_2338.method_49638((class_2374)this.latheEntity.method_19538()));
        if (!lathe.getBlocks().containsKey(boringOffset)) {
            return;
        }
        class_3499.class_3501 latheBlockInfo = (class_3499.class_3501)lathe.getBlocks().get(boringOffset);
        class_2350 facing = ((CannonDrillingContraption)this.movedContraption.getContraption()).orientation();
        class_2680 boredState = this.currentRecipe.getResultState(latheBlockInfo.comp_1342());
        if (latheBlockInfo.comp_1343() != null && (class_22482 = boredState.method_26204()) instanceof IBE) {
            IBE boredBE = (IBE)class_22482;
            class_2586 be = boredBE.method_10123(class_2338.field_10980, boredState);
            latheBlockInfo.comp_1343().method_10556("JustBored", true);
            class_2248 class_22483 = boredState.method_26204();
            if (class_22483 instanceof BigCannonBlock) {
                cBlock = (BigCannonBlock)class_22483;
                if (be instanceof LayeredBigCannonBlockEntity) {
                    ICannonBlockEntity cbe2;
                    LayeredBigCannonBlockEntity layered2;
                    class_2586 be2;
                    class_3499.class_3501 prevBlockInfo;
                    ICannonBlockEntity cbe1;
                    LayeredBigCannonBlockEntity layered1;
                    class_2586 be1;
                    LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)be;
                    CannonCastShape shape = cBlock.getCannonShape();
                    class_2487 layerConnectionsTag = new class_2487();
                    class_2350 opp = facing.method_10153();
                    class_3499.class_3501 nextBlockInfo = (class_3499.class_3501)lathe.getBlocks().get(boringOffset.method_10093(facing));
                    if (nextBlockInfo != null && nextBlockInfo.comp_1343() != null && ((be1 = class_2586.method_11005((class_2338)class_2338.field_10980, (class_2680)nextBlockInfo.comp_1342(), (class_2487)nextBlockInfo.comp_1343())) instanceof LayeredBigCannonBlockEntity && (layered1 = (LayeredBigCannonBlockEntity)be1).isLayerConnectedTo(opp, shape) || be1 instanceof ICannonBlockEntity && ((CannonBehavior)((Object)(cbe1 = (ICannonBlockEntity)be1).cannonBehavior())).isConnectedTo(opp))) {
                        class_2960 key = CBCRegistries.cannonCastShapes().method_10221((Object)cBlock.getCannonShape());
                        class_2499 list = new class_2499();
                        list.add((Object)class_2519.method_23256((String)key.toString()));
                        layerConnectionsTag.method_10566(facing.method_15434(), (class_2520)list);
                    }
                    if ((prevBlockInfo = (class_3499.class_3501)lathe.getBlocks().get(boringOffset.method_10093(opp))) != null && prevBlockInfo.comp_1343() != null && ((be2 = class_2586.method_11005((class_2338)class_2338.field_10980, (class_2680)prevBlockInfo.comp_1342(), (class_2487)prevBlockInfo.comp_1343())) instanceof LayeredBigCannonBlockEntity && (layered2 = (LayeredBigCannonBlockEntity)be2).isLayerConnectedTo(facing, shape) || be2 instanceof ICannonBlockEntity && ((CannonBehavior)((Object)(cbe2 = (ICannonBlockEntity)be2).cannonBehavior())).isConnectedTo(facing))) {
                        class_2960 key = CBCRegistries.cannonCastShapes().method_10221((Object)cBlock.getCannonShape());
                        class_2499 list = new class_2499();
                        list.add((Object)class_2519.method_23256((String)key.toString()));
                        layerConnectionsTag.method_10566(opp.method_15434(), (class_2520)list);
                    }
                    latheBlockInfo.comp_1343().method_10566("LayerConnections", (class_2520)layerConnectionsTag);
                }
            }
        }
        class_2338 bearingPos = class_2338.method_49638((class_2374)this.latheEntity.getAnchorVec()).method_10093(facing);
        cBlock = this.method_10997().method_8321(bearingPos);
        if (!(cBlock instanceof MechanicalBearingBlockEntity)) {
            return;
        }
        MechanicalBearingBlockEntity bearing = (MechanicalBearingBlockEntity)cBlock;
        class_3499.class_3501 newInfo = new class_3499.class_3501(boringOffset, boredState, latheBlockInfo.comp_1343());
        lathe.getBlocks().put(boringOffset, newInfo);
        bearing.notifyUpdate();
        class_2960 unboredId = CBCRegistryUtils.getBlockLocation(latheBlockInfo.comp_1342().method_26204());
        class_52 table = slevel.method_8503().method_3857().getLootTable(CBCUtils.location(unboredId.method_12836(), "boring_scrap/" + unboredId.method_12832()));
        ObjectArrayList scrap = table.method_51878(new class_8567.class_8568(slevel).method_51874(class_181.field_1224, (Object)latheBlockInfo.comp_1342()).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.boringPos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51875(class_173.field_1172));
        scrap.forEach(s -> class_2248.method_9577((class_1937)this.method_10997(), (class_2338)this.boringPos, (class_1799)s));
        this.method_10997().method_8396(null, this.boringPos, class_3417.field_17710, class_3419.field_15245, 1.0f, 1.0f);
        NetworkPlatform.sendToClientTracking(new ClientboundUpdateContraptionPacket(this.latheEntity, boringOffset, newInfo), (class_1297)this.latheEntity);
        this.boringPos = null;
    }

    public float calculateStressApplied() {
        this.lastStressApplied = super.calculateStressApplied() + this.addedStressImpact;
        return this.lastStressApplied;
    }

    @Override
    public float getMovementSpeed() {
        float movementSpeed;
        float f = this.failureReason != FailureReason.NONE ? 0.0f : (movementSpeed = class_3532.method_15363((float)(this.boreSpeed != 0.0f ? this.boreSpeed : AbstractCannonDrillBlockEntity.convertToLinear((float)this.getSpeed())), (float)-0.49f, (float)0.49f));
        if (this.method_10997().field_9236) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)CannonDrillBlock.FACING);
        int movementModifier = facing.method_10171().method_10181() * (facing.method_10166() == class_2350.class_2351.field_11051 ? -1 : 1);
        movementSpeed = movementSpeed * (float)(-movementModifier) + this.clientOffsetDiff * 0.5f;
        movementSpeed = class_3532.method_15363((float)movementSpeed, (float)(0.0f - this.offset), (float)((float)this.extensionLength - this.offset));
        if (this.sequencedOffsetLimit >= 0.0) {
            movementSpeed = (float)class_3532.method_15350((double)movementSpeed, (double)(-this.sequencedOffsetLimit), (double)this.sequencedOffsetLimit);
        }
        return movementSpeed;
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((class_2561)class_2561.method_43473());
        this.addFluidInfoToTooltip(tooltip, isPlayerSneaking);
        if (this.failureReason != FailureReason.NONE) {
            tooltip.add((class_2561)class_2561.method_43473());
            Lang.builder((String)"exception").translate("createbigcannons.cannon_drill.tooltip.encounteredProblem", new Object[0]).style(class_124.field_1065).forGoggles(tooltip);
            class_5250 exceptionText = Lang.builder((String)"exception").translate("createbigcannons.cannon_drill.tooltip." + this.failureReason.method_15434(), new Object[0]).component();
            tooltip.addAll(TooltipHelper.cutTextComponent((class_2561)exceptionText, (class_2583)TooltipHelper.Palette.GRAY_AND_WHITE.primary(), (class_2583)TooltipHelper.Palette.GRAY_AND_WHITE.highlight(), (int)4));
        }
        return true;
    }

    protected abstract void addFluidInfoToTooltip(List<class_2561> var1, boolean var2);

    public static enum FailureReason implements class_3542
    {
        DRY_BORE("dryBore"),
        TOO_WEAK("tooWeak"),
        NONE("none");

        private static final Map<String, FailureReason> BY_ID;
        private final String id;

        private FailureReason(String id) {
            this.id = id;
        }

        public String method_15434() {
            return this.id;
        }

        public static FailureReason fromId(String id) {
            return BY_ID.getOrDefault(id, DRY_BORE);
        }

        static {
            BY_ID = Arrays.stream(FailureReason.values()).collect(Collectors.toMap(FailureReason::method_15434, Function.identity()));
        }
    }
}

