/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.config.DimensionMunitionProperties;
import rbasamoyai.createbigcannons.network.RootPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

public class DimensionMunitionPropertiesHandler {
    public static Map<class_5321<class_1937>, DimensionMunitionProperties> DIMENSIONS = new HashMap<class_5321<class_1937>, DimensionMunitionProperties>();
    private static final DimensionMunitionProperties DEFAULT = new DimensionMunitionProperties(1.0, 1.0);

    public static DimensionMunitionProperties getProperties(class_5321<class_1937> dimension) {
        return DIMENSIONS.getOrDefault(dimension, DEFAULT);
    }

    public static DimensionMunitionProperties getProperties(class_1937 level) {
        return DimensionMunitionPropertiesHandler.getProperties((class_5321<class_1937>)level.method_27983());
    }

    public static void writeBuf(class_2540 buf) {
        buf.method_10804(DIMENSIONS.size());
        for (Map.Entry<class_5321<class_1937>, DimensionMunitionProperties> entry : DIMENSIONS.entrySet()) {
            buf.method_10812(entry.getKey().method_29177());
            entry.getValue().toNetwork(buf);
        }
    }

    public static void readBuf(class_2540 buf) {
        DIMENSIONS.clear();
        int sz = buf.method_10816();
        for (int i = 0; i < sz; ++i) {
            class_2960 loc = buf.method_10810();
            class_5321 key = class_5321.method_29179(CBCRegistryUtils.getDimensionRegistryKey(), (class_2960)loc);
            DimensionMunitionProperties properties = DimensionMunitionProperties.fromNetwork(buf);
            DIMENSIONS.put((class_5321<class_1937>)key, properties);
        }
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundSyncDimensionMunitionPropertiesPacket(), server);
    }

    public static void syncTo(class_3222 player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundSyncDimensionMunitionPropertiesPacket(), player);
    }

    public record ClientboundSyncDimensionMunitionPropertiesPacket(@Nullable class_2540 buf) implements RootPacket
    {
        public ClientboundSyncDimensionMunitionPropertiesPacket() {
            this(null);
        }

        public static ClientboundSyncDimensionMunitionPropertiesPacket copyOf(class_2540 buf) {
            return new ClientboundSyncDimensionMunitionPropertiesPacket(new class_2540(buf.copy()));
        }

        @Override
        public void rootEncode(class_2540 buf) {
            DimensionMunitionPropertiesHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, class_2547 listener, @Nullable class_3222 sender) {
            if (this.buf != null) {
                DimensionMunitionPropertiesHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        protected ReloadListener() {
            super(GSON, "dimension_munition_properties");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
            DIMENSIONS.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement element = entry.getValue();
                if (!element.isJsonObject()) continue;
                try {
                    class_2960 entityLoc = entry.getKey();
                    class_5321 dimension = class_5321.method_29179(CBCRegistryUtils.getDimensionRegistryKey(), (class_2960)entry.getKey());
                    DimensionMunitionProperties properties = DimensionMunitionProperties.fromJson(element.getAsJsonObject(), entityLoc.toString());
                    DIMENSIONS.put((class_5321<class_1937>)dimension, properties);
                }
                catch (Exception exception) {}
            }
        }
    }
}

