/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.base.tag_utils.FluidTypeDataHolder;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.RootPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class FluidDragHandler {
    private static final FluidTypeDataHolder<Double> FLUID_DRAG = new FluidTypeDataHolder();

    public static void loadTags() {
        FLUID_DRAG.loadTags();
    }

    public static double getFluidDrag(class_3610 fluidState) {
        return fluidState.method_15769() ? 0.0 : FluidDragHandler.getFluidDrag(fluidState.method_15772());
    }

    public static double getFluidDrag(class_3611 fluid) {
        Double value = FLUID_DRAG.getData(fluid);
        return value == null ? 0.0 : value;
    }

    public static void writeBuf(class_2540 buf) {
        FLUID_DRAG.writeToNetwork(buf, class_2540::writeDouble);
    }

    public static void readBuf(class_2540 buf) {
        FLUID_DRAG.readFromNetwork(buf, class_2540::readDouble);
    }

    public static void syncTo(class_3222 player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundFluidDragPacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundFluidDragPacket(), server);
    }

    public record ClientboundFluidDragPacket(@Nullable class_2540 buf) implements RootPacket
    {
        public ClientboundFluidDragPacket() {
            this(null);
        }

        public static ClientboundFluidDragPacket copyOf(class_2540 buf) {
            return new ClientboundFluidDragPacket(new class_2540(buf.copy()));
        }

        @Override
        public void rootEncode(class_2540 buf) {
            FluidDragHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, class_2547 listener, @Nullable class_3222 sender) {
            if (this.buf != null) {
                FluidDragHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        ReloadListener() {
            super(GSON, "fluid_drag");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 manager, class_3695 profiler) {
            FLUID_DRAG.cleanUp();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                JsonObject obj = el.getAsJsonObject();
                double fluidDrag = Math.max(class_3518.method_34915((JsonObject)obj, (String)"fluid_drag", (double)0.0), 0.0);
                class_2960 loc = entry.getKey();
                if (loc.method_12832().startsWith("tags/")) {
                    class_6862 tag = class_6862.method_40092(CBCRegistryUtils.getFluidRegistryKey(), (class_2960)CBCUtils.location(loc.method_12836(), loc.method_12832().substring(5)));
                    FLUID_DRAG.addTagData(tag, fluidDrag);
                    continue;
                }
                class_3611 fluid = CBCRegistryUtils.getOptionalFluid(loc).orElseThrow(() -> new JsonSyntaxException("Unknown fluid type '" + loc + "'"));
                FLUID_DRAG.addData(fluid, fluidDrag);
            }
        }
    }
}

