/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import javax.annotation.Nonnull;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class SliderControl
extends ExtendedButtonControl {
    private final float minValue;
    private final float maxValue;
    private final float valueStep;
    private final String windowTitle;
    private String valueFormat = "%.1f";
    private float sliderValue;
    private float denormalizedSlideValue;
    private boolean dragging;
    private Runnable onSlideEvent;

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        super(buttonId, (int)positionData.getFirst(), (int)positionData.getSecond(), (int)dimensions.getFirst(), (int)dimensions.getSecond(), "", new String[0]);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
        this.windowTitle = displayString;
        this.setSliderValue(startValue);
    }

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Runnable onPushEvent) {
        this(buttonId, positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString);
        this.setOnClick(onPushEvent);
    }

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Pair<Runnable, Runnable> events) {
        this(buttonId, positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, events.getFirst());
        this.setOnHover(events.getSecond());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        this(ExtendedScreen.getNextIndex(), positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, new Pair<Runnable, Runnable>());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Runnable onPushEvent) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString);
        this.setOnClick(onPushEvent);
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Pair<Runnable, Runnable> events) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, events.getFirst());
        this.setOnHover(events.getSecond());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Tuple<Runnable, Runnable, Runnable> events) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, new Pair<Runnable, Runnable>(events.getFirst(), events.getSecond()));
        this.setOnSlide(events.getThird());
    }

    @Override
    protected int getYImage(boolean mouseOver) {
        return 0;
    }

    @Override
    protected void renderBg(@Nonnull class_332 matrixStack, @Nonnull class_310 mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            super.renderBg(matrixStack, mc, mouseX, mouseY);
            int hoverState = super.getYImage(this.isHoveringOrFocusingOver());
            int hoverValue = 46 + hoverState * 20;
            RenderUtils.renderButton(mc, this.getControlPosX() + (int)(this.getSliderValue(true) * (float)(this.getControlWidth() - 8)), this.getControlPosY(), 0.0, hoverValue, 196.0, hoverValue, 4.0, 20.0, this.getZLevel(), RenderUtils.getButtonTexture(mc));
        }
    }

    public void method_25348(double mouseX, double mouseY) {
        if (super.method_25361(mouseX, mouseY)) {
            this.dragging = this.isControlEnabled();
            this.setValueFromMouse(mouseX);
        }
    }

    public void method_25357(double d, double mouseY) {
        this.dragging = false;
    }

    public boolean method_25404(int keyCode, int mouseX, int mouseY) {
        boolean bl;
        boolean bl2 = bl = keyCode == 263;
        if (bl || keyCode == 262) {
            float f = bl ? -this.valueStep : this.valueStep;
            this.setSliderValue(this.getSliderValue() + f);
            this.method_25306();
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((float)(mouseX - (double)(this.getControlPosX() + 4)) / (float)(this.getControlWidth() - 8), true);
    }

    public void setSliderValue(float newValue, boolean useNormal) {
        if (useNormal) {
            this.sliderValue = MathUtils.clamp(newValue, 0.0f, 1.0f);
            this.denormalizedSlideValue = MathUtils.denormalizeValue(newValue, this.valueStep, this.minValue, this.maxValue);
        } else {
            this.sliderValue = MathUtils.normalizeValue(newValue, this.valueStep, this.minValue, this.maxValue);
            this.denormalizedSlideValue = MathUtils.clamp(newValue, this.minValue, this.maxValue);
        }
        this.onSlide();
    }

    public float getSliderValue(boolean useNormal) {
        return useNormal ? this.sliderValue : this.denormalizedSlideValue;
    }

    public float getSliderValue() {
        return this.getSliderValue(false);
    }

    public void setSliderValue(float newValue) {
        this.setSliderValue(newValue, false);
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    public void setValueFormat(String newFormat) {
        this.valueFormat = newFormat;
        this.updateMessage();
    }

    protected void method_25349(double mX, double mY, double dragX, double dragY) {
        this.setValueFromMouse(mX);
        super.method_25349(mX, mY, dragX, dragY);
    }

    public void setOnSlide(Runnable event) {
        this.onSlideEvent = event;
    }

    public void onSlide() {
        if (this.onSlideEvent != null) {
            this.onSlideEvent.run();
        }
        this.updateMessage();
    }

    public void updateMessage() {
        this.setControlMessage(this.windowTitle + ": " + String.format(this.getValueFormat(), Float.valueOf(this.getSliderValue())));
    }
}

