/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.datagen;

import com.google.gson.JsonObject;
import net.minecraft.class_2960;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.Configs;
import net.pneumono.pneumonocore.datagen.AbstractConfigCondition;
import net.pneumono.pneumonocore.datagen.enums.ConditionType;
import net.pneumono.pneumonocore.datagen.enums.Operator;

public class ConfigCondition
extends AbstractConfigCondition {
    private final class_2960 configuration;
    private final Operator operator;
    private final Object value;

    public ConfigCondition(class_2960 configuration, Operator operator, Object value) {
        super(ConditionType.CONFIG);
        this.configuration = configuration;
        this.operator = operator;
        this.value = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean conditionFulfilled() {
        AbstractConfiguration<?> config = Configs.getConfig(this.configuration.method_12836(), this.configuration.method_12832());
        if (config == null) return true;
        if (this.operator == Operator.EQUAL) {
            Object object = this.value;
            if (object instanceof String) {
                String comparedValue = (String)object;
                object = config.getValue();
                if (object instanceof String) {
                    String configValue = (String)object;
                    return comparedValue.equals(configValue);
                }
            }
            if (this.value != config.getValue()) return false;
            return true;
        }
        Object object = this.value;
        if (!(object instanceof Number)) return true;
        Number numericValue = (Number)object;
        object = config.getValue();
        if (!(object instanceof Number)) return true;
        Number numericConfigValue = (Number)object;
        double configValue = numericConfigValue.doubleValue();
        double comparedValue = numericValue.doubleValue();
        switch (this.operator) {
            case LESS: {
                if (!(configValue < comparedValue)) return false;
                return true;
            }
            case GREATER: {
                if (!(configValue > comparedValue)) return false;
                return true;
            }
            case LESS_OR_EQUAL: {
                if (!(configValue <= comparedValue)) return false;
                return true;
            }
            case GREATER_OR_EQUAL: {
                if (!(configValue >= comparedValue)) return false;
                return true;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.operator);
            }
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.getType().toString());
        object.addProperty("configuration", this.configuration.toString());
        object.addProperty("operator", this.operator.toString());
        object.addProperty("value", this.value.toString());
        return object;
    }
}

