/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.machines.IComponent;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2487;

public class IntegerHistoryComponent<K extends Enum<K>>
implements IComponent {
    protected final Map<K, int[]> histories;
    protected final int[] updatingValues;
    protected final double[] averages;
    private final K[] keys;
    private final int tickHistorySize;

    public IntegerHistoryComponent(Class<K> keyType, int tickHistorySize) {
        this.keys = (Enum[])keyType.getEnumConstants();
        this.tickHistorySize = tickHistorySize;
        this.histories = new EnumMap<K, int[]>(keyType);
        this.updatingValues = new int[this.keys.length];
        this.averages = new double[this.keys.length];
        for (K key : this.keys) {
            this.histories.put(key, new int[tickHistorySize]);
        }
    }

    @Override
    public void writeNbt(class_2487 tag) {
        for (K key : this.keys) {
            tag.method_10539(((Enum)key).toString(), this.histories.get(key));
        }
    }

    @Override
    public void readNbt(class_2487 tag) {
        for (K key : this.keys) {
            int[] array;
            String keyString = ((Enum)key).toString();
            if (tag.method_10545(keyString) && (array = tag.method_10561(keyString)).length == this.tickHistorySize) {
                this.histories.put(key, array);
                continue;
            }
            this.histories.put(key, new int[this.tickHistorySize]);
        }
        for (K key : this.keys) {
            int[] values;
            double avg = 0.0;
            for (int value : values = this.histories.get(key)) {
                avg += (double)value;
            }
            this.averages[((Enum)key).ordinal()] = avg / (double)this.tickHistorySize;
        }
    }

    public double getAverage(K key) {
        double ret = this.averages[((Enum)key).ordinal()];
        return Math.abs(ret) < 1.0E-9 ? 0.0 : ret;
    }

    public void clear() {
        for (int[] array : this.histories.values()) {
            Arrays.fill(array, 0);
        }
        Arrays.fill(this.updatingValues, 0);
        Arrays.fill(this.averages, 0.0);
    }

    public void tick() {
        for (K key : this.keys) {
            int i = ((Enum)key).ordinal();
            int[] valuesArray = this.histories.get(key);
            int n = i;
            this.averages[n] = this.averages[n] + (double)(this.updatingValues[i] - valuesArray[this.tickHistorySize - 1]) / (double)this.tickHistorySize;
            System.arraycopy(valuesArray, 0, valuesArray, 1, this.tickHistorySize - 1);
            valuesArray[0] = this.updatingValues[i];
            this.updatingValues[i] = 0;
        }
    }

    public void addValue(K key, int delta) {
        int n = ((Enum)key).ordinal();
        this.updatingValues[n] = this.updatingValues[n] + delta;
    }
}

